<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransferAccountInput ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransferAccountInput extends AbstractStructArrayBase
{
    /**
     * The TransferAccountInput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\TransferAccountInput[]
     */
    public $TransferAccountInput;
    /**
     * Constructor method for ArrayOfTransferAccountInput
     * @uses ArrayOfTransferAccountInput::setTransferAccountInput()
     * @param \CustomerManagement\StructType\TransferAccountInput[] $transferAccountInput
     */
    public function __construct(array $transferAccountInput = array())
    {
        $this
            ->setTransferAccountInput($transferAccountInput);
    }
    /**
     * Get TransferAccountInput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\TransferAccountInput[]|null
     */
    public function getTransferAccountInput()
    {
        return isset($this->TransferAccountInput) ? $this->TransferAccountInput : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferAccountInput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferAccountInput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferAccountInputForArrayConstraintsFromSetTransferAccountInput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransferAccountInputTransferAccountInputItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransferAccountInputTransferAccountInputItem instanceof \CustomerManagement\StructType\TransferAccountInput) {
                $invalidValues[] = is_object($arrayOfTransferAccountInputTransferAccountInputItem) ? get_class($arrayOfTransferAccountInputTransferAccountInputItem) : sprintf('%s(%s)', gettype($arrayOfTransferAccountInputTransferAccountInputItem), var_export($arrayOfTransferAccountInputTransferAccountInputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferAccountInput property can only contain items of type \CustomerManagement\StructType\TransferAccountInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferAccountInput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\TransferAccountInput[] $transferAccountInput
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountInput
     */
    public function setTransferAccountInput(array $transferAccountInput = array())
    {
        // validation for constraint: array
        if ('' !== ($transferAccountInputArrayErrorMessage = self::validateTransferAccountInputForArrayConstraintsFromSetTransferAccountInput($transferAccountInput))) {
            throw new \InvalidArgumentException($transferAccountInputArrayErrorMessage, __LINE__);
        }
        if (is_null($transferAccountInput) || (is_array($transferAccountInput) && empty($transferAccountInput))) {
            unset($this->TransferAccountInput);
        } else {
            $this->TransferAccountInput = $transferAccountInput;
        }
        return $this;
    }
    /**
     * Add item to TransferAccountInput value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\TransferAccountInput $item
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountInput
     */
    public function addToTransferAccountInput(\CustomerManagement\StructType\TransferAccountInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\TransferAccountInput) {
            throw new \InvalidArgumentException(sprintf('The TransferAccountInput property can only contain items of type \CustomerManagement\StructType\TransferAccountInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferAccountInput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\TransferAccountInput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\TransferAccountInput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\TransferAccountInput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\TransferAccountInput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\TransferAccountInput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferAccountInput
     */
    public function getAttributeName()
    {
        return 'TransferAccountInput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
