<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnsiteWrapUpResult StructType
 * @subpackage Structs
 */
class OnsiteWrapUpResult extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The CompletionDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CompletionDateUtc;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for OnsiteWrapUpResult
     * @uses OnsiteWrapUpResult::setAction()
     * @uses OnsiteWrapUpResult::setStatus()
     * @uses OnsiteWrapUpResult::setCompletionDateUtc()
     * @uses OnsiteWrapUpResult::setName()
     * @param string $action
     * @param string $status
     * @param string $completionDateUtc
     * @param string $name
     */
    public function __construct($action = null, $status = null, $completionDateUtc = null, $name = null)
    {
        $this
            ->setAction($action)
            ->setStatus($status)
            ->setCompletionDateUtc($completionDateUtc)
            ->setName($name);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \CustomerManagement\EnumType\OnsiteWrapUpActionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\OnsiteWrapUpActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \CustomerManagement\StructType\OnsiteWrapUpResult
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\OnsiteWrapUpActionEnum::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\OnsiteWrapUpActionEnum', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \CustomerManagement\EnumType\OnsiteWrapUpActionEnum::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\TaskStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TaskStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\OnsiteWrapUpResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TaskStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TaskStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\TaskStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CompletionDateUtc value
     * @return string
     */
    public function getCompletionDateUtc()
    {
        return $this->CompletionDateUtc;
    }
    /**
     * Set CompletionDateUtc value
     * @param string $completionDateUtc
     * @return \CustomerManagement\StructType\OnsiteWrapUpResult
     */
    public function setCompletionDateUtc($completionDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($completionDateUtc) && !is_string($completionDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionDateUtc, true), gettype($completionDateUtc)), __LINE__);
        }
        $this->CompletionDateUtc = $completionDateUtc;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \CustomerManagement\StructType\OnsiteWrapUpResult
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\OnsiteWrapUpResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
