<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckPanelSettingsBackupInput StructType
 * @subpackage Structs
 */
class CheckPanelSettingsBackupInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The OldestBackupAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OldestBackupAllowed;
    /**
     * Constructor method for CheckPanelSettingsBackupInput
     * @uses CheckPanelSettingsBackupInput::setCustomerId()
     * @uses CheckPanelSettingsBackupInput::setOldestBackupAllowed()
     * @param int $customerId
     * @param string $oldestBackupAllowed
     */
    public function __construct($customerId = null, $oldestBackupAllowed = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setOldestBackupAllowed($oldestBackupAllowed);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get OldestBackupAllowed value
     * @return string
     */
    public function getOldestBackupAllowed()
    {
        return $this->OldestBackupAllowed;
    }
    /**
     * Set OldestBackupAllowed value
     * @param string $oldestBackupAllowed
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupInput
     */
    public function setOldestBackupAllowed($oldestBackupAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($oldestBackupAllowed) && !is_string($oldestBackupAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldestBackupAllowed, true), gettype($oldestBackupAllowed)), __LINE__);
        }
        $this->OldestBackupAllowed = $oldestBackupAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
