<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for VoiceAccessLevelEnum EnumType
 * @subpackage Enumerations
 */
class VoiceAccessLevelEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'OnDemand'
     * @return string 'OnDemand'
     */
    const VALUE_ON_DEMAND = 'OnDemand';
    /**
     * Constant for value 'AlwaysOn'
     * @return string 'AlwaysOn'
     */
    const VALUE_ALWAYS_ON = 'AlwaysOn';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ON_DEMAND
     * @uses self::VALUE_ALWAYS_ON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ON_DEMAND,
            self::VALUE_ALWAYS_ON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
