<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEnrolledInMaintenance StructType
 * @subpackage Structs
 */
class UpdateEnrolledInMaintenance extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The enrolledInMaintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $enrolledInMaintenance;
    /**
     * Constructor method for UpdateEnrolledInMaintenance
     * @uses UpdateEnrolledInMaintenance::setCustomerId()
     * @uses UpdateEnrolledInMaintenance::setEnrolledInMaintenance()
     * @param int $customerId
     * @param bool $enrolledInMaintenance
     */
    public function __construct($customerId = null, $enrolledInMaintenance = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setEnrolledInMaintenance($enrolledInMaintenance);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateEnrolledInMaintenance
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get enrolledInMaintenance value
     * @return bool
     */
    public function getEnrolledInMaintenance()
    {
        return $this->enrolledInMaintenance;
    }
    /**
     * Set enrolledInMaintenance value
     * @param bool $enrolledInMaintenance
     * @return \CustomerManagement\StructType\UpdateEnrolledInMaintenance
     */
    public function setEnrolledInMaintenance($enrolledInMaintenance = null)
    {
        // validation for constraint: boolean
        if (!is_null($enrolledInMaintenance) && !is_bool($enrolledInMaintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enrolledInMaintenance, true), gettype($enrolledInMaintenance)), __LINE__);
        }
        $this->enrolledInMaintenance = $enrolledInMaintenance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateEnrolledInMaintenance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
