<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for QolsysPanelResetOptionEnum EnumType
 * @subpackage Enumerations
 */
class QolsysPanelResetOptionEnum
{
    /**
     * Constant for value 'RebootPanel'
     * @return string 'RebootPanel'
     */
    const VALUE_REBOOT_PANEL = 'RebootPanel';
    /**
     * Constant for value 'HomeApplication'
     * @return string 'HomeApplication'
     */
    const VALUE_HOME_APPLICATION = 'HomeApplication';
    /**
     * Constant for value 'QolsysService'
     * @return string 'QolsysService'
     */
    const VALUE_QOLSYS_SERVICE = 'QolsysService';
    /**
     * Constant for value 'ADCService'
     * @return string 'ADCService'
     */
    const VALUE_ADCSERVICE = 'ADCService';
    /**
     * Constant for value 'ADCApp'
     * @return string 'ADCApp'
     */
    const VALUE_ADCAPP = 'ADCApp';
    /**
     * Constant for value 'ZWaveController'
     * @return string 'ZWaveController'
     */
    const VALUE_ZWAVE_CONTROLLER = 'ZWaveController';
    /**
     * Constant for value 'CellularRadio'
     * @return string 'CellularRadio'
     */
    const VALUE_CELLULAR_RADIO = 'CellularRadio';
    /**
     * Constant for value 'ImageSensorDaughterBoard'
     * @return string 'ImageSensorDaughterBoard'
     */
    const VALUE_IMAGE_SENSOR_DAUGHTER_BOARD = 'ImageSensorDaughterBoard';
    /**
     * Constant for value 'WifiRadio'
     * @return string 'WifiRadio'
     */
    const VALUE_WIFI_RADIO = 'WifiRadio';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REBOOT_PANEL
     * @uses self::VALUE_HOME_APPLICATION
     * @uses self::VALUE_QOLSYS_SERVICE
     * @uses self::VALUE_ADCSERVICE
     * @uses self::VALUE_ADCAPP
     * @uses self::VALUE_ZWAVE_CONTROLLER
     * @uses self::VALUE_CELLULAR_RADIO
     * @uses self::VALUE_IMAGE_SENSOR_DAUGHTER_BOARD
     * @uses self::VALUE_WIFI_RADIO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REBOOT_PANEL,
            self::VALUE_HOME_APPLICATION,
            self::VALUE_QOLSYS_SERVICE,
            self::VALUE_ADCSERVICE,
            self::VALUE_ADCAPP,
            self::VALUE_ZWAVE_CONTROLLER,
            self::VALUE_CELLULAR_RADIO,
            self::VALUE_IMAGE_SENSOR_DAUGHTER_BOARD,
            self::VALUE_WIFI_RADIO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
