<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for OnsiteActionStatusEnum EnumType
 * @subpackage Enumerations
 */
class OnsiteActionStatusEnum
{
    /**
     * Constant for value 'Incomplete'
     * @return string 'Incomplete'
     */
    const VALUE_INCOMPLETE = 'Incomplete';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'Skipped'
     * @return string 'Skipped'
     */
    const VALUE_SKIPPED = 'Skipped';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INCOMPLETE
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_SKIPPED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCOMPLETE,
            self::VALUE_COMPLETE,
            self::VALUE_SKIPPED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
