<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePanelCommunicationSetting StructType
 * @subpackage Structs
 */
class UpdatePanelCommunicationSetting extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The communicationSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $communicationSetting;
    /**
     * Constructor method for UpdatePanelCommunicationSetting
     * @uses UpdatePanelCommunicationSetting::setCustomerId()
     * @uses UpdatePanelCommunicationSetting::setCommunicationSetting()
     * @param int $customerId
     * @param string $communicationSetting
     */
    public function __construct($customerId = null, $communicationSetting = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCommunicationSetting($communicationSetting);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdatePanelCommunicationSetting
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get communicationSetting value
     * @return string
     */
    public function getCommunicationSetting()
    {
        return $this->communicationSetting;
    }
    /**
     * Set communicationSetting value
     * @uses \CustomerManagement\EnumType\DualPathCommunicationSettingEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DualPathCommunicationSettingEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communicationSetting
     * @return \CustomerManagement\StructType\UpdatePanelCommunicationSetting
     */
    public function setCommunicationSetting($communicationSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DualPathCommunicationSettingEnum::valueIsValid($communicationSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $communicationSetting, implode(', ', \CustomerManagement\EnumType\DualPathCommunicationSettingEnum::getValidValues())), __LINE__);
        }
        $this->communicationSetting = $communicationSetting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdatePanelCommunicationSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
