<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetElectricityPlansInput StructType
 * @subpackage Structs
 */
class GetElectricityPlansInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LseId;
    /**
     * Constructor method for GetElectricityPlansInput
     * @uses GetElectricityPlansInput::setCustomerId()
     * @uses GetElectricityPlansInput::setLseId()
     * @param int $customerId
     * @param int $lseId
     */
    public function __construct($customerId = null, $lseId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLseId($lseId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetElectricityPlansInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LseId value
     * @return int
     */
    public function getLseId()
    {
        return $this->LseId;
    }
    /**
     * Set LseId value
     * @param int $lseId
     * @return \CustomerManagement\StructType\GetElectricityPlansInput
     */
    public function setLseId($lseId = null)
    {
        // validation for constraint: int
        if (!is_null($lseId) && !is_numeric($lseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lseId)), __LINE__);
        }
        $this->LseId = $lseId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetElectricityPlansInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
