<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for MessagePermissionEnum EnumType
 * @subpackage Enumerations
 */
class MessagePermissionEnum
{
    /**
     * Constant for value 'AlwaysReadWrite'
     * @return string 'AlwaysReadWrite'
     */
    const VALUE_ALWAYS_READ_WRITE = 'AlwaysReadWrite';
    /**
     * Constant for value 'AlwaysRead'
     * @return string 'AlwaysRead'
     */
    const VALUE_ALWAYS_READ = 'AlwaysRead';
    /**
     * Constant for value 'AlwaysNone'
     * @return string 'AlwaysNone'
     */
    const VALUE_ALWAYS_NONE = 'AlwaysNone';
    /**
     * Constant for value 'CompleteCustomerControl'
     * @return string 'CompleteCustomerControl'
     */
    const VALUE_COMPLETE_CUSTOMER_CONTROL = 'CompleteCustomerControl';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_READ_WRITE
     * @uses self::VALUE_ALWAYS_READ
     * @uses self::VALUE_ALWAYS_NONE
     * @uses self::VALUE_COMPLETE_CUSTOMER_CONTROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_READ_WRITE,
            self::VALUE_ALWAYS_READ,
            self::VALUE_ALWAYS_NONE,
            self::VALUE_COMPLETE_CUSTOMER_CONTROL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
