<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for HistoryEventTypeEnum EnumType
 * @subpackage Enumerations
 */
class HistoryEventTypeEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Tamper'
     * @return string 'Tamper'
     */
    const VALUE_TAMPER = 'Tamper';
    /**
     * Constant for value 'Opened'
     * @return string 'Opened'
     */
    const VALUE_OPENED = 'Opened';
    /**
     * Constant for value 'OpenedClosed'
     * @return string 'OpenedClosed'
     */
    const VALUE_OPENED_CLOSED = 'OpenedClosed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_TAMPER
     * @uses self::VALUE_OPENED
     * @uses self::VALUE_OPENED_CLOSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CLOSED,
            self::VALUE_TAMPER,
            self::VALUE_OPENED,
            self::VALUE_OPENED_CLOSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
