<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceSettingBackupInfo StructType
 * @subpackage Structs
 */
class DeviceSettingBackupInfo extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The BackedUpSettingsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BackedUpSettingsCount;
    /**
     * The OldestValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OldestValue;
    /**
     * The NewestValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NewestValue;
    /**
     * Constructor method for DeviceSettingBackupInfo
     * @uses DeviceSettingBackupInfo::setDeviceId()
     * @uses DeviceSettingBackupInfo::setBackedUpSettingsCount()
     * @uses DeviceSettingBackupInfo::setOldestValue()
     * @uses DeviceSettingBackupInfo::setNewestValue()
     * @param int $deviceId
     * @param int $backedUpSettingsCount
     * @param string $oldestValue
     * @param string $newestValue
     */
    public function __construct($deviceId = null, $backedUpSettingsCount = null, $oldestValue = null, $newestValue = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setBackedUpSettingsCount($backedUpSettingsCount)
            ->setOldestValue($oldestValue)
            ->setNewestValue($newestValue);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\DeviceSettingBackupInfo
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get BackedUpSettingsCount value
     * @return int
     */
    public function getBackedUpSettingsCount()
    {
        return $this->BackedUpSettingsCount;
    }
    /**
     * Set BackedUpSettingsCount value
     * @param int $backedUpSettingsCount
     * @return \CustomerManagement\StructType\DeviceSettingBackupInfo
     */
    public function setBackedUpSettingsCount($backedUpSettingsCount = null)
    {
        // validation for constraint: int
        if (!is_null($backedUpSettingsCount) && !(is_int($backedUpSettingsCount) || ctype_digit($backedUpSettingsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($backedUpSettingsCount, true), gettype($backedUpSettingsCount)), __LINE__);
        }
        $this->BackedUpSettingsCount = $backedUpSettingsCount;
        return $this;
    }
    /**
     * Get OldestValue value
     * @return string
     */
    public function getOldestValue()
    {
        return $this->OldestValue;
    }
    /**
     * Set OldestValue value
     * @param string $oldestValue
     * @return \CustomerManagement\StructType\DeviceSettingBackupInfo
     */
    public function setOldestValue($oldestValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldestValue) && !is_string($oldestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldestValue, true), gettype($oldestValue)), __LINE__);
        }
        $this->OldestValue = $oldestValue;
        return $this;
    }
    /**
     * Get NewestValue value
     * @return string
     */
    public function getNewestValue()
    {
        return $this->NewestValue;
    }
    /**
     * Set NewestValue value
     * @param string $newestValue
     * @return \CustomerManagement\StructType\DeviceSettingBackupInfo
     */
    public function setNewestValue($newestValue = null)
    {
        // validation for constraint: string
        if (!is_null($newestValue) && !is_string($newestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newestValue, true), gettype($newestValue)), __LINE__);
        }
        $this->NewestValue = $newestValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\DeviceSettingBackupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
