<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerListItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerListItem extends AbstractStructArrayBase
{
    /**
     * The CustomerListItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CustomerListItem[]
     */
    public $CustomerListItem;
    /**
     * Constructor method for ArrayOfCustomerListItem
     * @uses ArrayOfCustomerListItem::setCustomerListItem()
     * @param \CustomerManagement\StructType\CustomerListItem[] $customerListItem
     */
    public function __construct(array $customerListItem = array())
    {
        $this
            ->setCustomerListItem($customerListItem);
    }
    /**
     * Get CustomerListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CustomerListItem[]|null
     */
    public function getCustomerListItem()
    {
        return isset($this->CustomerListItem) ? $this->CustomerListItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerListItemForArrayConstraintsFromSetCustomerListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerListItemCustomerListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerListItemCustomerListItemItem instanceof \CustomerManagement\StructType\CustomerListItem) {
                $invalidValues[] = is_object($arrayOfCustomerListItemCustomerListItemItem) ? get_class($arrayOfCustomerListItemCustomerListItemItem) : sprintf('%s(%s)', gettype($arrayOfCustomerListItemCustomerListItemItem), var_export($arrayOfCustomerListItemCustomerListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerListItem property can only contain items of type \CustomerManagement\StructType\CustomerListItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerListItem[] $customerListItem
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerListItem
     */
    public function setCustomerListItem(array $customerListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($customerListItemArrayErrorMessage = self::validateCustomerListItemForArrayConstraintsFromSetCustomerListItem($customerListItem))) {
            throw new \InvalidArgumentException($customerListItemArrayErrorMessage, __LINE__);
        }
        if (is_null($customerListItem) || (is_array($customerListItem) && empty($customerListItem))) {
            unset($this->CustomerListItem);
        } else {
            $this->CustomerListItem = $customerListItem;
        }
        return $this;
    }
    /**
     * Add item to CustomerListItem value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerListItem $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerListItem
     */
    public function addToCustomerListItem(\CustomerManagement\StructType\CustomerListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CustomerListItem) {
            throw new \InvalidArgumentException(sprintf('The CustomerListItem property can only contain items of type \CustomerManagement\StructType\CustomerListItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CustomerListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CustomerListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CustomerListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CustomerListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CustomerListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerListItem
     */
    public function getAttributeName()
    {
        return 'CustomerListItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
