<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeaturePrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfFeaturePrice extends AbstractStructArrayBase
{
    /**
     * The FeaturePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\FeaturePrice[]
     */
    public $FeaturePrice;
    /**
     * Constructor method for ArrayOfFeaturePrice
     * @uses ArrayOfFeaturePrice::setFeaturePrice()
     * @param \CustomerManagement\StructType\FeaturePrice[] $featurePrice
     */
    public function __construct(array $featurePrice = array())
    {
        $this
            ->setFeaturePrice($featurePrice);
    }
    /**
     * Get FeaturePrice value
     * @return \CustomerManagement\StructType\FeaturePrice[]|null
     */
    public function getFeaturePrice()
    {
        return $this->FeaturePrice;
    }
    /**
     * This method is responsible for validating the values passed to the setFeaturePrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeaturePrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeaturePriceForArrayConstraintsFromSetFeaturePrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFeaturePriceFeaturePriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeaturePriceFeaturePriceItem instanceof \CustomerManagement\StructType\FeaturePrice) {
                $invalidValues[] = is_object($arrayOfFeaturePriceFeaturePriceItem) ? get_class($arrayOfFeaturePriceFeaturePriceItem) : sprintf('%s(%s)', gettype($arrayOfFeaturePriceFeaturePriceItem), var_export($arrayOfFeaturePriceFeaturePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeaturePrice property can only contain items of type \CustomerManagement\StructType\FeaturePrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeaturePrice value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\FeaturePrice[] $featurePrice
     * @return \CustomerManagement\ArrayType\ArrayOfFeaturePrice
     */
    public function setFeaturePrice(array $featurePrice = array())
    {
        // validation for constraint: array
        if ('' !== ($featurePriceArrayErrorMessage = self::validateFeaturePriceForArrayConstraintsFromSetFeaturePrice($featurePrice))) {
            throw new \InvalidArgumentException($featurePriceArrayErrorMessage, __LINE__);
        }
        $this->FeaturePrice = $featurePrice;
        return $this;
    }
    /**
     * Add item to FeaturePrice value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\FeaturePrice $item
     * @return \CustomerManagement\ArrayType\ArrayOfFeaturePrice
     */
    public function addToFeaturePrice(\CustomerManagement\StructType\FeaturePrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\FeaturePrice) {
            throw new \InvalidArgumentException(sprintf('The FeaturePrice property can only contain items of type \CustomerManagement\StructType\FeaturePrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FeaturePrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\FeaturePrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\FeaturePrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\FeaturePrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\FeaturePrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\FeaturePrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeaturePrice
     */
    public function getAttributeName()
    {
        return 'FeaturePrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfFeaturePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
