<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageSensorUploadsInput StructType
 * @subpackage Structs
 */
class ImageSensorUploadsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The InitialEventId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InitialEventId;
    /**
     * The EndEventId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EndEventId;
    /**
     * Constructor method for ImageSensorUploadsInput
     * @uses ImageSensorUploadsInput::setCustomerId()
     * @uses ImageSensorUploadsInput::setDeviceId()
     * @uses ImageSensorUploadsInput::setInitialEventId()
     * @uses ImageSensorUploadsInput::setEndEventId()
     * @param int $customerId
     * @param int $deviceId
     * @param int $initialEventId
     * @param int $endEventId
     */
    public function __construct($customerId = null, $deviceId = null, $initialEventId = null, $endEventId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setInitialEventId($initialEventId)
            ->setEndEventId($endEventId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ImageSensorUploadsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\ImageSensorUploadsInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get InitialEventId value
     * @return int
     */
    public function getInitialEventId()
    {
        return $this->InitialEventId;
    }
    /**
     * Set InitialEventId value
     * @param int $initialEventId
     * @return \CustomerManagement\StructType\ImageSensorUploadsInput
     */
    public function setInitialEventId($initialEventId = null)
    {
        // validation for constraint: int
        if (!is_null($initialEventId) && !(is_int($initialEventId) || ctype_digit($initialEventId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initialEventId, true), gettype($initialEventId)), __LINE__);
        }
        $this->InitialEventId = $initialEventId;
        return $this;
    }
    /**
     * Get EndEventId value
     * @return int
     */
    public function getEndEventId()
    {
        return $this->EndEventId;
    }
    /**
     * Set EndEventId value
     * @param int $endEventId
     * @return \CustomerManagement\StructType\ImageSensorUploadsInput
     */
    public function setEndEventId($endEventId = null)
    {
        // validation for constraint: int
        if (!is_null($endEventId) && !(is_int($endEventId) || ctype_digit($endEventId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endEventId, true), gettype($endEventId)), __LINE__);
        }
        $this->EndEventId = $endEventId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ImageSensorUploadsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
