<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDayOfWeek ArrayType
 * @subpackage Arrays
 */
class ArrayOfDayOfWeek extends AbstractStructArrayBase
{
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DayOfWeek;
    /**
     * Constructor method for ArrayOfDayOfWeek
     * @uses ArrayOfDayOfWeek::setDayOfWeek()
     * @param string[] $dayOfWeek
     */
    public function __construct(array $dayOfWeek = array())
    {
        $this
            ->setDayOfWeek($dayOfWeek);
    }
    /**
     * Get DayOfWeek value
     * @return string[]|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * This method is responsible for validating the values passed to the setDayOfWeek method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDayOfWeek method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDayOfWeekForArrayConstraintsFromSetDayOfWeek(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDayOfWeekDayOfWeekItem) {
            // validation for constraint: enumeration
            if (!\CustomerManagement\EnumType\DayOfWeek::valueIsValid($arrayOfDayOfWeekDayOfWeekItem)) {
                $invalidValues[] = is_object($arrayOfDayOfWeekDayOfWeekItem) ? get_class($arrayOfDayOfWeekDayOfWeekItem) : sprintf('%s(%s)', gettype($arrayOfDayOfWeekDayOfWeekItem), var_export($arrayOfDayOfWeekDayOfWeekItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DayOfWeek', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CustomerManagement\EnumType\DayOfWeek::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DayOfWeek value
     * @uses \CustomerManagement\EnumType\DayOfWeek::valueIsValid()
     * @uses \CustomerManagement\EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dayOfWeek
     * @return \CustomerManagement\ArrayType\ArrayOfDayOfWeek
     */
    public function setDayOfWeek(array $dayOfWeek = array())
    {
        // validation for constraint: array
        if ('' !== ($dayOfWeekArrayErrorMessage = self::validateDayOfWeekForArrayConstraintsFromSetDayOfWeek($dayOfWeek))) {
            throw new \InvalidArgumentException($dayOfWeekArrayErrorMessage, __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Add item to DayOfWeek value
     * @uses \CustomerManagement\EnumType\DayOfWeek::valueIsValid()
     * @uses \CustomerManagement\EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDayOfWeek
     */
    public function addToDayOfWeek($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DayOfWeek::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DayOfWeek', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        $this->DayOfWeek[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\DayOfWeek::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDayOfWeek
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DayOfWeek::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DayOfWeek', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DayOfWeek
     */
    public function getAttributeName()
    {
        return 'DayOfWeek';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfDayOfWeek
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
