<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for MessagePermissionLevelEnum EnumType
 * @subpackage Enumerations
 */
class MessagePermissionLevelEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Constant for value 'ReadWrite'
     * @return string 'ReadWrite'
     */
    const VALUE_READ_WRITE = 'ReadWrite';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_READ
     * @uses self::VALUE_READ_WRITE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_READ,
            self::VALUE_READ_WRITE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
