<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetImageSensorSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Configure settings for image sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetImageSensorSettings $parameters
     * @return \CustomerManagement\StructType\SetImageSensorSettingsResponse|bool
     */
    public function SetImageSensorSettings(\CustomerManagement\StructType\SetImageSensorSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetImageSensorSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAutoPhoneTestSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Set the auto-phone test parameters in the panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetAutoPhoneTestSettings $parameters
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsResponse|bool
     */
    public function SetAutoPhoneTestSettings(\CustomerManagement\StructType\SetAutoPhoneTestSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetAutoPhoneTestSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetWifi
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Connect to the specified Wi-Fi network.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetWifi $parameters
     * @return \CustomerManagement\StructType\SetWifiResponse|bool
     */
    public function SetWifi(\CustomerManagement\StructType\SetWifi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetWifi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetVoiceAccessLevels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sets the customers voice access levels for PSU/Report State.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetVoiceAccessLevels $parameters
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsResponse|bool
     */
    public function SetVoiceAccessLevels(\CustomerManagement\StructType\SetVoiceAccessLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetVoiceAccessLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetGsmBandSelection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Forces a radio to a particular cellular band, then tells it to disconnect, and submits a delayed signal strength request. This method is designed for getting affected customers for a 2G turndown using an alarm.com-supplied tool.
     * Please contact kroach@alarm.com for the tool.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetGsmBandSelection $parameters
     * @return \CustomerManagement\StructType\SetGsmBandSelectionResponse|bool
     */
    public function SetGsmBandSelection(\CustomerManagement\StructType\SetGsmBandSelection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetGsmBandSelection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAddOnQuantity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the quantity of an addon in the customer's service plan. Pass 0 to remove it, and 1 for addons that don't have quantities.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetAddOnQuantity $parameters
     * @return \CustomerManagement\StructType\SetAddOnQuantityResponse|bool
     */
    public function SetAddOnQuantity(\CustomerManagement\StructType\SetAddOnQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetAddOnQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetImageSensorPartition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sets group and partition information about an image sensor camera.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetImageSensorPartition $parameters
     * @return \CustomerManagement\StructType\SetImageSensorPartitionResponse|bool
     */
    public function SetImageSensorPartition(\CustomerManagement\StructType\SetImageSensorPartition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetImageSensorPartition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPauseNotificationsForCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Pauses (or unpauses) a customer's notifications until the set date in UTC (null to unpause).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetPauseNotificationsForCustomer $parameters
     * @return \CustomerManagement\StructType\SetPauseNotificationsForCustomerResponse|bool
     */
    public function SetPauseNotificationsForCustomer(\CustomerManagement\StructType\SetPauseNotificationsForCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPauseNotificationsForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\SetAddOnQuantityResponse|\CustomerManagement\StructType\SetAutoPhoneTestSettingsResponse|\CustomerManagement\StructType\SetGsmBandSelectionResponse|\CustomerManagement\StructType\SetImageSensorPartitionResponse|\CustomerManagement\StructType\SetImageSensorSettingsResponse|\CustomerManagement\StructType\SetPauseNotificationsForCustomerResponse|\CustomerManagement\StructType\SetVoiceAccessLevelsResponse|\CustomerManagement\StructType\SetWifiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
