<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestUpdatedEquipmentList StructType
 * @subpackage Structs
 */
class RequestUpdatedEquipmentList extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The maxZones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxZones;
    /**
     * Constructor method for RequestUpdatedEquipmentList
     * @uses RequestUpdatedEquipmentList::setCustomerId()
     * @uses RequestUpdatedEquipmentList::setMaxZones()
     * @param int $customerId
     * @param int $maxZones
     */
    public function __construct($customerId = null, $maxZones = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setMaxZones($maxZones);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentList
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get maxZones value
     * @return int
     */
    public function getMaxZones()
    {
        return $this->maxZones;
    }
    /**
     * Set maxZones value
     * @param int $maxZones
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentList
     */
    public function setMaxZones($maxZones = null)
    {
        // validation for constraint: int
        if (!is_null($maxZones) && !is_numeric($maxZones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxZones)), __LINE__);
        }
        $this->maxZones = $maxZones;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
