<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetVoiceAccessLevelsInput StructType
 * @subpackage Structs
 */
class SetVoiceAccessLevelsInput extends AbstractStructBase
{
    /**
     * The MobileApplicationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MobileApplicationType;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * The VoiceAccessLevelMappings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping
     */
    public $VoiceAccessLevelMappings;
    /**
     * Constructor method for SetVoiceAccessLevelsInput
     * @uses SetVoiceAccessLevelsInput::setMobileApplicationType()
     * @uses SetVoiceAccessLevelsInput::setLoginNameAtAuthenticationProvider()
     * @uses SetVoiceAccessLevelsInput::setVoiceAccessLevelMappings()
     * @param string $mobileApplicationType
     * @param string $loginNameAtAuthenticationProvider
     * @param \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings
     */
    public function __construct($mobileApplicationType = null, $loginNameAtAuthenticationProvider = null, \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings = null)
    {
        $this
            ->setMobileApplicationType($mobileApplicationType)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider)
            ->setVoiceAccessLevelMappings($voiceAccessLevelMappings);
    }
    /**
     * Get MobileApplicationType value
     * @return string
     */
    public function getMobileApplicationType()
    {
        return $this->MobileApplicationType;
    }
    /**
     * Set MobileApplicationType value
     * @uses \CustomerManagement\EnumType\MobileApplicationTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MobileApplicationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileApplicationType
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsInput
     */
    public function setMobileApplicationType($mobileApplicationType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MobileApplicationTypeEnum::valueIsValid($mobileApplicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MobileApplicationTypeEnum', is_array($mobileApplicationType) ? implode(', ', $mobileApplicationType) : var_export($mobileApplicationType, true), implode(', ', \CustomerManagement\EnumType\MobileApplicationTypeEnum::getValidValues())), __LINE__);
        }
        $this->MobileApplicationType = $mobileApplicationType;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsInput
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginNameAtAuthenticationProvider, true), gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Get VoiceAccessLevelMappings value
     * @return \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping|null
     */
    public function getVoiceAccessLevelMappings()
    {
        return $this->VoiceAccessLevelMappings;
    }
    /**
     * Set VoiceAccessLevelMappings value
     * @param \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsInput
     */
    public function setVoiceAccessLevelMappings(\CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings = null)
    {
        $this->VoiceAccessLevelMappings = $voiceAccessLevelMappings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
