<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryId;
    /**
     * The Street1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Street2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The SubCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCity;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The SubState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubState;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for Address
     * @uses Address::setCountryId()
     * @uses Address::setStreet1()
     * @uses Address::setStreet2()
     * @uses Address::setSubCity()
     * @uses Address::setCity()
     * @uses Address::setSubState()
     * @uses Address::setState()
     * @uses Address::setZip()
     * @param string $countryId
     * @param string $street1
     * @param string $street2
     * @param string $subCity
     * @param string $city
     * @param string $subState
     * @param string $state
     * @param string $zip
     */
    public function __construct($countryId = null, $street1 = null, $street2 = null, $subCity = null, $city = null, $subState = null, $state = null, $zip = null)
    {
        $this
            ->setCountryId($countryId)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setSubCity($subCity)
            ->setCity($city)
            ->setSubState($subState)
            ->setState($state)
            ->setZip($zip);
    }
    /**
     * Get CountryId value
     * @return string
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @uses \CustomerManagement\EnumType\CountryEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CountryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryId
     * @return \CustomerManagement\StructType\Address
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CountryEnum::valueIsValid($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CountryEnum', is_array($countryId) ? implode(', ', $countryId) : var_export($countryId, true), implode(', ', \CustomerManagement\EnumType\CountryEnum::getValidValues())), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \CustomerManagement\StructType\Address
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \CustomerManagement\StructType\Address
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get SubCity value
     * @return string|null
     */
    public function getSubCity()
    {
        return $this->SubCity;
    }
    /**
     * Set SubCity value
     * @param string $subCity
     * @return \CustomerManagement\StructType\Address
     */
    public function setSubCity($subCity = null)
    {
        // validation for constraint: string
        if (!is_null($subCity) && !is_string($subCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCity, true), gettype($subCity)), __LINE__);
        }
        $this->SubCity = $subCity;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \CustomerManagement\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get SubState value
     * @return string|null
     */
    public function getSubState()
    {
        return $this->SubState;
    }
    /**
     * Set SubState value
     * @param string $subState
     * @return \CustomerManagement\StructType\Address
     */
    public function setSubState($subState = null)
    {
        // validation for constraint: string
        if (!is_null($subState) && !is_string($subState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subState, true), gettype($subState)), __LINE__);
        }
        $this->SubState = $subState;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \CustomerManagement\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \CustomerManagement\StructType\Address
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
