<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPauseNotificationsForCustomerOutput StructType
 * @subpackage Structs
 */
class GetPauseNotificationsForCustomerOutput extends AbstractStructBase
{
    /**
     * The NotificationsPausedUntil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NotificationsPausedUntil;
    /**
     * The CustomerHasLoggedIn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomerHasLoggedIn;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetPauseNotificationsForCustomerOutput
     * @uses GetPauseNotificationsForCustomerOutput::setNotificationsPausedUntil()
     * @uses GetPauseNotificationsForCustomerOutput::setCustomerHasLoggedIn()
     * @uses GetPauseNotificationsForCustomerOutput::setSuccess()
     * @uses GetPauseNotificationsForCustomerOutput::setErrorMessage()
     * @param string $notificationsPausedUntil
     * @param bool $customerHasLoggedIn
     * @param bool $success
     * @param string $errorMessage
     */
    public function __construct($notificationsPausedUntil = null, $customerHasLoggedIn = null, $success = null, $errorMessage = null)
    {
        $this
            ->setNotificationsPausedUntil($notificationsPausedUntil)
            ->setCustomerHasLoggedIn($customerHasLoggedIn)
            ->setSuccess($success)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get NotificationsPausedUntil value
     * @return string
     */
    public function getNotificationsPausedUntil()
    {
        return $this->NotificationsPausedUntil;
    }
    /**
     * Set NotificationsPausedUntil value
     * @param string $notificationsPausedUntil
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerOutput
     */
    public function setNotificationsPausedUntil($notificationsPausedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($notificationsPausedUntil) && !is_string($notificationsPausedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationsPausedUntil, true), gettype($notificationsPausedUntil)), __LINE__);
        }
        $this->NotificationsPausedUntil = $notificationsPausedUntil;
        return $this;
    }
    /**
     * Get CustomerHasLoggedIn value
     * @return bool
     */
    public function getCustomerHasLoggedIn()
    {
        return $this->CustomerHasLoggedIn;
    }
    /**
     * Set CustomerHasLoggedIn value
     * @param bool $customerHasLoggedIn
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerOutput
     */
    public function setCustomerHasLoggedIn($customerHasLoggedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerHasLoggedIn) && !is_bool($customerHasLoggedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerHasLoggedIn, true), gettype($customerHasLoggedIn)), __LINE__);
        }
        $this->CustomerHasLoggedIn = $customerHasLoggedIn;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
