<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerEnergyProgramEnrollmentInput StructType
 * @subpackage Structs
 */
class UpdateCustomerEnergyProgramEnrollmentInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The EnergyProgramId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnergyProgramId;
    /**
     * The NewStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NewStatus;
    /**
     * The StatusChangeComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusChangeComments;
    /**
     * Constructor method for UpdateCustomerEnergyProgramEnrollmentInput
     * @uses UpdateCustomerEnergyProgramEnrollmentInput::setCustomerId()
     * @uses UpdateCustomerEnergyProgramEnrollmentInput::setEnergyProgramId()
     * @uses UpdateCustomerEnergyProgramEnrollmentInput::setNewStatus()
     * @uses UpdateCustomerEnergyProgramEnrollmentInput::setStatusChangeComments()
     * @param int $customerId
     * @param int $energyProgramId
     * @param string $newStatus
     * @param string $statusChangeComments
     */
    public function __construct($customerId = null, $energyProgramId = null, $newStatus = null, $statusChangeComments = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setEnergyProgramId($energyProgramId)
            ->setNewStatus($newStatus)
            ->setStatusChangeComments($statusChangeComments);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get EnergyProgramId value
     * @return int
     */
    public function getEnergyProgramId()
    {
        return $this->EnergyProgramId;
    }
    /**
     * Set EnergyProgramId value
     * @param int $energyProgramId
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentInput
     */
    public function setEnergyProgramId($energyProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($energyProgramId) && !(is_int($energyProgramId) || ctype_digit($energyProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($energyProgramId, true), gettype($energyProgramId)), __LINE__);
        }
        $this->EnergyProgramId = $energyProgramId;
        return $this;
    }
    /**
     * Get NewStatus value
     * @return string
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @uses \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentInput
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum', is_array($newStatus) ? implode(', ', $newStatus) : var_export($newStatus, true), implode(', ', \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::getValidValues())), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get StatusChangeComments value
     * @return string|null
     */
    public function getStatusChangeComments()
    {
        return $this->StatusChangeComments;
    }
    /**
     * Set StatusChangeComments value
     * @param string $statusChangeComments
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentInput
     */
    public function setStatusChangeComments($statusChangeComments = null)
    {
        // validation for constraint: string
        if (!is_null($statusChangeComments) && !is_string($statusChangeComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusChangeComments, true), gettype($statusChangeComments)), __LINE__);
        }
        $this->StatusChangeComments = $statusChangeComments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
