<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for SystemCheckTestCategoryEnum EnumType
 * @subpackage Enumerations
 */
class SystemCheckTestCategoryEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Panel'
     * @return string 'Panel'
     */
    const VALUE_PANEL = 'Panel';
    /**
     * Constant for value 'ImageSensor'
     * @return string 'ImageSensor'
     */
    const VALUE_IMAGE_SENSOR = 'ImageSensor';
    /**
     * Constant for value 'Video'
     * @return string 'Video'
     */
    const VALUE_VIDEO = 'Video';
    /**
     * Constant for value 'Zwave'
     * @return string 'Zwave'
     */
    const VALUE_ZWAVE = 'Zwave';
    /**
     * Constant for value 'Engagement'
     * @return string 'Engagement'
     */
    const VALUE_ENGAGEMENT = 'Engagement';
    /**
     * Constant for value 'Communications'
     * @return string 'Communications'
     */
    const VALUE_COMMUNICATIONS = 'Communications';
    /**
     * Constant for value 'Sensors'
     * @return string 'Sensors'
     */
    const VALUE_SENSORS = 'Sensors';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_PANEL
     * @uses self::VALUE_IMAGE_SENSOR
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_ZWAVE
     * @uses self::VALUE_ENGAGEMENT
     * @uses self::VALUE_COMMUNICATIONS
     * @uses self::VALUE_SENSORS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_PANEL,
            self::VALUE_IMAGE_SENSOR,
            self::VALUE_VIDEO,
            self::VALUE_ZWAVE,
            self::VALUE_ENGAGEMENT,
            self::VALUE_COMMUNICATIONS,
            self::VALUE_SENSORS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
