<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationRemoval StructType
 * @subpackage Structs
 */
class NotificationRemoval extends AbstractStructBase
{
    /**
     * The NotificationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NotificationType;
    /**
     * Constructor method for NotificationRemoval
     * @uses NotificationRemoval::setNotificationType()
     * @param string $notificationType
     */
    public function __construct($notificationType = null)
    {
        $this
            ->setNotificationType($notificationType);
    }
    /**
     * Get NotificationType value
     * @return string
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * Set NotificationType value
     * @uses \CustomerManagement\EnumType\NotificationTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NotificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notificationType
     * @return \CustomerManagement\StructType\NotificationRemoval
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NotificationTypeEnum::valueIsValid($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NotificationTypeEnum', is_array($notificationType) ? implode(', ', $notificationType) : var_export($notificationType, true), implode(', ', \CustomerManagement\EnumType\NotificationTypeEnum::getValidValues())), __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\NotificationRemoval
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
