<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolarSystemInfo StructType
 * @subpackage Structs
 */
class SolarSystemInfo extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusDate;
    /**
     * The ProviderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProviderId;
    /**
     * The DataProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataProvider;
    /**
     * Constructor method for SolarSystemInfo
     * @uses SolarSystemInfo::setDeviceId()
     * @uses SolarSystemInfo::setStatusDate()
     * @uses SolarSystemInfo::setProviderId()
     * @uses SolarSystemInfo::setDataProvider()
     * @param int $deviceId
     * @param string $statusDate
     * @param string $providerId
     * @param string $dataProvider
     */
    public function __construct($deviceId = null, $statusDate = null, $providerId = null, $dataProvider = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setStatusDate($statusDate)
            ->setProviderId($providerId)
            ->setDataProvider($dataProvider);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SolarSystemInfo
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \CustomerManagement\StructType\SolarSystemInfo
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get ProviderId value
     * @return string|null
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param string $providerId
     * @return \CustomerManagement\StructType\SolarSystemInfo
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerId, true), gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Get DataProvider value
     * @return string|null
     */
    public function getDataProvider()
    {
        return $this->DataProvider;
    }
    /**
     * Set DataProvider value
     * @param string $dataProvider
     * @return \CustomerManagement\StructType\SolarSystemInfo
     */
    public function setDataProvider($dataProvider = null)
    {
        // validation for constraint: string
        if (!is_null($dataProvider) && !is_string($dataProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProvider, true), gettype($dataProvider)), __LINE__);
        }
        $this->DataProvider = $dataProvider;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SolarSystemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
