<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lookup ServiceType
 * @subpackage Services
 */
class Lookup extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication_1 $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication_1 $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named LookupCustomerId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication_1
     * - SOAPHeaders: required
     * - documentation: Get the Alarm.com customer_id based on the CS account information. Returns 0 if the customer is not found.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\LookupCustomerId $parameters
     * @return \CustomerManagement\StructType\LookupCustomerIdResponse|bool
     */
    public function LookupCustomerId(\CustomerManagement\StructType\LookupCustomerId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LookupCustomerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LookupCustomerIdForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication_1
     * - SOAPHeaders: required
     * - documentation: Get the Alarm.com customer_id based on the CS account information. Returns 0 if the customer is not found.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\LookupCustomerIdForDealer $parameters
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealerResponse|bool
     */
    public function LookupCustomerIdForDealer(\CustomerManagement\StructType\LookupCustomerIdForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LookupCustomerIdForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * LookupCustomerIdFromDealerCustomerId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication_1
     * - SOAPHeaders: required
     * - documentation: Get the Alarm.com customer_id based on the dealer customer id field.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\LookupCustomerIdFromDealerCustomerId $parameters
     * @return \CustomerManagement\StructType\LookupCustomerIdFromDealerCustomerIdResponse|bool
     */
    public function LookupCustomerIdFromDealerCustomerId(\CustomerManagement\StructType\LookupCustomerIdFromDealerCustomerId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LookupCustomerIdFromDealerCustomerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LookupCustomerIdFromModemSerial
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication_1
     * - SOAPHeaders: required
     * - documentation: Get the Alarm.com customer_id based on the modem serial number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\LookupCustomerIdFromModemSerial $parameters
     * @return \CustomerManagement\StructType\LookupCustomerIdFromModemSerialResponse|bool
     */
    public function LookupCustomerIdFromModemSerial(\CustomerManagement\StructType\LookupCustomerIdFromModemSerial $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LookupCustomerIdFromModemSerial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealerResponse|\CustomerManagement\StructType\LookupCustomerIdFromDealerCustomerIdResponse|\CustomerManagement\StructType\LookupCustomerIdFromModemSerialResponse|\CustomerManagement\StructType\LookupCustomerIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
