<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for ReturnUrlEnum EnumType
 * @subpackage Enumerations
 */
class ReturnUrlEnum
{
    /**
     * Constant for value 'Home'
     * @return string 'Home'
     */
    const VALUE_HOME = 'Home';
    /**
     * Constant for value 'LiveVideo'
     * @return string 'LiveVideo'
     */
    const VALUE_LIVE_VIDEO = 'LiveVideo';
    /**
     * Constant for value 'Automation'
     * @return string 'Automation'
     */
    const VALUE_AUTOMATION = 'Automation';
    /**
     * Constant for value 'Notifications'
     * @return string 'Notifications'
     */
    const VALUE_NOTIFICATIONS = 'Notifications';
    /**
     * Constant for value 'Activity'
     * @return string 'Activity'
     */
    const VALUE_ACTIVITY = 'Activity';
    /**
     * Constant for value 'Users'
     * @return string 'Users'
     */
    const VALUE_USERS = 'Users';
    /**
     * Constant for value 'EmberUsers'
     * @return string 'EmberUsers'
     */
    const VALUE_EMBER_USERS = 'EmberUsers';
    /**
     * Constant for value 'Settings'
     * @return string 'Settings'
     */
    const VALUE_SETTINGS = 'Settings';
    /**
     * Constant for value 'LoginPassword'
     * @return string 'LoginPassword'
     */
    const VALUE_LOGIN_PASSWORD = 'LoginPassword';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOME
     * @uses self::VALUE_LIVE_VIDEO
     * @uses self::VALUE_AUTOMATION
     * @uses self::VALUE_NOTIFICATIONS
     * @uses self::VALUE_ACTIVITY
     * @uses self::VALUE_USERS
     * @uses self::VALUE_EMBER_USERS
     * @uses self::VALUE_SETTINGS
     * @uses self::VALUE_LOGIN_PASSWORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOME,
            self::VALUE_LIVE_VIDEO,
            self::VALUE_AUTOMATION,
            self::VALUE_NOTIFICATIONS,
            self::VALUE_ACTIVITY,
            self::VALUE_USERS,
            self::VALUE_EMBER_USERS,
            self::VALUE_SETTINGS,
            self::VALUE_LOGIN_PASSWORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
