<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for TroubleConditionTypeEnum EnumType
 * @subpackage Enumerations
 */
class TroubleConditionTypeEnum
{
    /**
     * Constant for value 'Alarm'
     * @return string 'Alarm'
     */
    const VALUE_ALARM = 'Alarm';
    /**
     * Constant for value 'PanelDuress'
     * @return string 'PanelDuress'
     */
    const VALUE_PANEL_DURESS = 'PanelDuress';
    /**
     * Constant for value 'PanelFirePanic'
     * @return string 'PanelFirePanic'
     */
    const VALUE_PANEL_FIRE_PANIC = 'PanelFirePanic';
    /**
     * Constant for value 'PanelPolicePanic'
     * @return string 'PanelPolicePanic'
     */
    const VALUE_PANEL_POLICE_PANIC = 'PanelPolicePanic';
    /**
     * Constant for value 'PanelAuxPanic'
     * @return string 'PanelAuxPanic'
     */
    const VALUE_PANEL_AUX_PANIC = 'PanelAuxPanic';
    /**
     * Constant for value 'PanelFreezeAlarm'
     * @return string 'PanelFreezeAlarm'
     */
    const VALUE_PANEL_FREEZE_ALARM = 'PanelFreezeAlarm';
    /**
     * Constant for value 'NoActivityPanel'
     * @return string 'NoActivityPanel'
     */
    const VALUE_NO_ACTIVITY_PANEL = 'NoActivityPanel';
    /**
     * Constant for value 'NoActivitySchedule'
     * @return string 'NoActivitySchedule'
     */
    const VALUE_NO_ACTIVITY_SCHEDULE = 'NoActivitySchedule';
    /**
     * Constant for value 'KeypadTamper'
     * @return string 'KeypadTamper'
     */
    const VALUE_KEYPAD_TAMPER = 'KeypadTamper';
    /**
     * Constant for value 'PhoneLineCut'
     * @return string 'PhoneLineCut'
     */
    const VALUE_PHONE_LINE_CUT = 'PhoneLineCut';
    /**
     * Constant for value 'ModemPanelCommError'
     * @return string 'ModemPanelCommError'
     */
    const VALUE_MODEM_PANEL_COMM_ERROR = 'ModemPanelCommError';
    /**
     * Constant for value 'ModuleMalfunction'
     * @return string 'ModuleMalfunction'
     */
    const VALUE_MODULE_MALFUNCTION = 'ModuleMalfunction';
    /**
     * Constant for value 'SensorMalfunction'
     * @return string 'SensorMalfunction'
     */
    const VALUE_SENSOR_MALFUNCTION = 'SensorMalfunction';
    /**
     * Constant for value 'RadioOff'
     * @return string 'RadioOff'
     */
    const VALUE_RADIO_OFF = 'RadioOff';
    /**
     * Constant for value 'ACFailure'
     * @return string 'ACFailure'
     */
    const VALUE_ACFAILURE = 'ACFailure';
    /**
     * Constant for value 'SensorLowBattery'
     * @return string 'SensorLowBattery'
     */
    const VALUE_SENSOR_LOW_BATTERY = 'SensorLowBattery';
    /**
     * Constant for value 'PanelLowBattery'
     * @return string 'PanelLowBattery'
     */
    const VALUE_PANEL_LOW_BATTERY = 'PanelLowBattery';
    /**
     * Constant for value 'PanelNotResponding'
     * @return string 'PanelNotResponding'
     */
    const VALUE_PANEL_NOT_RESPONDING = 'PanelNotResponding';
    /**
     * Constant for value 'NeverPinged'
     * @return string 'NeverPinged'
     */
    const VALUE_NEVER_PINGED = 'NeverPinged';
    /**
     * Constant for value 'SetupNotComplete'
     * @return string 'SetupNotComplete'
     */
    const VALUE_SETUP_NOT_COMPLETE = 'SetupNotComplete';
    /**
     * Constant for value 'CameraNotCommunicating'
     * @return string 'CameraNotCommunicating'
     */
    const VALUE_CAMERA_NOT_COMMUNICATING = 'CameraNotCommunicating';
    /**
     * Constant for value 'CameraNotReachable'
     * @return string 'CameraNotReachable'
     */
    const VALUE_CAMERA_NOT_REACHABLE = 'CameraNotReachable';
    /**
     * Constant for value 'UploadsOverQuota'
     * @return string 'UploadsOverQuota'
     */
    const VALUE_UPLOADS_OVER_QUOTA = 'UploadsOverQuota';
    /**
     * Constant for value 'NoArmings'
     * @return string 'NoArmings'
     */
    const VALUE_NO_ARMINGS = 'NoArmings';
    /**
     * Constant for value 'NoEquipmentList'
     * @return string 'NoEquipmentList'
     */
    const VALUE_NO_EQUIPMENT_LIST = 'NoEquipmentList';
    /**
     * Constant for value 'NeverForwarding'
     * @return string 'NeverForwarding'
     */
    const VALUE_NEVER_FORWARDING = 'NeverForwarding';
    /**
     * Constant for value 'InvalidPrimaryEmail'
     * @return string 'InvalidPrimaryEmail'
     */
    const VALUE_INVALID_PRIMARY_EMAIL = 'InvalidPrimaryEmail';
    /**
     * Constant for value 'ImageSensorUploadsOverQuota'
     * @return string 'ImageSensorUploadsOverQuota'
     */
    const VALUE_IMAGE_SENSOR_UPLOADS_OVER_QUOTA = 'ImageSensorUploadsOverQuota';
    /**
     * Constant for value 'SensorTamper'
     * @return string 'SensorTamper'
     */
    const VALUE_SENSOR_TAMPER = 'SensorTamper';
    /**
     * Constant for value 'NoImageSensorAlarmHardwireEnrolled'
     * @return string 'NoImageSensorAlarmHardwireEnrolled'
     */
    const VALUE_NO_IMAGE_SENSOR_ALARM_HARDWIRE_ENROLLED = 'NoImageSensorAlarmHardwireEnrolled';
    /**
     * Constant for value 'ImageSensorEnrollmentConflict'
     * @return string 'ImageSensorEnrollmentConflict'
     */
    const VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT = 'ImageSensorEnrollmentConflict';
    /**
     * Constant for value 'PoorSignaling'
     * @return string 'PoorSignaling'
     */
    const VALUE_POOR_SIGNALING = 'PoorSignaling';
    /**
     * Constant for value 'CustomerNotLoggedIn'
     * @return string 'CustomerNotLoggedIn'
     */
    const VALUE_CUSTOMER_NOT_LOGGED_IN = 'CustomerNotLoggedIn';
    /**
     * Constant for value 'BroadbandCommFailure'
     * @return string 'BroadbandCommFailure'
     */
    const VALUE_BROADBAND_COMM_FAILURE = 'BroadbandCommFailure';
    /**
     * Constant for value 'CellCommFailure'
     * @return string 'CellCommFailure'
     */
    const VALUE_CELL_COMM_FAILURE = 'CellCommFailure';
    /**
     * Constant for value 'CustomerMonitoringRegistrationIncomplete'
     * @return string 'CustomerMonitoringRegistrationIncomplete'
     */
    const VALUE_CUSTOMER_MONITORING_REGISTRATION_INCOMPLETE = 'CustomerMonitoringRegistrationIncomplete';
    /**
     * Constant for value 'DeviceDisabled'
     * @return string 'DeviceDisabled'
     */
    const VALUE_DEVICE_DISABLED = 'DeviceDisabled';
    /**
     * Constant for value 'SvrRecordingScheduleNotRecording'
     * @return string 'SvrRecordingScheduleNotRecording'
     */
    const VALUE_SVR_RECORDING_SCHEDULE_NOT_RECORDING = 'SvrRecordingScheduleNotRecording';
    /**
     * Constant for value 'UrgentTwoGReplacement'
     * @return string 'UrgentTwoGReplacement'
     */
    const VALUE_URGENT_TWO_GREPLACEMENT = 'UrgentTwoGReplacement';
    /**
     * Constant for value 'ImageSensorRulesNotConfirmed'
     * @return string 'ImageSensorRulesNotConfirmed'
     */
    const VALUE_IMAGE_SENSOR_RULES_NOT_CONFIRMED = 'ImageSensorRulesNotConfirmed';
    /**
     * Constant for value 'NonProductionFirmware'
     * @return string 'NonProductionFirmware'
     */
    const VALUE_NON_PRODUCTION_FIRMWARE = 'NonProductionFirmware';
    /**
     * Constant for value 'IncompatibleDevice'
     * @return string 'IncompatibleDevice'
     */
    const VALUE_INCOMPATIBLE_DEVICE = 'IncompatibleDevice';
    /**
     * Constant for value 'CarDiagnosticIssueReported'
     * @return string 'CarDiagnosticIssueReported'
     */
    const VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED = 'CarDiagnosticIssueReported';
    /**
     * Constant for value 'UnexpectedMovement'
     * @return string 'UnexpectedMovement'
     */
    const VALUE_UNEXPECTED_MOVEMENT = 'UnexpectedMovement';
    /**
     * Constant for value 'SystemLocked'
     * @return string 'SystemLocked'
     */
    const VALUE_SYSTEM_LOCKED = 'SystemLocked';
    /**
     * Constant for value 'SmokeSupervisionEnabled'
     * @return string 'SmokeSupervisionEnabled'
     */
    const VALUE_SMOKE_SUPERVISION_ENABLED = 'SmokeSupervisionEnabled';
    /**
     * Constant for value 'CarbonMonoxideAlert'
     * @return string 'CarbonMonoxideAlert'
     */
    const VALUE_CARBON_MONOXIDE_ALERT = 'CarbonMonoxideAlert';
    /**
     * Constant for value 'DryContactIssue'
     * @return string 'DryContactIssue'
     */
    const VALUE_DRY_CONTACT_ISSUE = 'DryContactIssue';
    /**
     * Constant for value 'LowTankAlert'
     * @return string 'LowTankAlert'
     */
    const VALUE_LOW_TANK_ALERT = 'LowTankAlert';
    /**
     * Constant for value 'WaterAlert'
     * @return string 'WaterAlert'
     */
    const VALUE_WATER_ALERT = 'WaterAlert';
    /**
     * Constant for value 'UnsupportedPanelCustomerValue'
     * @return string 'UnsupportedPanelCustomerValue'
     */
    const VALUE_UNSUPPORTED_PANEL_CUSTOMER_VALUE = 'UnsupportedPanelCustomerValue';
    /**
     * Constant for value 'EthernetCableUnplugged'
     * @return string 'EthernetCableUnplugged'
     */
    const VALUE_ETHERNET_CABLE_UNPLUGGED = 'EthernetCableUnplugged';
    /**
     * Constant for value 'AlarmInMemory'
     * @return string 'AlarmInMemory'
     */
    const VALUE_ALARM_IN_MEMORY = 'AlarmInMemory';
    /**
     * Constant for value 'SensorBypassed'
     * @return string 'SensorBypassed'
     */
    const VALUE_SENSOR_BYPASSED = 'SensorBypassed';
    /**
     * Constant for value 'ThermostatTooCold'
     * @return string 'ThermostatTooCold'
     */
    const VALUE_THERMOSTAT_TOO_COLD = 'ThermostatTooCold';
    /**
     * Constant for value 'ThermostatTooWarm'
     * @return string 'ThermostatTooWarm'
     */
    const VALUE_THERMOSTAT_TOO_WARM = 'ThermostatTooWarm';
    /**
     * Constant for value 'SmokeSensorReset'
     * @return string 'SmokeSensorReset'
     */
    const VALUE_SMOKE_SENSOR_RESET = 'SmokeSensorReset';
    /**
     * Constant for value 'EmptyEquipmentList'
     * @return string 'EmptyEquipmentList'
     */
    const VALUE_EMPTY_EQUIPMENT_LIST = 'EmptyEquipmentList';
    /**
     * Constant for value 'UnsupportedUserCodeLength'
     * @return string 'UnsupportedUserCodeLength'
     */
    const VALUE_UNSUPPORTED_USER_CODE_LENGTH = 'UnsupportedUserCodeLength';
    /**
     * Constant for value 'PendingFirmwareUpgradeFailed'
     * @return string 'PendingFirmwareUpgradeFailed'
     */
    const VALUE_PENDING_FIRMWARE_UPGRADE_FAILED = 'PendingFirmwareUpgradeFailed';
    /**
     * Constant for value 'SecureEnrollmentFailed'
     * @return string 'SecureEnrollmentFailed'
     */
    const VALUE_SECURE_ENROLLMENT_FAILED = 'SecureEnrollmentFailed';
    /**
     * Constant for value 'ContinuousCloudVideoReceiverStopped'
     * @return string 'ContinuousCloudVideoReceiverStopped'
     */
    const VALUE_CONTINUOUS_CLOUD_VIDEO_RECEIVER_STOPPED = 'ContinuousCloudVideoReceiverStopped';
    /**
     * Constant for value 'HeatingAndCoolingAlert'
     * @return string 'HeatingAndCoolingAlert'
     */
    const VALUE_HEATING_AND_COOLING_ALERT = 'HeatingAndCoolingAlert';
    /**
     * Constant for value 'PGM2FireTrouble'
     * @return string 'PGM2FireTrouble'
     */
    const VALUE_PGM_2_FIRE_TROUBLE = 'PGM2FireTrouble';
    /**
     * Constant for value 'FailedReceiverEvent'
     * @return string 'FailedReceiverEvent'
     */
    const VALUE_FAILED_RECEIVER_EVENT = 'FailedReceiverEvent';
    /**
     * Constant for value 'CarbonMonoxideSensorTrouble'
     * @return string 'CarbonMonoxideSensorTrouble'
     */
    const VALUE_CARBON_MONOXIDE_SENSOR_TROUBLE = 'CarbonMonoxideSensorTrouble';
    /**
     * Constant for value 'FreezeSensorTrouble'
     * @return string 'FreezeSensorTrouble'
     */
    const VALUE_FREEZE_SENSOR_TROUBLE = 'FreezeSensorTrouble';
    /**
     * Constant for value 'HeatOrProbeSensorTrouble'
     * @return string 'HeatOrProbeSensorTrouble'
     */
    const VALUE_HEAT_OR_PROBE_SENSOR_TROUBLE = 'HeatOrProbeSensorTrouble';
    /**
     * Constant for value 'BatteryCharging'
     * @return string 'BatteryCharging'
     */
    const VALUE_BATTERY_CHARGING = 'BatteryCharging';
    /**
     * Constant for value 'BatteryAbsent'
     * @return string 'BatteryAbsent'
     */
    const VALUE_BATTERY_ABSENT = 'BatteryAbsent';
    /**
     * Constant for value 'WifiNotConnected'
     * @return string 'WifiNotConnected'
     */
    const VALUE_WIFI_NOT_CONNECTED = 'WifiNotConnected';
    /**
     * Constant for value 'NoTwoWayLinesAvailable'
     * @return string 'NoTwoWayLinesAvailable'
     */
    const VALUE_NO_TWO_WAY_LINES_AVAILABLE = 'NoTwoWayLinesAvailable';
    /**
     * Constant for value 'FailureToCommunicateTrouble'
     * @return string 'FailureToCommunicateTrouble'
     */
    const VALUE_FAILURE_TO_COMMUNICATE_TROUBLE = 'FailureToCommunicateTrouble';
    /**
     * Constant for value 'SelfTestTrouble'
     * @return string 'SelfTestTrouble'
     */
    const VALUE_SELF_TEST_TROUBLE = 'SelfTestTrouble';
    /**
     * Constant for value 'WarmStartTrouble'
     * @return string 'WarmStartTrouble'
     */
    const VALUE_WARM_START_TROUBLE = 'WarmStartTrouble';
    /**
     * Constant for value 'PanelOvercurrentTrouble'
     * @return string 'PanelOvercurrentTrouble'
     */
    const VALUE_PANEL_OVERCURRENT_TROUBLE = 'PanelOvercurrentTrouble';
    /**
     * Constant for value 'FireSensorTrouble'
     * @return string 'FireSensorTrouble'
     */
    const VALUE_FIRE_SENSOR_TROUBLE = 'FireSensorTrouble';
    /**
     * Constant for value 'ZoneDeviceMaskTrouble'
     * @return string 'ZoneDeviceMaskTrouble'
     */
    const VALUE_ZONE_DEVICE_MASK_TROUBLE = 'ZoneDeviceMaskTrouble';
    /**
     * Constant for value 'GasTrouble'
     * @return string 'GasTrouble'
     */
    const VALUE_GAS_TROUBLE = 'GasTrouble';
    /**
     * Constant for value 'HighCurrentAuxTrouble'
     * @return string 'HighCurrentAuxTrouble'
     */
    const VALUE_HIGH_CURRENT_AUX_TROUBLE = 'HighCurrentAuxTrouble';
    /**
     * Constant for value 'RfJamTrouble'
     * @return string 'RfJamTrouble'
     */
    const VALUE_RF_JAM_TROUBLE = 'RfJamTrouble';
    /**
     * Constant for value 'NotNetworkedTrouble'
     * @return string 'NotNetworkedTrouble'
     */
    const VALUE_NOT_NETWORKED_TROUBLE = 'NotNetworkedTrouble';
    /**
     * Constant for value 'PanelTamper'
     * @return string 'PanelTamper'
     */
    const VALUE_PANEL_TAMPER = 'PanelTamper';
    /**
     * Constant for value 'PeripheralAuxTrouble'
     * @return string 'PeripheralAuxTrouble'
     */
    const VALUE_PERIPHERAL_AUX_TROUBLE = 'PeripheralAuxTrouble';
    /**
     * Constant for value 'CredentialsInConflict'
     * @return string 'CredentialsInConflict'
     */
    const VALUE_CREDENTIALS_IN_CONFLICT = 'CredentialsInConflict';
    /**
     * Constant for value 'PirDeviceLimit'
     * @return string 'PirDeviceLimit'
     */
    const VALUE_PIR_DEVICE_LIMIT = 'PirDeviceLimit';
    /**
     * Constant for value 'MonitoringStationIntegrationsCustomerAccount'
     * @return string 'MonitoringStationIntegrationsCustomerAccount'
     */
    const VALUE_MONITORING_STATION_INTEGRATIONS_CUSTOMER_ACCOUNT = 'MonitoringStationIntegrationsCustomerAccount';
    /**
     * Constant for value 'SirenTamper'
     * @return string 'SirenTamper'
     */
    const VALUE_SIREN_TAMPER = 'SirenTamper';
    /**
     * Constant for value 'ZWaveRadioTrouble'
     * @return string 'ZWaveRadioTrouble'
     */
    const VALUE_ZWAVE_RADIO_TROUBLE = 'ZWaveRadioTrouble';
    /**
     * Constant for value 'LowControllerBattery'
     * @return string 'LowControllerBattery'
     */
    const VALUE_LOW_CONTROLLER_BATTERY = 'LowControllerBattery';
    /**
     * Constant for value 'ControllerPowerFault'
     * @return string 'ControllerPowerFault'
     */
    const VALUE_CONTROLLER_POWER_FAULT = 'ControllerPowerFault';
    /**
     * Constant for value 'VirtualZoneEnrollmentError'
     * @return string 'VirtualZoneEnrollmentError'
     */
    const VALUE_VIRTUAL_ZONE_ENROLLMENT_ERROR = 'VirtualZoneEnrollmentError';
    /**
     * Constant for value 'ExtremeWaterTemp'
     * @return string 'ExtremeWaterTemp'
     */
    const VALUE_EXTREME_WATER_TEMP = 'ExtremeWaterTemp';
    /**
     * Constant for value 'SmallLeak'
     * @return string 'SmallLeak'
     */
    const VALUE_SMALL_LEAK = 'SmallLeak';
    /**
     * Constant for value 'MediumLeak'
     * @return string 'MediumLeak'
     */
    const VALUE_MEDIUM_LEAK = 'MediumLeak';
    /**
     * Constant for value 'LargeLeak'
     * @return string 'LargeLeak'
     */
    const VALUE_LARGE_LEAK = 'LargeLeak';
    /**
     * Constant for value 'PSPHardwareIncomp'
     * @return string 'PSPHardwareIncomp'
     */
    const VALUE_PSPHARDWARE_INCOMP = 'PSPHardwareIncomp';
    /**
     * Constant for value 'ZoneOrPartitionLimitExceeded'
     * @return string 'ZoneOrPartitionLimitExceeded'
     */
    const VALUE_ZONE_OR_PARTITION_LIMIT_EXCEEDED = 'ZoneOrPartitionLimitExceeded';
    /**
     * Constant for value 'FirmwareUpdateRequired'
     * @return string 'FirmwareUpdateRequired'
     */
    const VALUE_FIRMWARE_UPDATE_REQUIRED = 'FirmwareUpdateRequired';
    /**
     * Constant for value 'HardwareIncompatibility'
     * @return string 'HardwareIncompatibility'
     */
    const VALUE_HARDWARE_INCOMPATIBILITY = 'HardwareIncompatibility';
    /**
     * Constant for value 'AgenciesNotUpdatedAtCentralStation'
     * @return string 'AgenciesNotUpdatedAtCentralStation'
     */
    const VALUE_AGENCIES_NOT_UPDATED_AT_CENTRAL_STATION = 'AgenciesNotUpdatedAtCentralStation';
    /**
     * Constant for value 'BatteryDoorTamper'
     * @return string 'BatteryDoorTamper'
     */
    const VALUE_BATTERY_DOOR_TAMPER = 'BatteryDoorTamper';
    /**
     * Constant for value 'MountingTamper'
     * @return string 'MountingTamper'
     */
    const VALUE_MOUNTING_TAMPER = 'MountingTamper';
    /**
     * Constant for value 'LoopTamper'
     * @return string 'LoopTamper'
     */
    const VALUE_LOOP_TAMPER = 'LoopTamper';
    /**
     * Constant for value 'HiddenPartitionArmed'
     * @return string 'HiddenPartitionArmed'
     */
    const VALUE_HIDDEN_PARTITION_ARMED = 'HiddenPartitionArmed';
    /**
     * Constant for value 'VideoObjectDetectionRuleNotConfigured'
     * @return string 'VideoObjectDetectionRuleNotConfigured'
     */
    const VALUE_VIDEO_OBJECT_DETECTION_RULE_NOT_CONFIGURED = 'VideoObjectDetectionRuleNotConfigured';
    /**
     * Constant for value 'SevereHVACAlert'
     * @return string 'SevereHVACAlert'
     */
    const VALUE_SEVERE_HVACALERT = 'SevereHVACAlert';
    /**
     * Constant for value 'AlarmComLinkAlert'
     * @return string 'AlarmComLinkAlert'
     */
    const VALUE_ALARM_COM_LINK_ALERT = 'AlarmComLinkAlert';
    /**
     * Constant for value 'DevicePowerIssue'
     * @return string 'DevicePowerIssue'
     */
    const VALUE_DEVICE_POWER_ISSUE = 'DevicePowerIssue';
    /**
     * Constant for value 'SvrFirmwareOutdated'
     * @return string 'SvrFirmwareOutdated'
     */
    const VALUE_SVR_FIRMWARE_OUTDATED = 'SvrFirmwareOutdated';
    /**
     * Constant for value 'VideoDeviceFirmwareOutdated'
     * @return string 'VideoDeviceFirmwareOutdated'
     */
    const VALUE_VIDEO_DEVICE_FIRMWARE_OUTDATED = 'VideoDeviceFirmwareOutdated';
    /**
     * Constant for value 'InstallerResetNeeded'
     * @return string 'InstallerResetNeeded'
     */
    const VALUE_INSTALLER_RESET_NEEDED = 'InstallerResetNeeded';
    /**
     * Constant for value 'AllTroubles'
     * @return string 'AllTroubles'
     */
    const VALUE_ALL_TROUBLES = 'AllTroubles';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALARM
     * @uses self::VALUE_PANEL_DURESS
     * @uses self::VALUE_PANEL_FIRE_PANIC
     * @uses self::VALUE_PANEL_POLICE_PANIC
     * @uses self::VALUE_PANEL_AUX_PANIC
     * @uses self::VALUE_PANEL_FREEZE_ALARM
     * @uses self::VALUE_NO_ACTIVITY_PANEL
     * @uses self::VALUE_NO_ACTIVITY_SCHEDULE
     * @uses self::VALUE_KEYPAD_TAMPER
     * @uses self::VALUE_PHONE_LINE_CUT
     * @uses self::VALUE_MODEM_PANEL_COMM_ERROR
     * @uses self::VALUE_MODULE_MALFUNCTION
     * @uses self::VALUE_SENSOR_MALFUNCTION
     * @uses self::VALUE_RADIO_OFF
     * @uses self::VALUE_ACFAILURE
     * @uses self::VALUE_SENSOR_LOW_BATTERY
     * @uses self::VALUE_PANEL_LOW_BATTERY
     * @uses self::VALUE_PANEL_NOT_RESPONDING
     * @uses self::VALUE_NEVER_PINGED
     * @uses self::VALUE_SETUP_NOT_COMPLETE
     * @uses self::VALUE_CAMERA_NOT_COMMUNICATING
     * @uses self::VALUE_CAMERA_NOT_REACHABLE
     * @uses self::VALUE_UPLOADS_OVER_QUOTA
     * @uses self::VALUE_NO_ARMINGS
     * @uses self::VALUE_NO_EQUIPMENT_LIST
     * @uses self::VALUE_NEVER_FORWARDING
     * @uses self::VALUE_INVALID_PRIMARY_EMAIL
     * @uses self::VALUE_IMAGE_SENSOR_UPLOADS_OVER_QUOTA
     * @uses self::VALUE_SENSOR_TAMPER
     * @uses self::VALUE_NO_IMAGE_SENSOR_ALARM_HARDWIRE_ENROLLED
     * @uses self::VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT
     * @uses self::VALUE_POOR_SIGNALING
     * @uses self::VALUE_CUSTOMER_NOT_LOGGED_IN
     * @uses self::VALUE_BROADBAND_COMM_FAILURE
     * @uses self::VALUE_CELL_COMM_FAILURE
     * @uses self::VALUE_CUSTOMER_MONITORING_REGISTRATION_INCOMPLETE
     * @uses self::VALUE_DEVICE_DISABLED
     * @uses self::VALUE_SVR_RECORDING_SCHEDULE_NOT_RECORDING
     * @uses self::VALUE_URGENT_TWO_GREPLACEMENT
     * @uses self::VALUE_IMAGE_SENSOR_RULES_NOT_CONFIRMED
     * @uses self::VALUE_NON_PRODUCTION_FIRMWARE
     * @uses self::VALUE_INCOMPATIBLE_DEVICE
     * @uses self::VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED
     * @uses self::VALUE_UNEXPECTED_MOVEMENT
     * @uses self::VALUE_SYSTEM_LOCKED
     * @uses self::VALUE_SMOKE_SUPERVISION_ENABLED
     * @uses self::VALUE_CARBON_MONOXIDE_ALERT
     * @uses self::VALUE_DRY_CONTACT_ISSUE
     * @uses self::VALUE_LOW_TANK_ALERT
     * @uses self::VALUE_WATER_ALERT
     * @uses self::VALUE_UNSUPPORTED_PANEL_CUSTOMER_VALUE
     * @uses self::VALUE_ETHERNET_CABLE_UNPLUGGED
     * @uses self::VALUE_ALARM_IN_MEMORY
     * @uses self::VALUE_SENSOR_BYPASSED
     * @uses self::VALUE_THERMOSTAT_TOO_COLD
     * @uses self::VALUE_THERMOSTAT_TOO_WARM
     * @uses self::VALUE_SMOKE_SENSOR_RESET
     * @uses self::VALUE_EMPTY_EQUIPMENT_LIST
     * @uses self::VALUE_UNSUPPORTED_USER_CODE_LENGTH
     * @uses self::VALUE_PENDING_FIRMWARE_UPGRADE_FAILED
     * @uses self::VALUE_SECURE_ENROLLMENT_FAILED
     * @uses self::VALUE_CONTINUOUS_CLOUD_VIDEO_RECEIVER_STOPPED
     * @uses self::VALUE_HEATING_AND_COOLING_ALERT
     * @uses self::VALUE_PGM_2_FIRE_TROUBLE
     * @uses self::VALUE_FAILED_RECEIVER_EVENT
     * @uses self::VALUE_CARBON_MONOXIDE_SENSOR_TROUBLE
     * @uses self::VALUE_FREEZE_SENSOR_TROUBLE
     * @uses self::VALUE_HEAT_OR_PROBE_SENSOR_TROUBLE
     * @uses self::VALUE_BATTERY_CHARGING
     * @uses self::VALUE_BATTERY_ABSENT
     * @uses self::VALUE_WIFI_NOT_CONNECTED
     * @uses self::VALUE_NO_TWO_WAY_LINES_AVAILABLE
     * @uses self::VALUE_FAILURE_TO_COMMUNICATE_TROUBLE
     * @uses self::VALUE_SELF_TEST_TROUBLE
     * @uses self::VALUE_WARM_START_TROUBLE
     * @uses self::VALUE_PANEL_OVERCURRENT_TROUBLE
     * @uses self::VALUE_FIRE_SENSOR_TROUBLE
     * @uses self::VALUE_ZONE_DEVICE_MASK_TROUBLE
     * @uses self::VALUE_GAS_TROUBLE
     * @uses self::VALUE_HIGH_CURRENT_AUX_TROUBLE
     * @uses self::VALUE_RF_JAM_TROUBLE
     * @uses self::VALUE_NOT_NETWORKED_TROUBLE
     * @uses self::VALUE_PANEL_TAMPER
     * @uses self::VALUE_PERIPHERAL_AUX_TROUBLE
     * @uses self::VALUE_CREDENTIALS_IN_CONFLICT
     * @uses self::VALUE_PIR_DEVICE_LIMIT
     * @uses self::VALUE_MONITORING_STATION_INTEGRATIONS_CUSTOMER_ACCOUNT
     * @uses self::VALUE_SIREN_TAMPER
     * @uses self::VALUE_ZWAVE_RADIO_TROUBLE
     * @uses self::VALUE_LOW_CONTROLLER_BATTERY
     * @uses self::VALUE_CONTROLLER_POWER_FAULT
     * @uses self::VALUE_VIRTUAL_ZONE_ENROLLMENT_ERROR
     * @uses self::VALUE_EXTREME_WATER_TEMP
     * @uses self::VALUE_SMALL_LEAK
     * @uses self::VALUE_MEDIUM_LEAK
     * @uses self::VALUE_LARGE_LEAK
     * @uses self::VALUE_PSPHARDWARE_INCOMP
     * @uses self::VALUE_ZONE_OR_PARTITION_LIMIT_EXCEEDED
     * @uses self::VALUE_FIRMWARE_UPDATE_REQUIRED
     * @uses self::VALUE_HARDWARE_INCOMPATIBILITY
     * @uses self::VALUE_AGENCIES_NOT_UPDATED_AT_CENTRAL_STATION
     * @uses self::VALUE_BATTERY_DOOR_TAMPER
     * @uses self::VALUE_MOUNTING_TAMPER
     * @uses self::VALUE_LOOP_TAMPER
     * @uses self::VALUE_HIDDEN_PARTITION_ARMED
     * @uses self::VALUE_VIDEO_OBJECT_DETECTION_RULE_NOT_CONFIGURED
     * @uses self::VALUE_SEVERE_HVACALERT
     * @uses self::VALUE_ALARM_COM_LINK_ALERT
     * @uses self::VALUE_DEVICE_POWER_ISSUE
     * @uses self::VALUE_SVR_FIRMWARE_OUTDATED
     * @uses self::VALUE_VIDEO_DEVICE_FIRMWARE_OUTDATED
     * @uses self::VALUE_INSTALLER_RESET_NEEDED
     * @uses self::VALUE_ALL_TROUBLES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALARM,
            self::VALUE_PANEL_DURESS,
            self::VALUE_PANEL_FIRE_PANIC,
            self::VALUE_PANEL_POLICE_PANIC,
            self::VALUE_PANEL_AUX_PANIC,
            self::VALUE_PANEL_FREEZE_ALARM,
            self::VALUE_NO_ACTIVITY_PANEL,
            self::VALUE_NO_ACTIVITY_SCHEDULE,
            self::VALUE_KEYPAD_TAMPER,
            self::VALUE_PHONE_LINE_CUT,
            self::VALUE_MODEM_PANEL_COMM_ERROR,
            self::VALUE_MODULE_MALFUNCTION,
            self::VALUE_SENSOR_MALFUNCTION,
            self::VALUE_RADIO_OFF,
            self::VALUE_ACFAILURE,
            self::VALUE_SENSOR_LOW_BATTERY,
            self::VALUE_PANEL_LOW_BATTERY,
            self::VALUE_PANEL_NOT_RESPONDING,
            self::VALUE_NEVER_PINGED,
            self::VALUE_SETUP_NOT_COMPLETE,
            self::VALUE_CAMERA_NOT_COMMUNICATING,
            self::VALUE_CAMERA_NOT_REACHABLE,
            self::VALUE_UPLOADS_OVER_QUOTA,
            self::VALUE_NO_ARMINGS,
            self::VALUE_NO_EQUIPMENT_LIST,
            self::VALUE_NEVER_FORWARDING,
            self::VALUE_INVALID_PRIMARY_EMAIL,
            self::VALUE_IMAGE_SENSOR_UPLOADS_OVER_QUOTA,
            self::VALUE_SENSOR_TAMPER,
            self::VALUE_NO_IMAGE_SENSOR_ALARM_HARDWIRE_ENROLLED,
            self::VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT,
            self::VALUE_POOR_SIGNALING,
            self::VALUE_CUSTOMER_NOT_LOGGED_IN,
            self::VALUE_BROADBAND_COMM_FAILURE,
            self::VALUE_CELL_COMM_FAILURE,
            self::VALUE_CUSTOMER_MONITORING_REGISTRATION_INCOMPLETE,
            self::VALUE_DEVICE_DISABLED,
            self::VALUE_SVR_RECORDING_SCHEDULE_NOT_RECORDING,
            self::VALUE_URGENT_TWO_GREPLACEMENT,
            self::VALUE_IMAGE_SENSOR_RULES_NOT_CONFIRMED,
            self::VALUE_NON_PRODUCTION_FIRMWARE,
            self::VALUE_INCOMPATIBLE_DEVICE,
            self::VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED,
            self::VALUE_UNEXPECTED_MOVEMENT,
            self::VALUE_SYSTEM_LOCKED,
            self::VALUE_SMOKE_SUPERVISION_ENABLED,
            self::VALUE_CARBON_MONOXIDE_ALERT,
            self::VALUE_DRY_CONTACT_ISSUE,
            self::VALUE_LOW_TANK_ALERT,
            self::VALUE_WATER_ALERT,
            self::VALUE_UNSUPPORTED_PANEL_CUSTOMER_VALUE,
            self::VALUE_ETHERNET_CABLE_UNPLUGGED,
            self::VALUE_ALARM_IN_MEMORY,
            self::VALUE_SENSOR_BYPASSED,
            self::VALUE_THERMOSTAT_TOO_COLD,
            self::VALUE_THERMOSTAT_TOO_WARM,
            self::VALUE_SMOKE_SENSOR_RESET,
            self::VALUE_EMPTY_EQUIPMENT_LIST,
            self::VALUE_UNSUPPORTED_USER_CODE_LENGTH,
            self::VALUE_PENDING_FIRMWARE_UPGRADE_FAILED,
            self::VALUE_SECURE_ENROLLMENT_FAILED,
            self::VALUE_CONTINUOUS_CLOUD_VIDEO_RECEIVER_STOPPED,
            self::VALUE_HEATING_AND_COOLING_ALERT,
            self::VALUE_PGM_2_FIRE_TROUBLE,
            self::VALUE_FAILED_RECEIVER_EVENT,
            self::VALUE_CARBON_MONOXIDE_SENSOR_TROUBLE,
            self::VALUE_FREEZE_SENSOR_TROUBLE,
            self::VALUE_HEAT_OR_PROBE_SENSOR_TROUBLE,
            self::VALUE_BATTERY_CHARGING,
            self::VALUE_BATTERY_ABSENT,
            self::VALUE_WIFI_NOT_CONNECTED,
            self::VALUE_NO_TWO_WAY_LINES_AVAILABLE,
            self::VALUE_FAILURE_TO_COMMUNICATE_TROUBLE,
            self::VALUE_SELF_TEST_TROUBLE,
            self::VALUE_WARM_START_TROUBLE,
            self::VALUE_PANEL_OVERCURRENT_TROUBLE,
            self::VALUE_FIRE_SENSOR_TROUBLE,
            self::VALUE_ZONE_DEVICE_MASK_TROUBLE,
            self::VALUE_GAS_TROUBLE,
            self::VALUE_HIGH_CURRENT_AUX_TROUBLE,
            self::VALUE_RF_JAM_TROUBLE,
            self::VALUE_NOT_NETWORKED_TROUBLE,
            self::VALUE_PANEL_TAMPER,
            self::VALUE_PERIPHERAL_AUX_TROUBLE,
            self::VALUE_CREDENTIALS_IN_CONFLICT,
            self::VALUE_PIR_DEVICE_LIMIT,
            self::VALUE_MONITORING_STATION_INTEGRATIONS_CUSTOMER_ACCOUNT,
            self::VALUE_SIREN_TAMPER,
            self::VALUE_ZWAVE_RADIO_TROUBLE,
            self::VALUE_LOW_CONTROLLER_BATTERY,
            self::VALUE_CONTROLLER_POWER_FAULT,
            self::VALUE_VIRTUAL_ZONE_ENROLLMENT_ERROR,
            self::VALUE_EXTREME_WATER_TEMP,
            self::VALUE_SMALL_LEAK,
            self::VALUE_MEDIUM_LEAK,
            self::VALUE_LARGE_LEAK,
            self::VALUE_PSPHARDWARE_INCOMP,
            self::VALUE_ZONE_OR_PARTITION_LIMIT_EXCEEDED,
            self::VALUE_FIRMWARE_UPDATE_REQUIRED,
            self::VALUE_HARDWARE_INCOMPATIBILITY,
            self::VALUE_AGENCIES_NOT_UPDATED_AT_CENTRAL_STATION,
            self::VALUE_BATTERY_DOOR_TAMPER,
            self::VALUE_MOUNTING_TAMPER,
            self::VALUE_LOOP_TAMPER,
            self::VALUE_HIDDEN_PARTITION_ARMED,
            self::VALUE_VIDEO_OBJECT_DETECTION_RULE_NOT_CONFIGURED,
            self::VALUE_SEVERE_HVACALERT,
            self::VALUE_ALARM_COM_LINK_ALERT,
            self::VALUE_DEVICE_POWER_ISSUE,
            self::VALUE_SVR_FIRMWARE_OUTDATED,
            self::VALUE_VIDEO_DEVICE_FIRMWARE_OUTDATED,
            self::VALUE_INSTALLER_RESET_NEEDED,
            self::VALUE_ALL_TROUBLES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
