<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransferAccountOutput ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransferAccountOutput extends AbstractStructArrayBase
{
    /**
     * The TransferAccountOutput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\TransferAccountOutput[]
     */
    public $TransferAccountOutput;
    /**
     * Constructor method for ArrayOfTransferAccountOutput
     * @uses ArrayOfTransferAccountOutput::setTransferAccountOutput()
     * @param \CustomerManagement\StructType\TransferAccountOutput[] $transferAccountOutput
     */
    public function __construct(array $transferAccountOutput = array())
    {
        $this
            ->setTransferAccountOutput($transferAccountOutput);
    }
    /**
     * Get TransferAccountOutput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\TransferAccountOutput[]|null
     */
    public function getTransferAccountOutput()
    {
        return isset($this->TransferAccountOutput) ? $this->TransferAccountOutput : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferAccountOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferAccountOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferAccountOutputForArrayConstraintsFromSetTransferAccountOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransferAccountOutputTransferAccountOutputItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransferAccountOutputTransferAccountOutputItem instanceof \CustomerManagement\StructType\TransferAccountOutput) {
                $invalidValues[] = is_object($arrayOfTransferAccountOutputTransferAccountOutputItem) ? get_class($arrayOfTransferAccountOutputTransferAccountOutputItem) : sprintf('%s(%s)', gettype($arrayOfTransferAccountOutputTransferAccountOutputItem), var_export($arrayOfTransferAccountOutputTransferAccountOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferAccountOutput property can only contain items of type \CustomerManagement\StructType\TransferAccountOutput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferAccountOutput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\TransferAccountOutput[] $transferAccountOutput
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountOutput
     */
    public function setTransferAccountOutput(array $transferAccountOutput = array())
    {
        // validation for constraint: array
        if ('' !== ($transferAccountOutputArrayErrorMessage = self::validateTransferAccountOutputForArrayConstraintsFromSetTransferAccountOutput($transferAccountOutput))) {
            throw new \InvalidArgumentException($transferAccountOutputArrayErrorMessage, __LINE__);
        }
        if (is_null($transferAccountOutput) || (is_array($transferAccountOutput) && empty($transferAccountOutput))) {
            unset($this->TransferAccountOutput);
        } else {
            $this->TransferAccountOutput = $transferAccountOutput;
        }
        return $this;
    }
    /**
     * Add item to TransferAccountOutput value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\TransferAccountOutput $item
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountOutput
     */
    public function addToTransferAccountOutput(\CustomerManagement\StructType\TransferAccountOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\TransferAccountOutput) {
            throw new \InvalidArgumentException(sprintf('The TransferAccountOutput property can only contain items of type \CustomerManagement\StructType\TransferAccountOutput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferAccountOutput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\TransferAccountOutput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\TransferAccountOutput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\TransferAccountOutput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\TransferAccountOutput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\TransferAccountOutput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferAccountOutput
     */
    public function getAttributeName()
    {
        return 'TransferAccountOutput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfTransferAccountOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
