<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCentralStationInfo StructType
 * @subpackage Structs
 */
class UpdateCentralStationInfo extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The forwardingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $forwardingOption;
    /**
     * The phoneLinePresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $phoneLinePresent;
    /**
     * The eventGroupsToForward
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $eventGroupsToForward;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The receiverNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiverNumber;
    /**
     * Constructor method for UpdateCentralStationInfo
     * @uses UpdateCentralStationInfo::setCustomerId()
     * @uses UpdateCentralStationInfo::setForwardingOption()
     * @uses UpdateCentralStationInfo::setPhoneLinePresent()
     * @uses UpdateCentralStationInfo::setEventGroupsToForward()
     * @uses UpdateCentralStationInfo::setAccountNumber()
     * @uses UpdateCentralStationInfo::setReceiverNumber()
     * @param int $customerId
     * @param string $forwardingOption
     * @param bool $phoneLinePresent
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @param string $accountNumber
     * @param string $receiverNumber
     */
    public function __construct($customerId = null, $forwardingOption = null, $phoneLinePresent = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null, $accountNumber = null, $receiverNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setForwardingOption($forwardingOption)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setEventGroupsToForward($eventGroupsToForward)
            ->setAccountNumber($accountNumber)
            ->setReceiverNumber($receiverNumber);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get forwardingOption value
     * @return string
     */
    public function getForwardingOption()
    {
        return $this->forwardingOption;
    }
    /**
     * Set forwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forwardingOption
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setForwardingOption($forwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($forwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CentralStationForwardingOptionEnum', is_array($forwardingOption) ? implode(', ', $forwardingOption) : var_export($forwardingOption, true), implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->forwardingOption = $forwardingOption;
        return $this;
    }
    /**
     * Get phoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->phoneLinePresent;
    }
    /**
     * Set phoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneLinePresent) && !is_bool($phoneLinePresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneLinePresent, true), gettype($phoneLinePresent)), __LINE__);
        }
        $this->phoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get eventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getEventGroupsToForward()
    {
        return $this->eventGroupsToForward;
    }
    /**
     * Set eventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this->eventGroupsToForward = $eventGroupsToForward;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get receiverNumber value
     * @return string|null
     */
    public function getReceiverNumber()
    {
        return $this->receiverNumber;
    }
    /**
     * Set receiverNumber value
     * @param string $receiverNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public function setReceiverNumber($receiverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverNumber) && !is_string($receiverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverNumber, true), gettype($receiverNumber)), __LINE__);
        }
        $this->receiverNumber = $receiverNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
