<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for ServicePlanRecurrencePeriodEnum EnumType
 * @subpackage Enumerations
 */
class ServicePlanRecurrencePeriodEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Quarterly'
     * @return string 'Quarterly'
     */
    const VALUE_QUARTERLY = 'Quarterly';
    /**
     * Constant for value 'Yearly'
     * @return string 'Yearly'
     */
    const VALUE_YEARLY = 'Yearly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_QUARTERLY
     * @uses self::VALUE_YEARLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_DAILY,
            self::VALUE_MONTHLY,
            self::VALUE_QUARTERLY,
            self::VALUE_YEARLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
