<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsUserCodeInfo StructType
 * @subpackage Structs
 */
class WsUserCodeInfo extends AbstractStructBase
{
    /**
     * The panelUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $panelUserId;
    /**
     * The voiceAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $voiceAccess;
    /**
     * The partitionFlags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $partitionFlags;
    /**
     * The userFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userFirstName;
    /**
     * The userLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLastName;
    /**
     * The userCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userCode;
    /**
     * The enabledPointAccessDeviceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId
     */
    public $enabledPointAccessDeviceIds;
    /**
     * Constructor method for WsUserCodeInfo
     * @uses WsUserCodeInfo::setPanelUserId()
     * @uses WsUserCodeInfo::setVoiceAccess()
     * @uses WsUserCodeInfo::setPartitionFlags()
     * @uses WsUserCodeInfo::setUserFirstName()
     * @uses WsUserCodeInfo::setUserLastName()
     * @uses WsUserCodeInfo::setUserCode()
     * @uses WsUserCodeInfo::setEnabledPointAccessDeviceIds()
     * @param int $panelUserId
     * @param bool $voiceAccess
     * @param int $partitionFlags
     * @param string $userFirstName
     * @param string $userLastName
     * @param string $userCode
     * @param \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId $enabledPointAccessDeviceIds
     */
    public function __construct($panelUserId = null, $voiceAccess = null, $partitionFlags = null, $userFirstName = null, $userLastName = null, $userCode = null, \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId $enabledPointAccessDeviceIds = null)
    {
        $this
            ->setPanelUserId($panelUserId)
            ->setVoiceAccess($voiceAccess)
            ->setPartitionFlags($partitionFlags)
            ->setUserFirstName($userFirstName)
            ->setUserLastName($userLastName)
            ->setUserCode($userCode)
            ->setEnabledPointAccessDeviceIds($enabledPointAccessDeviceIds);
    }
    /**
     * Get panelUserId value
     * @return int
     */
    public function getPanelUserId()
    {
        return $this->panelUserId;
    }
    /**
     * Set panelUserId value
     * @param int $panelUserId
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setPanelUserId($panelUserId = null)
    {
        // validation for constraint: int
        if (!is_null($panelUserId) && !(is_int($panelUserId) || ctype_digit($panelUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelUserId, true), gettype($panelUserId)), __LINE__);
        }
        $this->panelUserId = $panelUserId;
        return $this;
    }
    /**
     * Get voiceAccess value
     * @return bool
     */
    public function getVoiceAccess()
    {
        return $this->voiceAccess;
    }
    /**
     * Set voiceAccess value
     * @param bool $voiceAccess
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setVoiceAccess($voiceAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($voiceAccess) && !is_bool($voiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($voiceAccess, true), gettype($voiceAccess)), __LINE__);
        }
        $this->voiceAccess = $voiceAccess;
        return $this;
    }
    /**
     * Get partitionFlags value
     * @return int
     */
    public function getPartitionFlags()
    {
        return $this->partitionFlags;
    }
    /**
     * Set partitionFlags value
     * @param int $partitionFlags
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setPartitionFlags($partitionFlags = null)
    {
        // validation for constraint: int
        if (!is_null($partitionFlags) && !(is_int($partitionFlags) || ctype_digit($partitionFlags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partitionFlags, true), gettype($partitionFlags)), __LINE__);
        }
        $this->partitionFlags = $partitionFlags;
        return $this;
    }
    /**
     * Get userFirstName value
     * @return string|null
     */
    public function getUserFirstName()
    {
        return $this->userFirstName;
    }
    /**
     * Set userFirstName value
     * @param string $userFirstName
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setUserFirstName($userFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($userFirstName) && !is_string($userFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userFirstName, true), gettype($userFirstName)), __LINE__);
        }
        $this->userFirstName = $userFirstName;
        return $this;
    }
    /**
     * Get userLastName value
     * @return string|null
     */
    public function getUserLastName()
    {
        return $this->userLastName;
    }
    /**
     * Set userLastName value
     * @param string $userLastName
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setUserLastName($userLastName = null)
    {
        // validation for constraint: string
        if (!is_null($userLastName) && !is_string($userLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLastName, true), gettype($userLastName)), __LINE__);
        }
        $this->userLastName = $userLastName;
        return $this;
    }
    /**
     * Get userCode value
     * @return string|null
     */
    public function getUserCode()
    {
        return $this->userCode;
    }
    /**
     * Set userCode value
     * @param string $userCode
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setUserCode($userCode = null)
    {
        // validation for constraint: string
        if (!is_null($userCode) && !is_string($userCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userCode, true), gettype($userCode)), __LINE__);
        }
        $this->userCode = $userCode;
        return $this;
    }
    /**
     * Get enabledPointAccessDeviceIds value
     * @return \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId|null
     */
    public function getEnabledPointAccessDeviceIds()
    {
        return $this->enabledPointAccessDeviceIds;
    }
    /**
     * Set enabledPointAccessDeviceIds value
     * @param \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId $enabledPointAccessDeviceIds
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public function setEnabledPointAccessDeviceIds(\CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId $enabledPointAccessDeviceIds = null)
    {
        $this->enabledPointAccessDeviceIds = $enabledPointAccessDeviceIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\WsUserCodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
