<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddSensorDeviceInput StructType
 * @subpackage Structs
 */
class AddSensorDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The SensorNamePrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNamePrefix;
    /**
     * The SensorNameBase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameBase;
    /**
     * The SensorNameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameSuffix;
    /**
     * The SensorNameToken3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameToken3;
    /**
     * The SensorNameToken4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameToken4;
    /**
     * The SensorTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorTypeId;
    /**
     * The SensorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorName;
    /**
     * The DLCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DLCode;
    /**
     * Constructor method for AddSensorDeviceInput
     * @uses AddSensorDeviceInput::setCustomerId()
     * @uses AddSensorDeviceInput::setSensorId()
     * @uses AddSensorDeviceInput::setGroupId()
     * @uses AddSensorDeviceInput::setSensorNamePrefix()
     * @uses AddSensorDeviceInput::setSensorNameBase()
     * @uses AddSensorDeviceInput::setSensorNameSuffix()
     * @uses AddSensorDeviceInput::setSensorNameToken3()
     * @uses AddSensorDeviceInput::setSensorNameToken4()
     * @uses AddSensorDeviceInput::setSensorTypeId()
     * @uses AddSensorDeviceInput::setSensorName()
     * @uses AddSensorDeviceInput::setDLCode()
     * @param int $customerId
     * @param int $sensorId
     * @param int $groupId
     * @param string $sensorNamePrefix
     * @param string $sensorNameBase
     * @param string $sensorNameSuffix
     * @param string $sensorNameToken3
     * @param string $sensorNameToken4
     * @param string $sensorTypeId
     * @param string $sensorName
     * @param string $dLCode
     */
    public function __construct($customerId = null, $sensorId = null, $groupId = null, $sensorNamePrefix = null, $sensorNameBase = null, $sensorNameSuffix = null, $sensorNameToken3 = null, $sensorNameToken4 = null, $sensorTypeId = null, $sensorName = null, $dLCode = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setGroupId($groupId)
            ->setSensorNamePrefix($sensorNamePrefix)
            ->setSensorNameBase($sensorNameBase)
            ->setSensorNameSuffix($sensorNameSuffix)
            ->setSensorNameToken3($sensorNameToken3)
            ->setSensorNameToken4($sensorNameToken4)
            ->setSensorTypeId($sensorTypeId)
            ->setSensorName($sensorName)
            ->setDLCode($dLCode);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get SensorNamePrefix value
     * @return string|null
     */
    public function getSensorNamePrefix()
    {
        return $this->SensorNamePrefix;
    }
    /**
     * Set SensorNamePrefix value
     * @param string $sensorNamePrefix
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorNamePrefix($sensorNamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNamePrefix) && !is_string($sensorNamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorNamePrefix, true), gettype($sensorNamePrefix)), __LINE__);
        }
        $this->SensorNamePrefix = $sensorNamePrefix;
        return $this;
    }
    /**
     * Get SensorNameBase value
     * @return string|null
     */
    public function getSensorNameBase()
    {
        return $this->SensorNameBase;
    }
    /**
     * Set SensorNameBase value
     * @param string $sensorNameBase
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorNameBase($sensorNameBase = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameBase) && !is_string($sensorNameBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorNameBase, true), gettype($sensorNameBase)), __LINE__);
        }
        $this->SensorNameBase = $sensorNameBase;
        return $this;
    }
    /**
     * Get SensorNameSuffix value
     * @return string|null
     */
    public function getSensorNameSuffix()
    {
        return $this->SensorNameSuffix;
    }
    /**
     * Set SensorNameSuffix value
     * @param string $sensorNameSuffix
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorNameSuffix($sensorNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameSuffix) && !is_string($sensorNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorNameSuffix, true), gettype($sensorNameSuffix)), __LINE__);
        }
        $this->SensorNameSuffix = $sensorNameSuffix;
        return $this;
    }
    /**
     * Get SensorNameToken3 value
     * @return string|null
     */
    public function getSensorNameToken3()
    {
        return $this->SensorNameToken3;
    }
    /**
     * Set SensorNameToken3 value
     * @param string $sensorNameToken3
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorNameToken3($sensorNameToken3 = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameToken3) && !is_string($sensorNameToken3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorNameToken3, true), gettype($sensorNameToken3)), __LINE__);
        }
        $this->SensorNameToken3 = $sensorNameToken3;
        return $this;
    }
    /**
     * Get SensorNameToken4 value
     * @return string|null
     */
    public function getSensorNameToken4()
    {
        return $this->SensorNameToken4;
    }
    /**
     * Set SensorNameToken4 value
     * @param string $sensorNameToken4
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorNameToken4($sensorNameToken4 = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameToken4) && !is_string($sensorNameToken4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorNameToken4, true), gettype($sensorNameToken4)), __LINE__);
        }
        $this->SensorNameToken4 = $sensorNameToken4;
        return $this;
    }
    /**
     * Get SensorTypeId value
     * @return string|null
     */
    public function getSensorTypeId()
    {
        return $this->SensorTypeId;
    }
    /**
     * Set SensorTypeId value
     * @param string $sensorTypeId
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorTypeId($sensorTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($sensorTypeId) && !is_string($sensorTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorTypeId, true), gettype($sensorTypeId)), __LINE__);
        }
        $this->SensorTypeId = $sensorTypeId;
        return $this;
    }
    /**
     * Get SensorName value
     * @return string|null
     */
    public function getSensorName()
    {
        return $this->SensorName;
    }
    /**
     * Set SensorName value
     * @param string $sensorName
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setSensorName($sensorName = null)
    {
        // validation for constraint: string
        if (!is_null($sensorName) && !is_string($sensorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorName, true), gettype($sensorName)), __LINE__);
        }
        $this->SensorName = $sensorName;
        return $this;
    }
    /**
     * Get DLCode value
     * @return string|null
     */
    public function getDLCode()
    {
        return $this->DLCode;
    }
    /**
     * Set DLCode value
     * @param string $dLCode
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public function setDLCode($dLCode = null)
    {
        // validation for constraint: string
        if (!is_null($dLCode) && !is_string($dLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dLCode, true), gettype($dLCode)), __LINE__);
        }
        $this->DLCode = $dLCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddSensorDeviceInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
