<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for OnsiteWrapUpActionEnum EnumType
 * @subpackage Enumerations
 */
class OnsiteWrapUpActionEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'SuccessfulSystemCheck'
     * @return string 'SuccessfulSystemCheck'
     */
    const VALUE_SUCCESSFUL_SYSTEM_CHECK = 'SuccessfulSystemCheck';
    /**
     * Constant for value 'CustomAction'
     * @return string 'CustomAction'
     */
    const VALUE_CUSTOM_ACTION = 'CustomAction';
    /**
     * Constant for value 'MobileLogIn'
     * @return string 'MobileLogIn'
     */
    const VALUE_MOBILE_LOG_IN = 'MobileLogIn';
    /**
     * Constant for value 'SaveDeviceNotes'
     * @return string 'SaveDeviceNotes'
     */
    const VALUE_SAVE_DEVICE_NOTES = 'SaveDeviceNotes';
    /**
     * Constant for value 'EnableDualPath'
     * @return string 'EnableDualPath'
     */
    const VALUE_ENABLE_DUAL_PATH = 'EnableDualPath';
    /**
     * Constant for value 'LteUpgradeNeeded'
     * @return string 'LteUpgradeNeeded'
     */
    const VALUE_LTE_UPGRADE_NEEDED = 'LteUpgradeNeeded';
    /**
     * Constant for value 'SensorWalkTest'
     * @return string 'SensorWalkTest'
     */
    const VALUE_SENSOR_WALK_TEST = 'SensorWalkTest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_SUCCESSFUL_SYSTEM_CHECK
     * @uses self::VALUE_CUSTOM_ACTION
     * @uses self::VALUE_MOBILE_LOG_IN
     * @uses self::VALUE_SAVE_DEVICE_NOTES
     * @uses self::VALUE_ENABLE_DUAL_PATH
     * @uses self::VALUE_LTE_UPGRADE_NEEDED
     * @uses self::VALUE_SENSOR_WALK_TEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_SUCCESSFUL_SYSTEM_CHECK,
            self::VALUE_CUSTOM_ACTION,
            self::VALUE_MOBILE_LOG_IN,
            self::VALUE_SAVE_DEVICE_NOTES,
            self::VALUE_ENABLE_DUAL_PATH,
            self::VALUE_LTE_UPGRADE_NEEDED,
            self::VALUE_SENSOR_WALK_TEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
