<?php

namespace CustomerManagement;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetSecurityQuestions' => '\\CustomerManagement\\StructType\\GetSecurityQuestions',
            'GetSecurityQuestionsInput' => '\\CustomerManagement\\StructType\\GetSecurityQuestionsInput',
            'GetSecurityQuestionsResponse' => '\\CustomerManagement\\StructType\\GetSecurityQuestionsResponse',
            'GetSecurityQuestionsOutput' => '\\CustomerManagement\\StructType\\GetSecurityQuestionsOutput',
            'ArrayOfPasswordQuestion' => '\\CustomerManagement\\ArrayType\\ArrayOfPasswordQuestion',
            'PasswordQuestion' => '\\CustomerManagement\\StructType\\PasswordQuestion',
            'Authentication' => '\\CustomerManagement\\StructType\\Authentication',
            'UpdateCustomerSecurityQuestion' => '\\CustomerManagement\\StructType\\UpdateCustomerSecurityQuestion',
            'UpdateCustomerSecurityQuestionInput' => '\\CustomerManagement\\StructType\\UpdateCustomerSecurityQuestionInput',
            'UpdateCustomerSecurityQuestionResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerSecurityQuestionResponse',
            'UpdateCustomerSecurityQuestionOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerSecurityQuestionOutput',
            'GetAllLogins' => '\\CustomerManagement\\StructType\\GetAllLogins',
            'GetAllLoginsResponse' => '\\CustomerManagement\\StructType\\GetAllLoginsResponse',
            'GetAllLoginsOutput' => '\\CustomerManagement\\StructType\\GetAllLoginsOutput',
            'ArrayOfLoginInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfLoginInfo',
            'LoginInfo' => '\\CustomerManagement\\StructType\\LoginInfo',
            'ArrayOfInt' => '\\CustomerManagement\\ArrayType\\ArrayOfInt',
            'GetLoginInfo' => '\\CustomerManagement\\StructType\\GetLoginInfo',
            'GetLoginInfoInput' => '\\CustomerManagement\\StructType\\GetLoginInfoInput',
            'GetLoginInfoResponse' => '\\CustomerManagement\\StructType\\GetLoginInfoResponse',
            'GetLoginInfoOutput' => '\\CustomerManagement\\StructType\\GetLoginInfoOutput',
            'ArrayOfLoginInfoOutput' => '\\CustomerManagement\\ArrayType\\ArrayOfLoginInfoOutput',
            'LoginInfoOutput' => '\\CustomerManagement\\StructType\\LoginInfoOutput',
            'ArrayOfCustomerSummary' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerSummary',
            'CustomerSummary' => '\\CustomerManagement\\StructType\\CustomerSummary',
            'Address' => '\\CustomerManagement\\StructType\\Address',
            'AddressWithCoordinates' => '\\CustomerManagement\\StructType\\AddressWithCoordinates',
            'AddressWithName' => '\\CustomerManagement\\StructType\\AddressWithName',
            'MergeLogins' => '\\CustomerManagement\\StructType\\MergeLogins',
            'MergeLoginsInput' => '\\CustomerManagement\\StructType\\MergeLoginsInput',
            'MergeLoginsResponse' => '\\CustomerManagement\\StructType\\MergeLoginsResponse',
            'MergeLoginsOutput' => '\\CustomerManagement\\StructType\\MergeLoginsOutput',
            'MergeLoginsByLoginName' => '\\CustomerManagement\\StructType\\MergeLoginsByLoginName',
            'MergeLoginsByLoginNameInput' => '\\CustomerManagement\\StructType\\MergeLoginsByLoginNameInput',
            'MergeLoginsByLoginNameResponse' => '\\CustomerManagement\\StructType\\MergeLoginsByLoginNameResponse',
            'MergeLoginsByLoginNameOutput' => '\\CustomerManagement\\StructType\\MergeLoginsByLoginNameOutput',
            'AddExistingLogins' => '\\CustomerManagement\\StructType\\AddExistingLogins',
            'AddExistingLoginInput' => '\\CustomerManagement\\StructType\\AddExistingLoginInput',
            'AddExistingLoginsResponse' => '\\CustomerManagement\\StructType\\AddExistingLoginsResponse',
            'AddExistingLoginOutput' => '\\CustomerManagement\\StructType\\AddExistingLoginOutput',
            'CreateNewCustomerWebsiteMessage' => '\\CustomerManagement\\StructType\\CreateNewCustomerWebsiteMessage',
            'CreateNewCustomerWebsiteMessageInput' => '\\CustomerManagement\\StructType\\CreateNewCustomerWebsiteMessageInput',
            'ArrayOfString' => '\\CustomerManagement\\ArrayType\\ArrayOfString',
            'CreateNewCustomerWebsiteMessageResponse' => '\\CustomerManagement\\StructType\\CreateNewCustomerWebsiteMessageResponse',
            'CreateNewCustomerWebsiteMessageOutput' => '\\CustomerManagement\\StructType\\CreateNewCustomerWebsiteMessageOutput',
            'DeleteCustomerWebsiteMessage' => '\\CustomerManagement\\StructType\\DeleteCustomerWebsiteMessage',
            'DeleteCustomerWebsiteMessageInput' => '\\CustomerManagement\\StructType\\DeleteCustomerWebsiteMessageInput',
            'DeleteCustomerWebsiteMessageResponse' => '\\CustomerManagement\\StructType\\DeleteCustomerWebsiteMessageResponse',
            'DeleteCustomerWebsiteMessageOutput' => '\\CustomerManagement\\StructType\\DeleteCustomerWebsiteMessageOutput',
            'ResetCustomerPassword' => '\\CustomerManagement\\StructType\\ResetCustomerPassword',
            'ResetCustomerPasswordInput' => '\\CustomerManagement\\StructType\\ResetCustomerPasswordInput',
            'ResetCustomerPasswordResponse' => '\\CustomerManagement\\StructType\\ResetCustomerPasswordResponse',
            'ResetCustomerPasswordOutput' => '\\CustomerManagement\\StructType\\ResetCustomerPasswordOutput',
            'UpdateCustomDevices' => '\\CustomerManagement\\StructType\\UpdateCustomDevices',
            'UpdateCustomDevicesInput' => '\\CustomerManagement\\StructType\\UpdateCustomDevicesInput',
            'ArrayOfPanelDevice' => '\\CustomerManagement\\ArrayType\\ArrayOfPanelDevice',
            'PanelDevice' => '\\CustomerManagement\\StructType\\PanelDevice',
            'ArrayOfDeviceStatusEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfDeviceStatusEnum',
            'ArrayOfDeviceTypeEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfDeviceTypeEnum',
            'UpdateCustomDevicesResponse' => '\\CustomerManagement\\StructType\\UpdateCustomDevicesResponse',
            'UpdateCustomDevicesOutput' => '\\CustomerManagement\\StructType\\UpdateCustomDevicesOutput',
            'GetCustomerEnergyProgramEligibility' => '\\CustomerManagement\\StructType\\GetCustomerEnergyProgramEligibility',
            'GetCustomerEnergyProgramEligibilityResponse' => '\\CustomerManagement\\StructType\\GetCustomerEnergyProgramEligibilityResponse',
            'GetCustomerEnergyProgramEligibilityOutput' => '\\CustomerManagement\\StructType\\GetCustomerEnergyProgramEligibilityOutput',
            'ArrayOfGetCustomerEnergyProgramEligibilityRow' => '\\CustomerManagement\\ArrayType\\ArrayOfGetCustomerEnergyProgramEligibilityRow',
            'GetCustomerEnergyProgramEligibilityRow' => '\\CustomerManagement\\StructType\\GetCustomerEnergyProgramEligibilityRow',
            'UpdateCustomerEnergyProgramEnrollment' => '\\CustomerManagement\\StructType\\UpdateCustomerEnergyProgramEnrollment',
            'UpdateCustomerEnergyProgramEnrollmentInput' => '\\CustomerManagement\\StructType\\UpdateCustomerEnergyProgramEnrollmentInput',
            'UpdateCustomerEnergyProgramEnrollmentResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerEnergyProgramEnrollmentResponse',
            'UpdateCustomerEnergyProgramEnrollmentOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerEnergyProgramEnrollmentOutput',
            'AddDefaultNotifications' => '\\CustomerManagement\\StructType\\AddDefaultNotifications',
            'AddDefaultNotificationsInput' => '\\CustomerManagement\\StructType\\AddDefaultNotificationsInput',
            'AddDefaultNotificationsResponse' => '\\CustomerManagement\\StructType\\AddDefaultNotificationsResponse',
            'AddDefaultNotificationsOutput' => '\\CustomerManagement\\StructType\\AddDefaultNotificationsOutput',
            'UpdateUnitDescription' => '\\CustomerManagement\\StructType\\UpdateUnitDescription',
            'UpdateUnitDescriptionInput' => '\\CustomerManagement\\StructType\\UpdateUnitDescriptionInput',
            'UpdateUnitDescriptionResponse' => '\\CustomerManagement\\StructType\\UpdateUnitDescriptionResponse',
            'UpdateUnitDescriptionOutput' => '\\CustomerManagement\\StructType\\UpdateUnitDescriptionOutput',
            'AddSensorDevice' => '\\CustomerManagement\\StructType\\AddSensorDevice',
            'AddSensorDeviceInput' => '\\CustomerManagement\\StructType\\AddSensorDeviceInput',
            'AddSensorDeviceResponse' => '\\CustomerManagement\\StructType\\AddSensorDeviceResponse',
            'AddSensorDeviceOutput' => '\\CustomerManagement\\StructType\\AddSensorDeviceOutput',
            'AddSensorDeviceFor2Gig' => '\\CustomerManagement\\StructType\\AddSensorDeviceFor2Gig',
            'AddSensorDeviceFor2GigInput' => '\\CustomerManagement\\StructType\\AddSensorDeviceFor2GigInput',
            'AddSensorDeviceFor2GigResponse' => '\\CustomerManagement\\StructType\\AddSensorDeviceFor2GigResponse',
            'AddSensorDeviceFor2GigOutput' => '\\CustomerManagement\\StructType\\AddSensorDeviceFor2GigOutput',
            'AddFobFor2Gig' => '\\CustomerManagement\\StructType\\AddFobFor2Gig',
            'AddFobFor2GigInput' => '\\CustomerManagement\\StructType\\AddFobFor2GigInput',
            'AddFobFor2GigResponse' => '\\CustomerManagement\\StructType\\AddFobFor2GigResponse',
            'AddFobFor2GigOutput' => '\\CustomerManagement\\StructType\\AddFobFor2GigOutput',
            'AddPeripheral' => '\\CustomerManagement\\StructType\\AddPeripheral',
            'AddPeripheralInput' => '\\CustomerManagement\\StructType\\AddPeripheralInput',
            'AddPeripheralResponse' => '\\CustomerManagement\\StructType\\AddPeripheralResponse',
            'AddPeripheralOutput' => '\\CustomerManagement\\StructType\\AddPeripheralOutput',
            'HardResetModule' => '\\CustomerManagement\\StructType\\HardResetModule',
            'HardResetModuleInput' => '\\CustomerManagement\\StructType\\HardResetModuleInput',
            'HardResetModuleResponse' => '\\CustomerManagement\\StructType\\HardResetModuleResponse',
            'HardResetModuleOutput' => '\\CustomerManagement\\StructType\\HardResetModuleOutput',
            'AddSensorGetKeyfobProperties' => '\\CustomerManagement\\StructType\\AddSensorGetKeyfobProperties',
            'AddSensorGetKeyfobPropertiesResponse' => '\\CustomerManagement\\StructType\\AddSensorGetKeyfobPropertiesResponse',
            'AddSensorGetKeyfobPropertiesOutput' => '\\CustomerManagement\\StructType\\AddSensorGetKeyfobPropertiesOutput',
            'ArrayOfKeyfobVoiceDescriptor' => '\\CustomerManagement\\ArrayType\\ArrayOfKeyfobVoiceDescriptor',
            'KeyfobVoiceDescriptor' => '\\CustomerManagement\\StructType\\KeyfobVoiceDescriptor',
            'ArrayOfKeyfobEmergencyKey' => '\\CustomerManagement\\ArrayType\\ArrayOfKeyfobEmergencyKey',
            'KeyfobEmergencyKey' => '\\CustomerManagement\\StructType\\KeyfobEmergencyKey',
            'ArrayOfKeyfobKey4Output' => '\\CustomerManagement\\ArrayType\\ArrayOfKeyfobKey4Output',
            'KeyfobKey4Output' => '\\CustomerManagement\\StructType\\KeyfobKey4Output',
            'DeleteSensorDevice' => '\\CustomerManagement\\StructType\\DeleteSensorDevice',
            'DeleteSensorDeviceInput' => '\\CustomerManagement\\StructType\\DeleteSensorDeviceInput',
            'DeleteSensorDeviceResponse' => '\\CustomerManagement\\StructType\\DeleteSensorDeviceResponse',
            'DeleteSensorDeviceOutput' => '\\CustomerManagement\\StructType\\DeleteSensorDeviceOutput',
            'DeleteImageSensor' => '\\CustomerManagement\\StructType\\DeleteImageSensor',
            'DeleteImageSensorInput' => '\\CustomerManagement\\StructType\\DeleteImageSensorInput',
            'DeleteImageSensorResponse' => '\\CustomerManagement\\StructType\\DeleteImageSensorResponse',
            'DeleteVideoDevice' => '\\CustomerManagement\\StructType\\DeleteVideoDevice',
            'DeleteVideoDeviceInput' => '\\CustomerManagement\\StructType\\DeleteVideoDeviceInput',
            'DeleteVideoDeviceResponse' => '\\CustomerManagement\\StructType\\DeleteVideoDeviceResponse',
            'DeleteVideoDeviceOutput' => '\\CustomerManagement\\StructType\\DeleteVideoDeviceOutput',
            'TestVideoDeviceConnectivity' => '\\CustomerManagement\\StructType\\TestVideoDeviceConnectivity',
            'TestVideoDeviceConnectivityInput' => '\\CustomerManagement\\StructType\\TestVideoDeviceConnectivityInput',
            'TestVideoDeviceConnectivityResponse' => '\\CustomerManagement\\StructType\\TestVideoDeviceConnectivityResponse',
            'TestVideoDeviceConnectivityOutput' => '\\CustomerManagement\\StructType\\TestVideoDeviceConnectivityOutput',
            'AddVideoDevice' => '\\CustomerManagement\\StructType\\AddVideoDevice',
            'AddVideoDeviceInput' => '\\CustomerManagement\\StructType\\AddVideoDeviceInput',
            'AddVideoDeviceResponse' => '\\CustomerManagement\\StructType\\AddVideoDeviceResponse',
            'AddVideoDeviceOutput' => '\\CustomerManagement\\StructType\\AddVideoDeviceOutput',
            'AddImageSensor' => '\\CustomerManagement\\StructType\\AddImageSensor',
            'AddImageSensorInput' => '\\CustomerManagement\\StructType\\AddImageSensorInput',
            'AddImageSensorResponse' => '\\CustomerManagement\\StructType\\AddImageSensorResponse',
            'GetImageSensorLatestCaptureInfo' => '\\CustomerManagement\\StructType\\GetImageSensorLatestCaptureInfo',
            'ImageSensorCaptureInput' => '\\CustomerManagement\\StructType\\ImageSensorCaptureInput',
            'GetImageSensorLatestCaptureInfoResponse' => '\\CustomerManagement\\StructType\\GetImageSensorLatestCaptureInfoResponse',
            'ImageSensorCaptureOutput' => '\\CustomerManagement\\StructType\\ImageSensorCaptureOutput',
            'ArrayOfCaptureReasonFlags' => '\\CustomerManagement\\ArrayType\\ArrayOfCaptureReasonFlags',
            'GetImageSensorUploadsInfo' => '\\CustomerManagement\\StructType\\GetImageSensorUploadsInfo',
            'ImageSensorUploadsInput' => '\\CustomerManagement\\StructType\\ImageSensorUploadsInput',
            'GetImageSensorUploadsInfoResponse' => '\\CustomerManagement\\StructType\\GetImageSensorUploadsInfoResponse',
            'ImageSensorUploadsOutput' => '\\CustomerManagement\\StructType\\ImageSensorUploadsOutput',
            'SetImageSensorSettings' => '\\CustomerManagement\\StructType\\SetImageSensorSettings',
            'SetImageSensorSettingsInput' => '\\CustomerManagement\\StructType\\SetImageSensorSettingsInput',
            'SetImageSensorSettingsResponse' => '\\CustomerManagement\\StructType\\SetImageSensorSettingsResponse',
            'SetImageSensorSettingsOutput' => '\\CustomerManagement\\StructType\\SetImageSensorSettingsOutput',
            'GetEligibleSensorGroups' => '\\CustomerManagement\\StructType\\GetEligibleSensorGroups',
            'GetEligibleSensorGroupsResponse' => '\\CustomerManagement\\StructType\\GetEligibleSensorGroupsResponse',
            'GetEligibleSensorGroupsOutput' => '\\CustomerManagement\\StructType\\GetEligibleSensorGroupsOutput',
            'GetEligibleSensorNames' => '\\CustomerManagement\\StructType\\GetEligibleSensorNames',
            'GetEligibleSensorNamesResponse' => '\\CustomerManagement\\StructType\\GetEligibleSensorNamesResponse',
            'GetEligibleSensorNamesOutput' => '\\CustomerManagement\\StructType\\GetEligibleSensorNamesOutput',
            'ArrayOfEligibleSensorName' => '\\CustomerManagement\\ArrayType\\ArrayOfEligibleSensorName',
            'EligibleSensorName' => '\\CustomerManagement\\StructType\\EligibleSensorName',
            'AddSensorGetSensorVoiceDescriptors' => '\\CustomerManagement\\StructType\\AddSensorGetSensorVoiceDescriptors',
            'AddSensorGetSensorVoiceDescriptorsResponse' => '\\CustomerManagement\\StructType\\AddSensorGetSensorVoiceDescriptorsResponse',
            'AddSensorGetSensorVoiceDescriptorsOutput' => '\\CustomerManagement\\StructType\\AddSensorGetSensorVoiceDescriptorsOutput',
            'ArrayOfSensorVoiceDescriptor' => '\\CustomerManagement\\ArrayType\\ArrayOfSensorVoiceDescriptor',
            'SensorVoiceDescriptor' => '\\CustomerManagement\\StructType\\SensorVoiceDescriptor',
            'AddSensorGetSensorTypes' => '\\CustomerManagement\\StructType\\AddSensorGetSensorTypes',
            'AddSensorGetSensorTypesResponse' => '\\CustomerManagement\\StructType\\AddSensorGetSensorTypesResponse',
            'AddSensorGetSensorTypesOutput' => '\\CustomerManagement\\StructType\\AddSensorGetSensorTypesOutput',
            'ArrayOfSensorType' => '\\CustomerManagement\\ArrayType\\ArrayOfSensorType',
            'SensorType' => '\\CustomerManagement\\StructType\\SensorType',
            'BackupPanelSettings' => '\\CustomerManagement\\StructType\\BackupPanelSettings',
            'BackupPanelSettingsInput' => '\\CustomerManagement\\StructType\\BackupPanelSettingsInput',
            'BackupPanelSettingsResponse' => '\\CustomerManagement\\StructType\\BackupPanelSettingsResponse',
            'BackupPanelSettingsOutput' => '\\CustomerManagement\\StructType\\BackupPanelSettingsOutput',
            'CheckPanelSettingsBackup' => '\\CustomerManagement\\StructType\\CheckPanelSettingsBackup',
            'CheckPanelSettingsBackupInput' => '\\CustomerManagement\\StructType\\CheckPanelSettingsBackupInput',
            'CheckPanelSettingsBackupResponse' => '\\CustomerManagement\\StructType\\CheckPanelSettingsBackupResponse',
            'CheckPanelSettingsBackupOutput' => '\\CustomerManagement\\StructType\\CheckPanelSettingsBackupOutput',
            'ArrayOfDeviceSettingBackupInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfDeviceSettingBackupInfo',
            'DeviceSettingBackupInfo' => '\\CustomerManagement\\StructType\\DeviceSettingBackupInfo',
            'RestoreBackedUpPanelSettings' => '\\CustomerManagement\\StructType\\RestoreBackedUpPanelSettings',
            'RestoreBackedUpPanelSettingsInput' => '\\CustomerManagement\\StructType\\RestoreBackedUpPanelSettingsInput',
            'RestoreBackedUpPanelSettingsResponse' => '\\CustomerManagement\\StructType\\RestoreBackedUpPanelSettingsResponse',
            'RestoreBackedUpPanelSettingsOutput' => '\\CustomerManagement\\StructType\\RestoreBackedUpPanelSettingsOutput',
            'SetAutoPhoneTestSettings' => '\\CustomerManagement\\StructType\\SetAutoPhoneTestSettings',
            'SetAutoPhoneTestSettingsInput' => '\\CustomerManagement\\StructType\\SetAutoPhoneTestSettingsInput',
            'SetAutoPhoneTestSettingsResponse' => '\\CustomerManagement\\StructType\\SetAutoPhoneTestSettingsResponse',
            'SetAutoPhoneTestSettingsOutput' => '\\CustomerManagement\\StructType\\SetAutoPhoneTestSettingsOutput',
            'EditMasterCode' => '\\CustomerManagement\\StructType\\EditMasterCode',
            'EditCustomerMasterCodeInput' => '\\CustomerManagement\\StructType\\EditCustomerMasterCodeInput',
            'EditMasterCodeResponse' => '\\CustomerManagement\\StructType\\EditMasterCodeResponse',
            'EditCustomerMasterCodeOutput' => '\\CustomerManagement\\StructType\\EditCustomerMasterCodeOutput',
            'RequestUpdatedEquipmentList' => '\\CustomerManagement\\StructType\\RequestUpdatedEquipmentList',
            'RequestUpdatedEquipmentListResponse' => '\\CustomerManagement\\StructType\\RequestUpdatedEquipmentListResponse',
            'RequestUpdatedEquipmentListOutput' => '\\CustomerManagement\\StructType\\RequestUpdatedEquipmentListOutput',
            'UpdateDeviceName' => '\\CustomerManagement\\StructType\\UpdateDeviceName',
            'UpdateDeviceNameInput' => '\\CustomerManagement\\StructType\\UpdateDeviceNameInput',
            'UpdateDeviceNameResponse' => '\\CustomerManagement\\StructType\\UpdateDeviceNameResponse',
            'UpdateDeviceNameOutput' => '\\CustomerManagement\\StructType\\UpdateDeviceNameOutput',
            'UpdateSensorDevice' => '\\CustomerManagement\\StructType\\UpdateSensorDevice',
            'UpdateSensorDeviceInput' => '\\CustomerManagement\\StructType\\UpdateSensorDeviceInput',
            'UpdateSensorDeviceResponse' => '\\CustomerManagement\\StructType\\UpdateSensorDeviceResponse',
            'UpdateSensorDeviceOutput' => '\\CustomerManagement\\StructType\\UpdateSensorDeviceOutput',
            'UpdateSensorTypeIDQolsys' => '\\CustomerManagement\\StructType\\UpdateSensorTypeIDQolsys',
            'UpdateSensorTypeIDQolsysInput' => '\\CustomerManagement\\StructType\\UpdateSensorTypeIDQolsysInput',
            'UpdateSensorTypeIDQolsysResponse' => '\\CustomerManagement\\StructType\\UpdateSensorTypeIDQolsysResponse',
            'UpdateSensorTypeIDQolsysOutput' => '\\CustomerManagement\\StructType\\UpdateSensorTypeIDQolsysOutput',
            'UpdateSensorGroup' => '\\CustomerManagement\\StructType\\UpdateSensorGroup',
            'UpdateSensorGroupInput' => '\\CustomerManagement\\StructType\\UpdateSensorGroupInput',
            'UpdateSensorGroupResponse' => '\\CustomerManagement\\StructType\\UpdateSensorGroupResponse',
            'UpdateSensorGroupOutput' => '\\CustomerManagement\\StructType\\UpdateSensorGroupOutput',
            'Update2GigSensorGroup' => '\\CustomerManagement\\StructType\\Update2GigSensorGroup',
            'Update2GigSensorGroupInput' => '\\CustomerManagement\\StructType\\Update2GigSensorGroupInput',
            'Update2GigSensorGroupResponse' => '\\CustomerManagement\\StructType\\Update2GigSensorGroupResponse',
            'Update2GigSensorGroupOutput' => '\\CustomerManagement\\StructType\\Update2GigSensorGroupOutput',
            'UpdateNxSensorType' => '\\CustomerManagement\\StructType\\UpdateNxSensorType',
            'UpdateNxSensorTypeInput' => '\\CustomerManagement\\StructType\\UpdateNxSensorTypeInput',
            'UpdateNxSensorTypeResponse' => '\\CustomerManagement\\StructType\\UpdateNxSensorTypeResponse',
            'UpdateNxSensorTypeOutput' => '\\CustomerManagement\\StructType\\UpdateNxSensorTypeOutput',
            'UpdateSensorVoiceDescriptors2Gig' => '\\CustomerManagement\\StructType\\UpdateSensorVoiceDescriptors2Gig',
            'UpdateSensorVoiceDescriptors2GigInput' => '\\CustomerManagement\\StructType\\UpdateSensorVoiceDescriptors2GigInput',
            'UpdateSensorVoiceDescriptors2GigResponse' => '\\CustomerManagement\\StructType\\UpdateSensorVoiceDescriptors2GigResponse',
            'UpdateSensorVoiceDescriptors2GigOutput' => '\\CustomerManagement\\StructType\\UpdateSensorVoiceDescriptors2GigOutput',
            'AddUserCode' => '\\CustomerManagement\\StructType\\AddUserCode',
            'AddUserCodeInput' => '\\CustomerManagement\\StructType\\AddUserCodeInput',
            'AddUserCodeResponse' => '\\CustomerManagement\\StructType\\AddUserCodeResponse',
            'AddUserCodeOutput' => '\\CustomerManagement\\StructType\\AddUserCodeOutput',
            'EditUserCode' => '\\CustomerManagement\\StructType\\EditUserCode',
            'EditUserCodeInput' => '\\CustomerManagement\\StructType\\EditUserCodeInput',
            'EditUserCodeResponse' => '\\CustomerManagement\\StructType\\EditUserCodeResponse',
            'EditUserCodeOutput' => '\\CustomerManagement\\StructType\\EditUserCodeOutput',
            'GetUserCodes' => '\\CustomerManagement\\StructType\\GetUserCodes',
            'GetUserCodesResponse' => '\\CustomerManagement\\StructType\\GetUserCodesResponse',
            'GetUserCodesOutput' => '\\CustomerManagement\\StructType\\GetUserCodesOutput',
            'ArrayOfWsUserCodeInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfWsUserCodeInfo',
            'WsUserCodeInfo' => '\\CustomerManagement\\StructType\\WsUserCodeInfo',
            'ArrayOfWsPointAccessDeviceId' => '\\CustomerManagement\\ArrayType\\ArrayOfWsPointAccessDeviceId',
            'WsPointAccessDeviceId' => '\\CustomerManagement\\StructType\\WsPointAccessDeviceId',
            'SetWifi' => '\\CustomerManagement\\StructType\\SetWifi',
            'SetWifiInput' => '\\CustomerManagement\\StructType\\SetWifiInput',
            'SetWifiResponse' => '\\CustomerManagement\\StructType\\SetWifiResponse',
            'SetWifiOutput' => '\\CustomerManagement\\StructType\\SetWifiOutput',
            'GetAvailableWifiNetworks' => '\\CustomerManagement\\StructType\\GetAvailableWifiNetworks',
            'GetAvailableWifiNetworksResponse' => '\\CustomerManagement\\StructType\\GetAvailableWifiNetworksResponse',
            'GetAvailableWifiNetworksOutput' => '\\CustomerManagement\\StructType\\GetAvailableWifiNetworksOutput',
            'ArrayOfWiFiNetworkInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfWiFiNetworkInfo',
            'WiFiNetworkInfo' => '\\CustomerManagement\\StructType\\WiFiNetworkInfo',
            'RequestAvailableWifiNetworkNames' => '\\CustomerManagement\\StructType\\RequestAvailableWifiNetworkNames',
            'RequestAvailableWifiNetworkNamesResponse' => '\\CustomerManagement\\StructType\\RequestAvailableWifiNetworkNamesResponse',
            'RequestAvailableWifiNetworkNamesOutput' => '\\CustomerManagement\\StructType\\RequestAvailableWifiNetworkNamesOutput',
            'UpdatePanelCommunicationSetting' => '\\CustomerManagement\\StructType\\UpdatePanelCommunicationSetting',
            'UpdatePanelCommunicationSettingResponse' => '\\CustomerManagement\\StructType\\UpdatePanelCommunicationSettingResponse',
            'UpdatePanelCommunicationSettingOutput' => '\\CustomerManagement\\StructType\\UpdatePanelCommunicationSettingOutput',
            'GetCustomerBestPractices' => '\\CustomerManagement\\StructType\\GetCustomerBestPractices',
            'GetCustomerBestPracticesResponse' => '\\CustomerManagement\\StructType\\GetCustomerBestPracticesResponse',
            'CustomerBestPracticesOutput' => '\\CustomerManagement\\StructType\\CustomerBestPracticesOutput',
            'GetCommunicationSetting' => '\\CustomerManagement\\StructType\\GetCommunicationSetting',
            'GetCommunicationSettingResponse' => '\\CustomerManagement\\StructType\\GetCommunicationSettingResponse',
            'GetCommunicationSettingOutput' => '\\CustomerManagement\\StructType\\GetCommunicationSettingOutput',
            'GetDualPathCommunicationStatus' => '\\CustomerManagement\\StructType\\GetDualPathCommunicationStatus',
            'GetDualPathCommunicationStatusResponse' => '\\CustomerManagement\\StructType\\GetDualPathCommunicationStatusResponse',
            'GetDualPathCommunicationStatusOutput' => '\\CustomerManagement\\StructType\\GetDualPathCommunicationStatusOutput',
            'DualPathCommunicationStatus' => '\\CustomerManagement\\StructType\\DualPathCommunicationStatus',
            'GetEventHistory' => '\\CustomerManagement\\StructType\\GetEventHistory',
            'GetEventHistoryInput' => '\\CustomerManagement\\StructType\\GetEventHistoryInput',
            'GetEventHistoryResponse' => '\\CustomerManagement\\StructType\\GetEventHistoryResponse',
            'GetEventHistoryOutput' => '\\CustomerManagement\\StructType\\GetEventHistoryOutput',
            'ArrayOfEventHistoryItem' => '\\CustomerManagement\\ArrayType\\ArrayOfEventHistoryItem',
            'EventHistoryItem' => '\\CustomerManagement\\StructType\\EventHistoryItem',
            'ActivateInstantaneousMode' => '\\CustomerManagement\\StructType\\ActivateInstantaneousMode',
            'ActivateInstantaneousModeInput' => '\\CustomerManagement\\StructType\\ActivateInstantaneousModeInput',
            'ActivateInstantaneousModeResponse' => '\\CustomerManagement\\StructType\\ActivateInstantaneousModeResponse',
            'ActivateInstantaneousModeOutput' => '\\CustomerManagement\\StructType\\ActivateInstantaneousModeOutput',
            'EndInstantaneousMode' => '\\CustomerManagement\\StructType\\EndInstantaneousMode',
            'EndInstantaneousModeResponse' => '\\CustomerManagement\\StructType\\EndInstantaneousModeResponse',
            'EndInstantaneousModeOutput' => '\\CustomerManagement\\StructType\\EndInstantaneousModeOutput',
            'GetInstantaneousMode' => '\\CustomerManagement\\StructType\\GetInstantaneousMode',
            'GetInstantaneousModeResponse' => '\\CustomerManagement\\StructType\\GetInstantaneousModeResponse',
            'GetInstantaneousModeOutput' => '\\CustomerManagement\\StructType\\GetInstantaneousModeOutput',
            'GetPendingCommandInfo' => '\\CustomerManagement\\StructType\\GetPendingCommandInfo',
            'GetPendingCommandInfoResponse' => '\\CustomerManagement\\StructType\\GetPendingCommandInfoResponse',
            'GetPendingCommandInfoOutput' => '\\CustomerManagement\\StructType\\GetPendingCommandInfoOutput',
            'GetLatestCallerVersion' => '\\CustomerManagement\\StructType\\GetLatestCallerVersion',
            'GetLatestCallerVersionResponse' => '\\CustomerManagement\\StructType\\GetLatestCallerVersionResponse',
            'GetAllCommitments' => '\\CustomerManagement\\StructType\\GetAllCommitments',
            'GetAllCommitmentsInput' => '\\CustomerManagement\\StructType\\GetAllCommitmentsInput',
            'GetAllCommitmentsResponse' => '\\CustomerManagement\\StructType\\GetAllCommitmentsResponse',
            'GetAllCommitmentsOutput' => '\\CustomerManagement\\StructType\\GetAllCommitmentsOutput',
            'ArrayOfCommitmentInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfCommitmentInfo',
            'CommitmentInfo' => '\\CustomerManagement\\StructType\\CommitmentInfo',
            'ResetUnexpectedActivity' => '\\CustomerManagement\\StructType\\ResetUnexpectedActivity',
            'ResetUnexpectedActivityInput' => '\\CustomerManagement\\StructType\\ResetUnexpectedActivityInput',
            'ResetUnexpectedActivityResponse' => '\\CustomerManagement\\StructType\\ResetUnexpectedActivityResponse',
            'ResetUnexpectedActivityOutput' => '\\CustomerManagement\\StructType\\ResetUnexpectedActivityOutput',
            'GetRefreshToken' => '\\CustomerManagement\\StructType\\GetRefreshToken',
            'GetRefreshTokenInput' => '\\CustomerManagement\\StructType\\GetRefreshTokenInput',
            'GetRefreshTokenResponse' => '\\CustomerManagement\\StructType\\GetRefreshTokenResponse',
            'GetRefreshTokenOutput' => '\\CustomerManagement\\StructType\\GetRefreshTokenOutput',
            'GetOnsiteWrapUpStatus' => '\\CustomerManagement\\StructType\\GetOnsiteWrapUpStatus',
            'GetOnsiteWrapUpStatusInput' => '\\CustomerManagement\\StructType\\GetOnsiteWrapUpStatusInput',
            'GetOnsiteWrapUpStatusResponse' => '\\CustomerManagement\\StructType\\GetOnsiteWrapUpStatusResponse',
            'GetOnsiteWrapUpStatusOutput' => '\\CustomerManagement\\StructType\\GetOnsiteWrapUpStatusOutput',
            'ArrayOfOnsiteWrapUpResult' => '\\CustomerManagement\\ArrayType\\ArrayOfOnsiteWrapUpResult',
            'OnsiteWrapUpResult' => '\\CustomerManagement\\StructType\\OnsiteWrapUpResult',
            'CreateScheduledAppointment' => '\\CustomerManagement\\StructType\\CreateScheduledAppointment',
            'CreateScheduledAppointmentInput' => '\\CustomerManagement\\StructType\\CreateScheduledAppointmentInput',
            'CreateScheduledAppointmentResponse' => '\\CustomerManagement\\StructType\\CreateScheduledAppointmentResponse',
            'CreateScheduledAppointmentOutput' => '\\CustomerManagement\\StructType\\CreateScheduledAppointmentOutput',
            'EditScheduledAppointment' => '\\CustomerManagement\\StructType\\EditScheduledAppointment',
            'EditScheduledAppointmentInput' => '\\CustomerManagement\\StructType\\EditScheduledAppointmentInput',
            'EditScheduledAppointmentResponse' => '\\CustomerManagement\\StructType\\EditScheduledAppointmentResponse',
            'EditScheduledAppointmentOutput' => '\\CustomerManagement\\StructType\\EditScheduledAppointmentOutput',
            'GetScheduledAppointment' => '\\CustomerManagement\\StructType\\GetScheduledAppointment',
            'GetScheduledAppointmentInput' => '\\CustomerManagement\\StructType\\GetScheduledAppointmentInput',
            'GetScheduledAppointmentResponse' => '\\CustomerManagement\\StructType\\GetScheduledAppointmentResponse',
            'GetScheduledAppointmentOutput' => '\\CustomerManagement\\StructType\\GetScheduledAppointmentOutput',
            'ScheduledServiceDateInfo' => '\\CustomerManagement\\StructType\\ScheduledServiceDateInfo',
            'EnableInteractiveLockout' => '\\CustomerManagement\\StructType\\EnableInteractiveLockout',
            'EnableInteractiveLockoutInput' => '\\CustomerManagement\\StructType\\EnableInteractiveLockoutInput',
            'EnableInteractiveLockoutResponse' => '\\CustomerManagement\\StructType\\EnableInteractiveLockoutResponse',
            'EnableInteractiveLockoutOutput' => '\\CustomerManagement\\StructType\\EnableInteractiveLockoutOutput',
            'DisableInteractiveLockout' => '\\CustomerManagement\\StructType\\DisableInteractiveLockout',
            'DisableInteractiveLockoutInput' => '\\CustomerManagement\\StructType\\DisableInteractiveLockoutInput',
            'DisableInteractiveLockoutResponse' => '\\CustomerManagement\\StructType\\DisableInteractiveLockoutResponse',
            'DisableInteractiveLockoutOutput' => '\\CustomerManagement\\StructType\\DisableInteractiveLockoutOutput',
            'GetInteractiveLockoutStatus' => '\\CustomerManagement\\StructType\\GetInteractiveLockoutStatus',
            'GetInteractiveLockoutStatusResponse' => '\\CustomerManagement\\StructType\\GetInteractiveLockoutStatusResponse',
            'GetInteractiveLockoutStatusOuput' => '\\CustomerManagement\\StructType\\GetInteractiveLockoutStatusOuput',
            'GetReturnUrl' => '\\CustomerManagement\\StructType\\GetReturnUrl',
            'GetReturnUrlInput' => '\\CustomerManagement\\StructType\\GetReturnUrlInput',
            'GetReturnUrlResponse' => '\\CustomerManagement\\StructType\\GetReturnUrlResponse',
            'GetReturnUrlOutput' => '\\CustomerManagement\\StructType\\GetReturnUrlOutput',
            'GetSolarSystems' => '\\CustomerManagement\\StructType\\GetSolarSystems',
            'GetSolarSystemsResponse' => '\\CustomerManagement\\StructType\\GetSolarSystemsResponse',
            'GetSolarSystemsOutput' => '\\CustomerManagement\\StructType\\GetSolarSystemsOutput',
            'ArrayOfSolarSystemInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfSolarSystemInfo',
            'SolarSystemInfo' => '\\CustomerManagement\\StructType\\SolarSystemInfo',
            'GetSolarData' => '\\CustomerManagement\\StructType\\GetSolarData',
            'GetSolarDataInput' => '\\CustomerManagement\\StructType\\GetSolarDataInput',
            'GetSolarDataResponse' => '\\CustomerManagement\\StructType\\GetSolarDataResponse',
            'GetSolarDataOutput' => '\\CustomerManagement\\StructType\\GetSolarDataOutput',
            'CreateSolarConnection' => '\\CustomerManagement\\StructType\\CreateSolarConnection',
            'CreateSolarConnectionInput' => '\\CustomerManagement\\StructType\\CreateSolarConnectionInput',
            'CreateSolarConnectionResponse' => '\\CustomerManagement\\StructType\\CreateSolarConnectionResponse',
            'CreateSolarConnectionOutput' => '\\CustomerManagement\\StructType\\CreateSolarConnectionOutput',
            'GetElectricityProviders' => '\\CustomerManagement\\StructType\\GetElectricityProviders',
            'GetElectricityProvidersInput' => '\\CustomerManagement\\StructType\\GetElectricityProvidersInput',
            'GetElectricityProvidersResponse' => '\\CustomerManagement\\StructType\\GetElectricityProvidersResponse',
            'GetElectricityProvidersOutput' => '\\CustomerManagement\\StructType\\GetElectricityProvidersOutput',
            'ArrayOfElectricityProviderInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfElectricityProviderInfo',
            'ElectricityProviderInfo' => '\\CustomerManagement\\StructType\\ElectricityProviderInfo',
            'GetElectricityPlans' => '\\CustomerManagement\\StructType\\GetElectricityPlans',
            'GetElectricityPlansInput' => '\\CustomerManagement\\StructType\\GetElectricityPlansInput',
            'GetElectricityPlansResponse' => '\\CustomerManagement\\StructType\\GetElectricityPlansResponse',
            'GetElectricityPlansOutput' => '\\CustomerManagement\\StructType\\GetElectricityPlansOutput',
            'ArrayOfElectricityPlanInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfElectricityPlanInfo',
            'ElectricityPlanInfo' => '\\CustomerManagement\\StructType\\ElectricityPlanInfo',
            'SaveUtilityInfo' => '\\CustomerManagement\\StructType\\SaveUtilityInfo',
            'SaveUtilityInfoInput' => '\\CustomerManagement\\StructType\\SaveUtilityInfoInput',
            'SaveUtilityInfoResponse' => '\\CustomerManagement\\StructType\\SaveUtilityInfoResponse',
            'SaveUtilityInfoOutput' => '\\CustomerManagement\\StructType\\SaveUtilityInfoOutput',
            'GetDeviceNotes' => '\\CustomerManagement\\StructType\\GetDeviceNotes',
            'GetDeviceNotesResponse' => '\\CustomerManagement\\StructType\\GetDeviceNotesResponse',
            'GetDeviceNotesOutput' => '\\CustomerManagement\\StructType\\GetDeviceNotesOutput',
            'ArrayOfGeneralDeviceNote' => '\\CustomerManagement\\ArrayType\\ArrayOfGeneralDeviceNote',
            'GeneralDeviceNote' => '\\CustomerManagement\\StructType\\GeneralDeviceNote',
            'ArrayOfDeviceNoteImage' => '\\CustomerManagement\\ArrayType\\ArrayOfDeviceNoteImage',
            'DeviceNoteImage' => '\\CustomerManagement\\StructType\\DeviceNoteImage',
            'ArrayOfEquipmentDeviceNote' => '\\CustomerManagement\\ArrayType\\ArrayOfEquipmentDeviceNote',
            'EquipmentDeviceNote' => '\\CustomerManagement\\StructType\\EquipmentDeviceNote',
            'AddUpdateZwaveDeviceSpecificKey' => '\\CustomerManagement\\StructType\\AddUpdateZwaveDeviceSpecificKey',
            'AddUpdateZwaveDeviceSpecificKeyInput' => '\\CustomerManagement\\StructType\\AddUpdateZwaveDeviceSpecificKeyInput',
            'AddUpdateZwaveDeviceSpecificKeyResponse' => '\\CustomerManagement\\StructType\\AddUpdateZwaveDeviceSpecificKeyResponse',
            'AddUpdateZwaveDeviceSpecificKeyOutput' => '\\CustomerManagement\\StructType\\AddUpdateZwaveDeviceSpecificKeyOutput',
            'BaseZwaveDeviceSpecificKeyOutput' => '\\CustomerManagement\\StructType\\BaseZwaveDeviceSpecificKeyOutput',
            'CustomerManagementPendingDsk' => '\\CustomerManagement\\StructType\\CustomerManagementPendingDsk',
            'GetPendingZwaveDeviceSpecificKeys' => '\\CustomerManagement\\StructType\\GetPendingZwaveDeviceSpecificKeys',
            'GetPendingZwaveDeviceSpecificKeysInput' => '\\CustomerManagement\\StructType\\GetPendingZwaveDeviceSpecificKeysInput',
            'GetPendingZwaveDeviceSpecificKeysResponse' => '\\CustomerManagement\\StructType\\GetPendingZwaveDeviceSpecificKeysResponse',
            'GetPendingZwaveDeviceSpecificKeysOutput' => '\\CustomerManagement\\StructType\\GetPendingZwaveDeviceSpecificKeysOutput',
            'ArrayOfCustomerManagementPendingDsk' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerManagementPendingDsk',
            'DeletePendingZwaveDeviceSpecificKey' => '\\CustomerManagement\\StructType\\DeletePendingZwaveDeviceSpecificKey',
            'DeletePendingZwaveDeviceSpecificKeyInput' => '\\CustomerManagement\\StructType\\DeletePendingZwaveDeviceSpecificKeyInput',
            'DeletePendingZwaveDeviceSpecificKeyResponse' => '\\CustomerManagement\\StructType\\DeletePendingZwaveDeviceSpecificKeyResponse',
            'DeletePendingZwaveDeviceSpecificKeyOutput' => '\\CustomerManagement\\StructType\\DeletePendingZwaveDeviceSpecificKeyOutput',
            'IsModemActivated' => '\\CustomerManagement\\StructType\\IsModemActivated',
            'IsModemActivatedResponse' => '\\CustomerManagement\\StructType\\IsModemActivatedResponse',
            'ActivateModem' => '\\CustomerManagement\\StructType\\ActivateModem',
            'ActivateModemResponse' => '\\CustomerManagement\\StructType\\ActivateModemResponse',
            'TerminateModem' => '\\CustomerManagement\\StructType\\TerminateModem',
            'TerminateModemResponse' => '\\CustomerManagement\\StructType\\TerminateModemResponse',
            'TerminateModem_v2' => '\\CustomerManagement\\StructType\\TerminateModem_v2',
            'TerminateModemInput' => '\\CustomerManagement\\StructType\\TerminateModemInput',
            'TerminateModem_v2Response' => '\\CustomerManagement\\StructType\\TerminateModem_v2Response',
            'GetModemSerialFromIccid' => '\\CustomerManagement\\StructType\\GetModemSerialFromIccid',
            'GetModemSerialFromIccidResponse' => '\\CustomerManagement\\StructType\\GetModemSerialFromIccidResponse',
            'GetSimStatusDuringActivation' => '\\CustomerManagement\\StructType\\GetSimStatusDuringActivation',
            'GetSimStatusDuringActivationInput' => '\\CustomerManagement\\StructType\\GetSimStatusDuringActivationInput',
            'GetSimStatusDuringActivationResponse' => '\\CustomerManagement\\StructType\\GetSimStatusDuringActivationResponse',
            'GetSimStatusDuringActivationOutput' => '\\CustomerManagement\\StructType\\GetSimStatusDuringActivationOutput',
            'GetLastMessageDate' => '\\CustomerManagement\\StructType\\GetLastMessageDate',
            'GetLastMessageDateResponse' => '\\CustomerManagement\\StructType\\GetLastMessageDateResponse',
            'GetLastMessageDateOutput' => '\\CustomerManagement\\StructType\\GetLastMessageDateOutput',
            'GetLastPanelDate' => '\\CustomerManagement\\StructType\\GetLastPanelDate',
            'GetLastPanelDateInput' => '\\CustomerManagement\\StructType\\GetLastPanelDateInput',
            'GetLastPanelDateResponse' => '\\CustomerManagement\\StructType\\GetLastPanelDateResponse',
            'GetLastPanelDateOutput' => '\\CustomerManagement\\StructType\\GetLastPanelDateOutput',
            'GetLastCsEventDate' => '\\CustomerManagement\\StructType\\GetLastCsEventDate',
            'GetLastCsEventDateResponse' => '\\CustomerManagement\\StructType\\GetLastCsEventDateResponse',
            'GetLastCsEventDateOutput' => '\\CustomerManagement\\StructType\\GetLastCsEventDateOutput',
            'HardResetModuleQolsys' => '\\CustomerManagement\\StructType\\HardResetModuleQolsys',
            'HardResetModuleQolsysInput' => '\\CustomerManagement\\StructType\\HardResetModuleQolsysInput',
            'HardResetModuleQolsysResponse' => '\\CustomerManagement\\StructType\\HardResetModuleQolsysResponse',
            'HardResetModuleQolsysOutput' => '\\CustomerManagement\\StructType\\HardResetModuleQolsysOutput',
            'CreateCustomer' => '\\CustomerManagement\\StructType\\CreateCustomer',
            'CreateCustomerInput' => '\\CustomerManagement\\StructType\\CreateCustomerInput',
            'ArrayOfCentralStationEventGroupEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfCentralStationEventGroupEnum',
            'ArrayOfAddOnFeatureEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfAddOnFeatureEnum',
            'ArrayOfCustomerNotificationEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerNotificationEnum',
            'CreateCustomerResponse' => '\\CustomerManagement\\StructType\\CreateCustomerResponse',
            'CreateCustomerOutput' => '\\CustomerManagement\\StructType\\CreateCustomerOutput',
            'ApplyPanelTemplate' => '\\CustomerManagement\\StructType\\ApplyPanelTemplate',
            'ApplyPanelTemplateResponse' => '\\CustomerManagement\\StructType\\ApplyPanelTemplateResponse',
            'ApplyPanelTemplateOutput' => '\\CustomerManagement\\StructType\\ApplyPanelTemplateOutput',
            'CreateCommitment' => '\\CustomerManagement\\StructType\\CreateCommitment',
            'CreateCommitmentInput' => '\\CustomerManagement\\StructType\\CreateCommitmentInput',
            'CommitmentRelatedInfo' => '\\CustomerManagement\\StructType\\CommitmentRelatedInfo',
            'CreateCommitmentResponse' => '\\CustomerManagement\\StructType\\CreateCommitmentResponse',
            'ActivateCommitment' => '\\CustomerManagement\\StructType\\ActivateCommitment',
            'ActivateCommitmentInput' => '\\CustomerManagement\\StructType\\ActivateCommitmentInput',
            'ActivateCommitmentResponse' => '\\CustomerManagement\\StructType\\ActivateCommitmentResponse',
            'ActivateCommitmentOutput' => '\\CustomerManagement\\StructType\\ActivateCommitmentOutput',
            'RecycleAccount' => '\\CustomerManagement\\StructType\\RecycleAccount',
            'AccountRecycleRequest' => '\\CustomerManagement\\StructType\\AccountRecycleRequest',
            'RecycleAccountResponse' => '\\CustomerManagement\\StructType\\RecycleAccountResponse',
            'AccountRecycleResponse' => '\\CustomerManagement\\StructType\\AccountRecycleResponse',
            'CreateCommitmentForDealer' => '\\CustomerManagement\\StructType\\CreateCommitmentForDealer',
            'CreateCommitmentForDealerResponse' => '\\CustomerManagement\\StructType\\CreateCommitmentForDealerResponse',
            'CreateCustomerForDealer' => '\\CustomerManagement\\StructType\\CreateCustomerForDealer',
            'CreateCustomerForDealerResponse' => '\\CustomerManagement\\StructType\\CreateCustomerForDealerResponse',
            'AddCustomerToGroup' => '\\CustomerManagement\\StructType\\AddCustomerToGroup',
            'AddCustomerToGroupResponse' => '\\CustomerManagement\\StructType\\AddCustomerToGroupResponse',
            'AddCustomerToGroupOutput' => '\\CustomerManagement\\StructType\\AddCustomerToGroupOutput',
            'CreateEnterpriseGroup' => '\\CustomerManagement\\StructType\\CreateEnterpriseGroup',
            'CreateEnterpriseGroupInput' => '\\CustomerManagement\\StructType\\CreateEnterpriseGroupInput',
            'CreateEnterpriseGroupResponse' => '\\CustomerManagement\\StructType\\CreateEnterpriseGroupResponse',
            'CreateEnterpriseGroupOutput' => '\\CustomerManagement\\StructType\\CreateEnterpriseGroupOutput',
            'UpdateEnterpriseRoles' => '\\CustomerManagement\\StructType\\UpdateEnterpriseRoles',
            'UpdateEnterpriseRolesInput' => '\\CustomerManagement\\StructType\\UpdateEnterpriseRolesInput',
            'UpdateEnterpriseRolesResponse' => '\\CustomerManagement\\StructType\\UpdateEnterpriseRolesResponse',
            'UpdateEnterpriseRolesOutput' => '\\CustomerManagement\\StructType\\UpdateEnterpriseRolesOutput',
            'EmailWelcomeLetter' => '\\CustomerManagement\\StructType\\EmailWelcomeLetter',
            'EmailWelcomeLetterResponse' => '\\CustomerManagement\\StructType\\EmailWelcomeLetterResponse',
            'EmailWelcomeLetterOutput' => '\\CustomerManagement\\StructType\\EmailWelcomeLetterOutput',
            'CheckAvailableLoginName' => '\\CustomerManagement\\StructType\\CheckAvailableLoginName',
            'CheckCustomerLoginInput' => '\\CustomerManagement\\StructType\\CheckCustomerLoginInput',
            'CheckAvailableLoginNameResponse' => '\\CustomerManagement\\StructType\\CheckAvailableLoginNameResponse',
            'CheckCustomerLoginOutput' => '\\CustomerManagement\\StructType\\CheckCustomerLoginOutput',
            'AddCustomerLogin' => '\\CustomerManagement\\StructType\\AddCustomerLogin',
            'AddCustomerLoginInput' => '\\CustomerManagement\\StructType\\AddCustomerLoginInput',
            'AddCustomerLoginResponse' => '\\CustomerManagement\\StructType\\AddCustomerLoginResponse',
            'AddCustomerLoginOutput' => '\\CustomerManagement\\StructType\\AddCustomerLoginOutput',
            'DeleteCustomerLogin' => '\\CustomerManagement\\StructType\\DeleteCustomerLogin',
            'DeleteCustomerLoginInput' => '\\CustomerManagement\\StructType\\DeleteCustomerLoginInput',
            'DeleteCustomerLoginResponse' => '\\CustomerManagement\\StructType\\DeleteCustomerLoginResponse',
            'DeleteCustomerLoginOutput' => '\\CustomerManagement\\StructType\\DeleteCustomerLoginOutput',
            'UpdateRoles' => '\\CustomerManagement\\StructType\\UpdateRoles',
            'UpdateRolesInput' => '\\CustomerManagement\\StructType\\UpdateRolesInput',
            'UpdateRolesResponse' => '\\CustomerManagement\\StructType\\UpdateRolesResponse',
            'UpdateRolesOutput' => '\\CustomerManagement\\StructType\\UpdateRolesOutput',
            'RequestRoundTripCsTest' => '\\CustomerManagement\\StructType\\RequestRoundTripCsTest',
            'RequestRoundTripCsTestResponse' => '\\CustomerManagement\\StructType\\RequestRoundTripCsTestResponse',
            'RequestRoundTripCsTestOutput' => '\\CustomerManagement\\StructType\\RequestRoundTripCsTestOutput',
            'RequestSignalStrength' => '\\CustomerManagement\\StructType\\RequestSignalStrength',
            'RequestSignalStrengthResponse' => '\\CustomerManagement\\StructType\\RequestSignalStrengthResponse',
            'RequestSignalStrengthOutput' => '\\CustomerManagement\\StructType\\RequestSignalStrengthOutput',
            'GetSignalStrengthSummary' => '\\CustomerManagement\\StructType\\GetSignalStrengthSummary',
            'GetSignalStrengthSummaryResponse' => '\\CustomerManagement\\StructType\\GetSignalStrengthSummaryResponse',
            'GetSignalStrengthSummaryOutput' => '\\CustomerManagement\\StructType\\GetSignalStrengthSummaryOutput',
            'LastActivityOutput' => '\\CustomerManagement\\StructType\\LastActivityOutput',
            'CellSignalingSummaryOutput' => '\\CustomerManagement\\StructType\\CellSignalingSummaryOutput',
            'SignalStrengthOutput' => '\\CustomerManagement\\StructType\\SignalStrengthOutput',
            'GetSignalStrengthHistory' => '\\CustomerManagement\\StructType\\GetSignalStrengthHistory',
            'GetSignalStrengthHistoryResponse' => '\\CustomerManagement\\StructType\\GetSignalStrengthHistoryResponse',
            'GetSignalStrengthHistoryOutput' => '\\CustomerManagement\\StructType\\GetSignalStrengthHistoryOutput',
            'ArrayOfSignalStrengthInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfSignalStrengthInfo',
            'SignalStrengthInfo' => '\\CustomerManagement\\StructType\\SignalStrengthInfo',
            'SwapModem' => '\\CustomerManagement\\StructType\\SwapModem',
            'SwapModemInput' => '\\CustomerManagement\\StructType\\SwapModemInput',
            'SwapModemResponse' => '\\CustomerManagement\\StructType\\SwapModemResponse',
            'SwapModemOutput' => '\\CustomerManagement\\StructType\\SwapModemOutput',
            'GetDeviceList' => '\\CustomerManagement\\StructType\\GetDeviceList',
            'GetDeviceListResponse' => '\\CustomerManagement\\StructType\\GetDeviceListResponse',
            'GetFullEquipmentList' => '\\CustomerManagement\\StructType\\GetFullEquipmentList',
            'GetFullEquipmentListResponse' => '\\CustomerManagement\\StructType\\GetFullEquipmentListResponse',
            'RequestFirmwareVersionCommand' => '\\CustomerManagement\\StructType\\RequestFirmwareVersionCommand',
            'RequestFirmwareVersionCommandResponse' => '\\CustomerManagement\\StructType\\RequestFirmwareVersionCommandResponse',
            'RequestFirmwareVersionCommandOutput' => '\\CustomerManagement\\StructType\\RequestFirmwareVersionCommandOutput',
            'EmulateTransferAccounts' => '\\CustomerManagement\\StructType\\EmulateTransferAccounts',
            'ArrayOfTransferAccountInput' => '\\CustomerManagement\\ArrayType\\ArrayOfTransferAccountInput',
            'TransferAccountInput' => '\\CustomerManagement\\StructType\\TransferAccountInput',
            'EmulateTransferAccountsResponse' => '\\CustomerManagement\\StructType\\EmulateTransferAccountsResponse',
            'ArrayOfTransferAccountOutput' => '\\CustomerManagement\\ArrayType\\ArrayOfTransferAccountOutput',
            'TransferAccountOutput' => '\\CustomerManagement\\StructType\\TransferAccountOutput',
            'TransferAccounts' => '\\CustomerManagement\\StructType\\TransferAccounts',
            'TransferAccountsResponse' => '\\CustomerManagement\\StructType\\TransferAccountsResponse',
            'TerminateCustomer' => '\\CustomerManagement\\StructType\\TerminateCustomer',
            'TerminateCustomerResponse' => '\\CustomerManagement\\StructType\\TerminateCustomerResponse',
            'RequestSensorNames' => '\\CustomerManagement\\StructType\\RequestSensorNames',
            'RequestSensorNamesResponse' => '\\CustomerManagement\\StructType\\RequestSensorNamesResponse',
            'LookupCustomerId' => '\\CustomerManagement\\StructType\\LookupCustomerId',
            'LookupCustomerIdResponse' => '\\CustomerManagement\\StructType\\LookupCustomerIdResponse',
            'LookupCustomerIdForDealer' => '\\CustomerManagement\\StructType\\LookupCustomerIdForDealer',
            'LookupCustomerIdForDealerResponse' => '\\CustomerManagement\\StructType\\LookupCustomerIdForDealerResponse',
            'LookupCustomerIdFromDealerCustomerId' => '\\CustomerManagement\\StructType\\LookupCustomerIdFromDealerCustomerId',
            'LookupCustomerIdFromDealerCustomerIdResponse' => '\\CustomerManagement\\StructType\\LookupCustomerIdFromDealerCustomerIdResponse',
            'LookupCustomerIdFromModemSerial' => '\\CustomerManagement\\StructType\\LookupCustomerIdFromModemSerial',
            'LookupCustomerIdFromModemSerialResponse' => '\\CustomerManagement\\StructType\\LookupCustomerIdFromModemSerialResponse',
            'GetCustomerInfo' => '\\CustomerManagement\\StructType\\GetCustomerInfo',
            'GetCustomerInfoResponse' => '\\CustomerManagement\\StructType\\GetCustomerInfoResponse',
            'CustomerInfo' => '\\CustomerManagement\\StructType\\CustomerInfo',
            'ModemInfo' => '\\CustomerManagement\\StructType\\ModemInfo',
            'CentralStationInfo' => '\\CustomerManagement\\StructType\\CentralStationInfo',
            'ServicePlanInfo' => '\\CustomerManagement\\StructType\\ServicePlanInfo',
            'GetCustomerInfo_V2' => '\\CustomerManagement\\StructType\\GetCustomerInfo_V2',
            'GetCustomerInfoInput' => '\\CustomerManagement\\StructType\\GetCustomerInfoInput',
            'GetCustomerInfo_V2Response' => '\\CustomerManagement\\StructType\\GetCustomerInfo_V2Response',
            'GetCustomerPrice' => '\\CustomerManagement\\StructType\\GetCustomerPrice',
            'GetCustomerPriceResponse' => '\\CustomerManagement\\StructType\\GetCustomerPriceResponse',
            'CustomerPriceInfo' => '\\CustomerManagement\\StructType\\CustomerPriceInfo',
            'ArrayOfFeaturePrice' => '\\CustomerManagement\\ArrayType\\ArrayOfFeaturePrice',
            'FeaturePrice' => '\\CustomerManagement\\StructType\\FeaturePrice',
            'GetCustomerTroubleConditions' => '\\CustomerManagement\\StructType\\GetCustomerTroubleConditions',
            'GetCustomerTroubleConditionsResponse' => '\\CustomerManagement\\StructType\\GetCustomerTroubleConditionsResponse',
            'ArrayOfTroubleConditionOutput' => '\\CustomerManagement\\ArrayType\\ArrayOfTroubleConditionOutput',
            'TroubleConditionOutput' => '\\CustomerManagement\\StructType\\TroubleConditionOutput',
            'GetCustomerTroubleConditions_v2' => '\\CustomerManagement\\StructType\\GetCustomerTroubleConditions_v2',
            'GetCustomerTroubleConditionsInput' => '\\CustomerManagement\\StructType\\GetCustomerTroubleConditionsInput',
            'GetCustomerTroubleConditions_v2Response' => '\\CustomerManagement\\StructType\\GetCustomerTroubleConditions_v2Response',
            'GetCustomerListWithTroubleConditions' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditions',
            'ArrayOfTroubleConditionTypeEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfTroubleConditionTypeEnum',
            'GetCustomerListWithTroubleConditionsResponse' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsResponse',
            'ArrayOfCustomerListWithTroubleConditions' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerListWithTroubleConditions',
            'CustomerListWithTroubleConditions' => '\\CustomerManagement\\StructType\\CustomerListWithTroubleConditions',
            'ArrayOfCustomerTroubleCondition' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerTroubleCondition',
            'CustomerTroubleCondition' => '\\CustomerManagement\\StructType\\CustomerTroubleCondition',
            'ArrayOfTroubleConditionWithDates' => '\\CustomerManagement\\ArrayType\\ArrayOfTroubleConditionWithDates',
            'TroubleConditionWithDates' => '\\CustomerManagement\\StructType\\TroubleConditionWithDates',
            'GetCustomerListWithTroubleConditions_v2' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditions_v2',
            'GetCustomerListWithTroubleConditionsInput' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsInput',
            'GetCustomerListWithTroubleConditions_v2Response' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditions_v2Response',
            'GetCustomerListWithTroubleConditionsCsv' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsCsv',
            'GetCustomerListWithTroubleConditionsCsvResponse' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsCsvResponse',
            'GetCustomerListWithTroubleConditionsCsv_v2' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsCsv_v2',
            'GetCustomerListWithTroubleConditionsCsv_v2Response' => '\\CustomerManagement\\StructType\\GetCustomerListWithTroubleConditionsCsv_v2Response',
            'GetResolvedTroubleConditionsCsv' => '\\CustomerManagement\\StructType\\GetResolvedTroubleConditionsCsv',
            'GetResolvedTroubleConditionsCsvInput' => '\\CustomerManagement\\StructType\\GetResolvedTroubleConditionsCsvInput',
            'GetResolvedTroubleConditionsCsvResponse' => '\\CustomerManagement\\StructType\\GetResolvedTroubleConditionsCsvResponse',
            'GetResolvedTroubleConditionsCsvOutput' => '\\CustomerManagement\\StructType\\GetResolvedTroubleConditionsCsvOutput',
            'GetCustomerListFor2G' => '\\CustomerManagement\\StructType\\GetCustomerListFor2G',
            'ArrayOfNetworkEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfNetworkEnum',
            'GetCustomerListFor2GResponse' => '\\CustomerManagement\\StructType\\GetCustomerListFor2GResponse',
            'RunSystemCheck' => '\\CustomerManagement\\StructType\\RunSystemCheck',
            'RunSystemCheckResponse' => '\\CustomerManagement\\StructType\\RunSystemCheckResponse',
            'RunSystemCheckOutput' => '\\CustomerManagement\\StructType\\RunSystemCheckOutput',
            'GetSystemCheckResults' => '\\CustomerManagement\\StructType\\GetSystemCheckResults',
            'GetSystemCheckResultsInput' => '\\CustomerManagement\\StructType\\GetSystemCheckResultsInput',
            'GetSystemCheckResultsResponse' => '\\CustomerManagement\\StructType\\GetSystemCheckResultsResponse',
            'GetSystemCheckResultsOutput' => '\\CustomerManagement\\StructType\\GetSystemCheckResultsOutput',
            'SystemCheckOutput' => '\\CustomerManagement\\StructType\\SystemCheckOutput',
            'ArrayOfSystemCheckCategoryOutput' => '\\CustomerManagement\\ArrayType\\ArrayOfSystemCheckCategoryOutput',
            'SystemCheckCategoryOutput' => '\\CustomerManagement\\StructType\\SystemCheckCategoryOutput',
            'SetGsmBandSelection' => '\\CustomerManagement\\StructType\\SetGsmBandSelection',
            'SetGsmBandSelectionResponse' => '\\CustomerManagement\\StructType\\SetGsmBandSelectionResponse',
            'GetCustomerListWithPanelSetting' => '\\CustomerManagement\\StructType\\GetCustomerListWithPanelSetting',
            'GetCustomerListWithPanelSettingInput' => '\\CustomerManagement\\StructType\\GetCustomerListWithPanelSettingInput',
            'ArrayOfPanelSettingCriteria' => '\\CustomerManagement\\ArrayType\\ArrayOfPanelSettingCriteria',
            'PanelSettingCriteria' => '\\CustomerManagement\\StructType\\PanelSettingCriteria',
            'GetCustomerListWithPanelSettingResponse' => '\\CustomerManagement\\StructType\\GetCustomerListWithPanelSettingResponse',
            'GetCustomerList' => '\\CustomerManagement\\StructType\\GetCustomerList',
            'GetCustomerListResponse' => '\\CustomerManagement\\StructType\\GetCustomerListResponse',
            'GetCustomerList_V2' => '\\CustomerManagement\\StructType\\GetCustomerList_V2',
            'GetCustomerListInput' => '\\CustomerManagement\\StructType\\GetCustomerListInput',
            'GetCustomerList_V2Response' => '\\CustomerManagement\\StructType\\GetCustomerList_V2Response',
            'GetCustomerListOutput' => '\\CustomerManagement\\StructType\\GetCustomerListOutput',
            'GetCustomerListByBranchId' => '\\CustomerManagement\\StructType\\GetCustomerListByBranchId',
            'GetCustomerListByBranchIdResponse' => '\\CustomerManagement\\StructType\\GetCustomerListByBranchIdResponse',
            'GetCustomerListByEmail' => '\\CustomerManagement\\StructType\\GetCustomerListByEmail',
            'GetCustomerListByEmailResponse' => '\\CustomerManagement\\StructType\\GetCustomerListByEmailResponse',
            'GetCustomerListByLoginName' => '\\CustomerManagement\\StructType\\GetCustomerListByLoginName',
            'GetCustomerListByLoginNameInput' => '\\CustomerManagement\\StructType\\GetCustomerListByLoginNameInput',
            'GetCustomerListByLoginNameResponse' => '\\CustomerManagement\\StructType\\GetCustomerListByLoginNameResponse',
            'GetCustomerListByLoginNameOutput' => '\\CustomerManagement\\StructType\\GetCustomerListByLoginNameOutput',
            'ArrayOfCustomerListItem' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerListItem',
            'CustomerListItem' => '\\CustomerManagement\\StructType\\CustomerListItem',
            'GenerateCustomerLoginToken' => '\\CustomerManagement\\StructType\\GenerateCustomerLoginToken',
            'GenerateCustomerLoginTokenResponse' => '\\CustomerManagement\\StructType\\GenerateCustomerLoginTokenResponse',
            'GenerateCustomerLoginTokenOutput' => '\\CustomerManagement\\StructType\\GenerateCustomerLoginTokenOutput',
            'ValidateLoginPassword' => '\\CustomerManagement\\StructType\\ValidateLoginPassword',
            'ValidateLoginPasswordResponse' => '\\CustomerManagement\\StructType\\ValidateLoginPasswordResponse',
            'ValidateLoginPasswordOutput' => '\\CustomerManagement\\StructType\\ValidateLoginPasswordOutput',
            'ArrayOfCustomerPermissions' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerPermissions',
            'CustomerPermissions' => '\\CustomerManagement\\StructType\\CustomerPermissions',
            'ValidateLoginPassword_v2' => '\\CustomerManagement\\StructType\\ValidateLoginPassword_v2',
            'ValidateLoginPasswordInput' => '\\CustomerManagement\\StructType\\ValidateLoginPasswordInput',
            'ValidateLoginPassword_v2Response' => '\\CustomerManagement\\StructType\\ValidateLoginPassword_v2Response',
            'GenerateLoginToken' => '\\CustomerManagement\\StructType\\GenerateLoginToken',
            'GenerateLoginTokenResponse' => '\\CustomerManagement\\StructType\\GenerateLoginTokenResponse',
            'GenerateLoginToken_v2' => '\\CustomerManagement\\StructType\\GenerateLoginToken_v2',
            'GenerateLoginToken_v2Response' => '\\CustomerManagement\\StructType\\GenerateLoginToken_v2Response',
            'UpdateCustomerAddress' => '\\CustomerManagement\\StructType\\UpdateCustomerAddress',
            'UpdateCustomerAddressInput' => '\\CustomerManagement\\StructType\\UpdateCustomerAddressInput',
            'UpdateCustomerAddressResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerAddressResponse',
            'UpdateCustomerAddressOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerAddressOutput',
            'UpdateCustomerPassword' => '\\CustomerManagement\\StructType\\UpdateCustomerPassword',
            'UpdateCustomerPasswordResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerPasswordResponse',
            'UpdateCustomerPasswordOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerPasswordOutput',
            'UpdateCustomerLogin' => '\\CustomerManagement\\StructType\\UpdateCustomerLogin',
            'UpdateCustomerLoginResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginResponse',
            'UpdateCustomerLoginOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginOutput',
            'UpdateCustomerLoginInfo' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginInfo',
            'UpdateCustomerLoginInfoInput' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginInfoInput',
            'UpdateCustomerLoginInfoResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginInfoResponse',
            'UpdateCustomerLoginInfoOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerLoginInfoOutput',
            'UpdateCustomerName' => '\\CustomerManagement\\StructType\\UpdateCustomerName',
            'UpdateCustomerNameInput' => '\\CustomerManagement\\StructType\\UpdateCustomerNameInput',
            'UpdateCustomerNameResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerNameResponse',
            'UpdateCustomerNameOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerNameOutput',
            'UpdateCustomerReadyDate' => '\\CustomerManagement\\StructType\\UpdateCustomerReadyDate',
            'UpdateCustomerReadyDateInput' => '\\CustomerManagement\\StructType\\UpdateCustomerReadyDateInput',
            'UpdateCustomerReadyDateResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerReadyDateResponse',
            'UpdateCustomerReadyDateOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerReadyDateOutput',
            'UpdateAuthenticationProviderLoginName' => '\\CustomerManagement\\StructType\\UpdateAuthenticationProviderLoginName',
            'UpdateAuthenticationProviderLoginNameResponse' => '\\CustomerManagement\\StructType\\UpdateAuthenticationProviderLoginNameResponse',
            'UpdateAuthenticationProviderLoginNameOutput' => '\\CustomerManagement\\StructType\\UpdateAuthenticationProviderLoginNameOutput',
            'UpdateLoginPassword' => '\\CustomerManagement\\StructType\\UpdateLoginPassword',
            'UpdateLoginPasswordResponse' => '\\CustomerManagement\\StructType\\UpdateLoginPasswordResponse',
            'UpdateLoginPasswordOutput' => '\\CustomerManagement\\StructType\\UpdateLoginPasswordOutput',
            'UpdateLoginPasswordWithoutPassword' => '\\CustomerManagement\\StructType\\UpdateLoginPasswordWithoutPassword',
            'UpdateLoginPasswordWithoutPasswordResponse' => '\\CustomerManagement\\StructType\\UpdateLoginPasswordWithoutPasswordResponse',
            'InvalidateLoginTokens_v2' => '\\CustomerManagement\\StructType\\InvalidateLoginTokens_v2',
            'InvalidateLoginTokens_v2Response' => '\\CustomerManagement\\StructType\\InvalidateLoginTokens_v2Response',
            'InvalidateLoginTokensOutput' => '\\CustomerManagement\\StructType\\InvalidateLoginTokensOutput',
            'InvalidateLoginTokens' => '\\CustomerManagement\\StructType\\InvalidateLoginTokens',
            'InvalidateLoginTokensResponse' => '\\CustomerManagement\\StructType\\InvalidateLoginTokensResponse',
            'UpdateCustomerBranch' => '\\CustomerManagement\\StructType\\UpdateCustomerBranch',
            'UpdateCustomerBranchResponse' => '\\CustomerManagement\\StructType\\UpdateCustomerBranchResponse',
            'UpdateCustomerBranchOutput' => '\\CustomerManagement\\StructType\\UpdateCustomerBranchOutput',
            'UpdateDealerCustomerId' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerId',
            'UpdateDealerCustomerIdResponse' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerIdResponse',
            'UpdateDealerCustomerIdOutput' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerIdOutput',
            'UpdateInstallerSalesRep' => '\\CustomerManagement\\StructType\\UpdateInstallerSalesRep',
            'UpdateInstallerSalesRepInput' => '\\CustomerManagement\\StructType\\UpdateInstallerSalesRepInput',
            'UpdateInstallerSalesRepResponse' => '\\CustomerManagement\\StructType\\UpdateInstallerSalesRepResponse',
            'UpdateInstallerSalesRepOutput' => '\\CustomerManagement\\StructType\\UpdateInstallerSalesRepOutput',
            'UpdateEnrolledInMaintenance' => '\\CustomerManagement\\StructType\\UpdateEnrolledInMaintenance',
            'UpdateEnrolledInMaintenanceResponse' => '\\CustomerManagement\\StructType\\UpdateEnrolledInMaintenanceResponse',
            'UpdateEnrolledInMaintenanceOutput' => '\\CustomerManagement\\StructType\\UpdateEnrolledInMaintenanceOutput',
            'UpdateDealerCustomerSource' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerSource',
            'UpdateDealerCustomerSourceInput' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerSourceInput',
            'UpdateDealerCustomerSourceResponse' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerSourceResponse',
            'UpdateDealerCustomerSourceOutput' => '\\CustomerManagement\\StructType\\UpdateDealerCustomerSourceOutput',
            'UpdateInsuranceFeatures' => '\\CustomerManagement\\StructType\\UpdateInsuranceFeatures',
            'UpdateInsuranceFeaturesInput' => '\\CustomerManagement\\StructType\\UpdateInsuranceFeaturesInput',
            'UpdateInsuranceFeaturesResponse' => '\\CustomerManagement\\StructType\\UpdateInsuranceFeaturesResponse',
            'InsuranceFeaturesOutput' => '\\CustomerManagement\\StructType\\InsuranceFeaturesOutput',
            'HasInsuranceFeatures' => '\\CustomerManagement\\StructType\\HasInsuranceFeatures',
            'HasInsuranceFeaturesResponse' => '\\CustomerManagement\\StructType\\HasInsuranceFeaturesResponse',
            'UpdateCentralStationInfo' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfo',
            'UpdateCentralStationInfoResponse' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfoResponse',
            'UpdateCentralStationInfoOutput' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfoOutput',
            'UpdateCentralStationInfo_V2' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfo_V2',
            'UpdateCentralStationInfoInput' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfoInput',
            'UpdateCentralStationInfo_V2Response' => '\\CustomerManagement\\StructType\\UpdateCentralStationInfo_V2Response',
            'SetAddOnQuantity' => '\\CustomerManagement\\StructType\\SetAddOnQuantity',
            'SetAddOnQuantityResponse' => '\\CustomerManagement\\StructType\\SetAddOnQuantityResponse',
            'SetAddonQuantityOutput' => '\\CustomerManagement\\StructType\\SetAddonQuantityOutput',
            'ServicePlanAudit' => '\\CustomerManagement\\StructType\\ServicePlanAudit',
            'ServicePlanAuditInput' => '\\CustomerManagement\\StructType\\ServicePlanAuditInput',
            'ServicePlanAuditResponse' => '\\CustomerManagement\\StructType\\ServicePlanAuditResponse',
            'ServicePlanAuditOutput' => '\\CustomerManagement\\StructType\\ServicePlanAuditOutput',
            'ArrayOfCustomerPackage' => '\\CustomerManagement\\ArrayType\\ArrayOfCustomerPackage',
            'CustomerPackage' => '\\CustomerManagement\\StructType\\CustomerPackage',
            'ArrayOfAddOnHistoryItem' => '\\CustomerManagement\\ArrayType\\ArrayOfAddOnHistoryItem',
            'AddOnHistoryItem' => '\\CustomerManagement\\StructType\\AddOnHistoryItem',
            'DowngradeSecurityToSAVAccount' => '\\CustomerManagement\\StructType\\DowngradeSecurityToSAVAccount',
            'DowngradeSecurityToSAVAccountInput' => '\\CustomerManagement\\StructType\\DowngradeSecurityToSAVAccountInput',
            'DowngradeSecurityToSAVAccountResponse' => '\\CustomerManagement\\StructType\\DowngradeSecurityToSAVAccountResponse',
            'DowngradeSecurityToSAVAccountOutput' => '\\CustomerManagement\\StructType\\DowngradeSecurityToSAVAccountOutput',
            'UpgradeSAVToSecurityAccount' => '\\CustomerManagement\\StructType\\UpgradeSAVToSecurityAccount',
            'UpgradeSAVToSecurityAccountInput' => '\\CustomerManagement\\StructType\\UpgradeSAVToSecurityAccountInput',
            'UpgradeSAVToSecurityAccountResponse' => '\\CustomerManagement\\StructType\\UpgradeSAVToSecurityAccountResponse',
            'UpgradeSAVToSecurityAccountOutput' => '\\CustomerManagement\\StructType\\UpgradeSAVToSecurityAccountOutput',
            'ChangeServicePlan' => '\\CustomerManagement\\StructType\\ChangeServicePlan',
            'ChangeServicePlanResponse' => '\\CustomerManagement\\StructType\\ChangeServicePlanResponse',
            'ChangeServicePlanOutput' => '\\CustomerManagement\\StructType\\ChangeServicePlanOutput',
            'ChangeServicePlanTemplate' => '\\CustomerManagement\\StructType\\ChangeServicePlanTemplate',
            'ChangeServicePlanTemplateResponse' => '\\CustomerManagement\\StructType\\ChangeServicePlanTemplateResponse',
            'ChangeServicePlanTemplateOutput' => '\\CustomerManagement\\StructType\\ChangeServicePlanTemplateOutput',
            'UpdatePrimaryEmail' => '\\CustomerManagement\\StructType\\UpdatePrimaryEmail',
            'UpdatePrimaryEmailResponse' => '\\CustomerManagement\\StructType\\UpdatePrimaryEmailResponse',
            'UpdatePrimaryEmailOutput' => '\\CustomerManagement\\StructType\\UpdatePrimaryEmailOutput',
            'ConfirmPrimaryEmail' => '\\CustomerManagement\\StructType\\ConfirmPrimaryEmail',
            'ConfirmPrimaryEmailResponse' => '\\CustomerManagement\\StructType\\ConfirmPrimaryEmailResponse',
            'ConfirmPrimaryEmailOutput' => '\\CustomerManagement\\StructType\\ConfirmPrimaryEmailOutput',
            'UpdatePrimaryPhone' => '\\CustomerManagement\\StructType\\UpdatePrimaryPhone',
            'UpdatePrimaryPhoneResponse' => '\\CustomerManagement\\StructType\\UpdatePrimaryPhoneResponse',
            'UpdatePrimaryPhoneOutput' => '\\CustomerManagement\\StructType\\UpdatePrimaryPhoneOutput',
            'SendEnterpriseNotice' => '\\CustomerManagement\\StructType\\SendEnterpriseNotice',
            'SendEnterpriseNoticeResponse' => '\\CustomerManagement\\StructType\\SendEnterpriseNoticeResponse',
            'SendEnterpriseNoticeOutput' => '\\CustomerManagement\\StructType\\SendEnterpriseNoticeOutput',
            'GetDownloadableSettings' => '\\CustomerManagement\\StructType\\GetDownloadableSettings',
            'GetDownloadableSettingsResponse' => '\\CustomerManagement\\StructType\\GetDownloadableSettingsResponse',
            'GetDownloadableSettingsOutput' => '\\CustomerManagement\\StructType\\GetDownloadableSettingsOutput',
            'ArrayOfPanelSettingInfo' => '\\CustomerManagement\\ArrayType\\ArrayOfPanelSettingInfo',
            'PanelSettingInfo' => '\\CustomerManagement\\StructType\\PanelSettingInfo',
            'ArrayOfPanelSettingSelection' => '\\CustomerManagement\\ArrayType\\ArrayOfPanelSettingSelection',
            'PanelSettingSelection' => '\\CustomerManagement\\StructType\\PanelSettingSelection',
            'DownloadToPanel' => '\\CustomerManagement\\StructType\\DownloadToPanel',
            'ArrayOfPanelSettingInput' => '\\CustomerManagement\\ArrayType\\ArrayOfPanelSettingInput',
            'PanelSettingInput' => '\\CustomerManagement\\StructType\\PanelSettingInput',
            'DownloadToPanelResponse' => '\\CustomerManagement\\StructType\\DownloadToPanelResponse',
            'DownloadToPanelOutput' => '\\CustomerManagement\\StructType\\DownloadToPanelOutput',
            'ArrayOfDownloadValidationError' => '\\CustomerManagement\\ArrayType\\ArrayOfDownloadValidationError',
            'DownloadValidationError' => '\\CustomerManagement\\StructType\\DownloadValidationError',
            'GetUploadedPanelSettings' => '\\CustomerManagement\\StructType\\GetUploadedPanelSettings',
            'GetUploadedPanelSettingsResponse' => '\\CustomerManagement\\StructType\\GetUploadedPanelSettingsResponse',
            'GetUploadedPanelSettingsOutput' => '\\CustomerManagement\\StructType\\GetUploadedPanelSettingsOutput',
            'ArrayOfUploadedPanelSetting' => '\\CustomerManagement\\ArrayType\\ArrayOfUploadedPanelSetting',
            'UploadedPanelSetting' => '\\CustomerManagement\\StructType\\UploadedPanelSetting',
            'RequestUploadOfPanelSettings' => '\\CustomerManagement\\StructType\\RequestUploadOfPanelSettings',
            'RequestUploadOfPanelSettingsResponse' => '\\CustomerManagement\\StructType\\RequestUploadOfPanelSettingsResponse',
            'RequestUploadOfPanelSettingsOutput' => '\\CustomerManagement\\StructType\\RequestUploadOfPanelSettingsOutput',
            'RequestZWaveEquipmentList' => '\\CustomerManagement\\StructType\\RequestZWaveEquipmentList',
            'RequestZWaveEquipmentListResponse' => '\\CustomerManagement\\StructType\\RequestZWaveEquipmentListResponse',
            'RequestZWaveEquipmentListOutput' => '\\CustomerManagement\\StructType\\RequestZWaveEquipmentListOutput',
            'TurnOffAccessCodeLock' => '\\CustomerManagement\\StructType\\TurnOffAccessCodeLock',
            'TurnOffAccessCodeLockResponse' => '\\CustomerManagement\\StructType\\TurnOffAccessCodeLockResponse',
            'TurnOffAccessCodeLockOutput' => '\\CustomerManagement\\StructType\\TurnOffAccessCodeLockOutput',
            'RequestFirmwareUpgradeQolsys' => '\\CustomerManagement\\StructType\\RequestFirmwareUpgradeQolsys',
            'RequestFirmwareUpgradeQolsysResponse' => '\\CustomerManagement\\StructType\\RequestFirmwareUpgradeQolsysResponse',
            'RequestFirmwareUpgradeOutput' => '\\CustomerManagement\\StructType\\RequestFirmwareUpgradeOutput',
            'RequestFirmwareUpgrade' => '\\CustomerManagement\\StructType\\RequestFirmwareUpgrade',
            'RequestFirmwareUpgradeResponse' => '\\CustomerManagement\\StructType\\RequestFirmwareUpgradeResponse',
            'UpdateCameraSettings' => '\\CustomerManagement\\StructType\\UpdateCameraSettings',
            'CameraSettings' => '\\CustomerManagement\\StructType\\CameraSettings',
            'CameraWirelessSettings' => '\\CustomerManagement\\StructType\\CameraWirelessSettings',
            'UpdateCameraSettingsResponse' => '\\CustomerManagement\\StructType\\UpdateCameraSettingsResponse',
            'UpdateCameraSettingsOutput' => '\\CustomerManagement\\StructType\\UpdateCameraSettingsOutput',
            'GetImageSensorInfo' => '\\CustomerManagement\\StructType\\GetImageSensorInfo',
            'GetImageSensorInfoResponse' => '\\CustomerManagement\\StructType\\GetImageSensorInfoResponse',
            'GetImageSensorInfoOutput' => '\\CustomerManagement\\StructType\\GetImageSensorInfoOutput',
            'ImageSensorInfo' => '\\CustomerManagement\\StructType\\ImageSensorInfo',
            'SetImageSensorPartition' => '\\CustomerManagement\\StructType\\SetImageSensorPartition',
            'SetImageSensorPartitionResponse' => '\\CustomerManagement\\StructType\\SetImageSensorPartitionResponse',
            'SetImageSensorPartitionOutput' => '\\CustomerManagement\\StructType\\SetImageSensorPartitionOutput',
            'CreateImageSensorAutoUploadRule' => '\\CustomerManagement\\StructType\\CreateImageSensorAutoUploadRule',
            'ArrayOfImageSensorAutoUploadRule' => '\\CustomerManagement\\ArrayType\\ArrayOfImageSensorAutoUploadRule',
            'ImageSensorAutoUploadRule' => '\\CustomerManagement\\StructType\\ImageSensorAutoUploadRule',
            'ArrayOfDayOfWeek' => '\\CustomerManagement\\ArrayType\\ArrayOfDayOfWeek',
            'ArrayOfLong' => '\\CustomerManagement\\ArrayType\\ArrayOfLong',
            'CreateImageSensorAutoUploadRuleResponse' => '\\CustomerManagement\\StructType\\CreateImageSensorAutoUploadRuleResponse',
            'CreateImageSensorAutoUploadRuleOutput' => '\\CustomerManagement\\StructType\\CreateImageSensorAutoUploadRuleOutput',
            'UpdateNotifications' => '\\CustomerManagement\\StructType\\UpdateNotifications',
            'ArrayOfNotificationSubscription' => '\\CustomerManagement\\ArrayType\\ArrayOfNotificationSubscription',
            'NotificationSubscription' => '\\CustomerManagement\\StructType\\NotificationSubscription',
            'NotificationSubscriptionSchedule' => '\\CustomerManagement\\StructType\\NotificationSubscriptionSchedule',
            'NotificationSubscriptionSLO' => '\\CustomerManagement\\StructType\\NotificationSubscriptionSLO',
            'NotificationSubscriptionArmingEvent' => '\\CustomerManagement\\StructType\\NotificationSubscriptionArmingEvent',
            'ArrayOfEventTypeEnum' => '\\CustomerManagement\\ArrayType\\ArrayOfEventTypeEnum',
            'NotificationSubscriptionArmingReminder' => '\\CustomerManagement\\StructType\\NotificationSubscriptionArmingReminder',
            'UpdateNotificationsResponse' => '\\CustomerManagement\\StructType\\UpdateNotificationsResponse',
            'UpdateNotificationsOutput' => '\\CustomerManagement\\StructType\\UpdateNotificationsOutput',
            'RemoveNotification' => '\\CustomerManagement\\StructType\\RemoveNotification',
            'NotificationRemoval' => '\\CustomerManagement\\StructType\\NotificationRemoval',
            'RemoveNotificationResponse' => '\\CustomerManagement\\StructType\\RemoveNotificationResponse',
            'ArrayOfRemoveNotificationsOutput' => '\\CustomerManagement\\ArrayType\\ArrayOfRemoveNotificationsOutput',
            'RemoveNotificationsOutput' => '\\CustomerManagement\\StructType\\RemoveNotificationsOutput',
            'GetPauseNotificationsForCustomer' => '\\CustomerManagement\\StructType\\GetPauseNotificationsForCustomer',
            'GetPauseNotificationsForCustomerResponse' => '\\CustomerManagement\\StructType\\GetPauseNotificationsForCustomerResponse',
            'GetPauseNotificationsForCustomerOutput' => '\\CustomerManagement\\StructType\\GetPauseNotificationsForCustomerOutput',
            'SetPauseNotificationsForCustomer' => '\\CustomerManagement\\StructType\\SetPauseNotificationsForCustomer',
            'SetPauseNotificationsForCustomerResponse' => '\\CustomerManagement\\StructType\\SetPauseNotificationsForCustomerResponse',
            'SetPauseNotificationsForCustomerOutput' => '\\CustomerManagement\\StructType\\SetPauseNotificationsForCustomerOutput',
        );
    }
}
