<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNetworkEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfNetworkEnum extends AbstractStructArrayBase
{
    /**
     * The NetworkEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NetworkEnum;
    /**
     * Constructor method for ArrayOfNetworkEnum
     * @uses ArrayOfNetworkEnum::setNetworkEnum()
     * @param string[] $networkEnum
     */
    public function __construct(array $networkEnum = array())
    {
        $this
            ->setNetworkEnum($networkEnum);
    }
    /**
     * Get NetworkEnum value
     * @return string[]|null
     */
    public function getNetworkEnum()
    {
        return $this->NetworkEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setNetworkEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetworkEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetworkEnumForArrayConstraintsFromSetNetworkEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNetworkEnumNetworkEnumItem) {
            // validation for constraint: enumeration
            if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($arrayOfNetworkEnumNetworkEnumItem)) {
                $invalidValues[] = is_object($arrayOfNetworkEnumNetworkEnumItem) ? get_class($arrayOfNetworkEnumNetworkEnumItem) : sprintf('%s(%s)', gettype($arrayOfNetworkEnumNetworkEnumItem), var_export($arrayOfNetworkEnumNetworkEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NetworkEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NetworkEnum value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $networkEnum
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function setNetworkEnum(array $networkEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($networkEnumArrayErrorMessage = self::validateNetworkEnumForArrayConstraintsFromSetNetworkEnum($networkEnum))) {
            throw new \InvalidArgumentException($networkEnumArrayErrorMessage, __LINE__);
        }
        $this->NetworkEnum = $networkEnum;
        return $this;
    }
    /**
     * Add item to NetworkEnum value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function addToNetworkEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NetworkEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->NetworkEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NetworkEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NetworkEnum
     */
    public function getAttributeName()
    {
        return 'NetworkEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
