<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListFor2G StructType
 * @subpackage Structs
 */
class GetCustomerListFor2G extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The postalCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $postalCodes;
    /**
     * The networks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public $networks;
    /**
     * Constructor method for GetCustomerListFor2G
     * @uses GetCustomerListFor2G::setCountry()
     * @uses GetCustomerListFor2G::setPostalCodes()
     * @uses GetCustomerListFor2G::setNetworks()
     * @param string $country
     * @param \CustomerManagement\ArrayType\ArrayOfString $postalCodes
     * @param \CustomerManagement\ArrayType\ArrayOfNetworkEnum $networks
     */
    public function __construct($country = null, \CustomerManagement\ArrayType\ArrayOfString $postalCodes = null, \CustomerManagement\ArrayType\ArrayOfNetworkEnum $networks = null)
    {
        $this
            ->setCountry($country)
            ->setPostalCodes($postalCodes)
            ->setNetworks($networks);
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \CustomerManagement\EnumType\CountryEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CountryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \CustomerManagement\StructType\GetCustomerListFor2G
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CountryEnum::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CountryEnum', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \CustomerManagement\EnumType\CountryEnum::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get postalCodes value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getPostalCodes()
    {
        return $this->postalCodes;
    }
    /**
     * Set postalCodes value
     * @param \CustomerManagement\ArrayType\ArrayOfString $postalCodes
     * @return \CustomerManagement\StructType\GetCustomerListFor2G
     */
    public function setPostalCodes(\CustomerManagement\ArrayType\ArrayOfString $postalCodes = null)
    {
        $this->postalCodes = $postalCodes;
        return $this;
    }
    /**
     * Get networks value
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum|null
     */
    public function getNetworks()
    {
        return $this->networks;
    }
    /**
     * Set networks value
     * @param \CustomerManagement\ArrayType\ArrayOfNetworkEnum $networks
     * @return \CustomerManagement\StructType\GetCustomerListFor2G
     */
    public function setNetworks(\CustomerManagement\ArrayType\ArrayOfNetworkEnum $networks = null)
    {
        $this->networks = $networks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerListFor2G
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
