<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListOutput StructType
 * @subpackage Structs
 */
class GetCustomerListOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The CustomerIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $CustomerIds;
    /**
     * Constructor method for GetCustomerListOutput
     * @uses GetCustomerListOutput::setSuccess()
     * @uses GetCustomerListOutput::setErrorMessage()
     * @uses GetCustomerListOutput::setCustomerIds()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerIds
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfInt $customerIds = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setCustomerIds($customerIds);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetCustomerListOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetCustomerListOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get CustomerIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getCustomerIds()
    {
        return $this->CustomerIds;
    }
    /**
     * Set CustomerIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerIds
     * @return \CustomerManagement\StructType\GetCustomerListOutput
     */
    public function setCustomerIds(\CustomerManagement\ArrayType\ArrayOfInt $customerIds = null)
    {
        $this->CustomerIds = $customerIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerListOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
