<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentDeviceNote StructType
 * @subpackage Structs
 */
class EquipmentDeviceNote extends AbstractStructBase
{
    /**
     * The CreateDateTimeUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateTimeUTC;
    /**
     * The ModifiedDateTimeUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModifiedDateTimeUTC;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceID;
    /**
     * The ConditionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConditionID;
    /**
     * The TextDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TextDescription;
    /**
     * The LastModifiedByRep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedByRep;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceNoteImage
     */
    public $Images;
    /**
     * Constructor method for EquipmentDeviceNote
     * @uses EquipmentDeviceNote::setCreateDateTimeUTC()
     * @uses EquipmentDeviceNote::setModifiedDateTimeUTC()
     * @uses EquipmentDeviceNote::setDeviceID()
     * @uses EquipmentDeviceNote::setConditionID()
     * @uses EquipmentDeviceNote::setTextDescription()
     * @uses EquipmentDeviceNote::setLastModifiedByRep()
     * @uses EquipmentDeviceNote::setImages()
     * @param string $createDateTimeUTC
     * @param string $modifiedDateTimeUTC
     * @param int $deviceID
     * @param int $conditionID
     * @param string $textDescription
     * @param string $lastModifiedByRep
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceNoteImage $images
     */
    public function __construct($createDateTimeUTC = null, $modifiedDateTimeUTC = null, $deviceID = null, $conditionID = null, $textDescription = null, $lastModifiedByRep = null, \CustomerManagement\ArrayType\ArrayOfDeviceNoteImage $images = null)
    {
        $this
            ->setCreateDateTimeUTC($createDateTimeUTC)
            ->setModifiedDateTimeUTC($modifiedDateTimeUTC)
            ->setDeviceID($deviceID)
            ->setConditionID($conditionID)
            ->setTextDescription($textDescription)
            ->setLastModifiedByRep($lastModifiedByRep)
            ->setImages($images);
    }
    /**
     * Get CreateDateTimeUTC value
     * @return string
     */
    public function getCreateDateTimeUTC()
    {
        return $this->CreateDateTimeUTC;
    }
    /**
     * Set CreateDateTimeUTC value
     * @param string $createDateTimeUTC
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setCreateDateTimeUTC($createDateTimeUTC = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTimeUTC) && !is_string($createDateTimeUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTimeUTC, true), gettype($createDateTimeUTC)), __LINE__);
        }
        $this->CreateDateTimeUTC = $createDateTimeUTC;
        return $this;
    }
    /**
     * Get ModifiedDateTimeUTC value
     * @return string
     */
    public function getModifiedDateTimeUTC()
    {
        return $this->ModifiedDateTimeUTC;
    }
    /**
     * Set ModifiedDateTimeUTC value
     * @param string $modifiedDateTimeUTC
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setModifiedDateTimeUTC($modifiedDateTimeUTC = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDateTimeUTC) && !is_string($modifiedDateTimeUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDateTimeUTC, true), gettype($modifiedDateTimeUTC)), __LINE__);
        }
        $this->ModifiedDateTimeUTC = $modifiedDateTimeUTC;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get ConditionID value
     * @return int
     */
    public function getConditionID()
    {
        return $this->ConditionID;
    }
    /**
     * Set ConditionID value
     * @param int $conditionID
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setConditionID($conditionID = null)
    {
        // validation for constraint: int
        if (!is_null($conditionID) && !(is_int($conditionID) || ctype_digit($conditionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($conditionID, true), gettype($conditionID)), __LINE__);
        }
        $this->ConditionID = $conditionID;
        return $this;
    }
    /**
     * Get TextDescription value
     * @return string|null
     */
    public function getTextDescription()
    {
        return $this->TextDescription;
    }
    /**
     * Set TextDescription value
     * @param string $textDescription
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setTextDescription($textDescription = null)
    {
        // validation for constraint: string
        if (!is_null($textDescription) && !is_string($textDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textDescription, true), gettype($textDescription)), __LINE__);
        }
        $this->TextDescription = $textDescription;
        return $this;
    }
    /**
     * Get LastModifiedByRep value
     * @return string|null
     */
    public function getLastModifiedByRep()
    {
        return $this->LastModifiedByRep;
    }
    /**
     * Set LastModifiedByRep value
     * @param string $lastModifiedByRep
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setLastModifiedByRep($lastModifiedByRep = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedByRep) && !is_string($lastModifiedByRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedByRep, true), gettype($lastModifiedByRep)), __LINE__);
        }
        $this->LastModifiedByRep = $lastModifiedByRep;
        return $this;
    }
    /**
     * Get Images value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceNoteImage|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceNoteImage $images
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public function setImages(\CustomerManagement\ArrayType\ArrayOfDeviceNoteImage $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\EquipmentDeviceNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
