<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CustomerTypeEnum EnumType
 * @subpackage Enumerations
 */
class CustomerTypeEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'NormalDemo'
     * @return string 'NormalDemo'
     */
    const VALUE_NORMAL_DEMO = 'NormalDemo';
    /**
     * Constant for value 'VirtualDemo'
     * @return string 'VirtualDemo'
     */
    const VALUE_VIRTUAL_DEMO = 'VirtualDemo';
    /**
     * Constant for value 'Commitment'
     * @return string 'Commitment'
     */
    const VALUE_COMMITMENT = 'Commitment';
    /**
     * Constant for value 'FromRecycle'
     * @return string 'FromRecycle'
     */
    const VALUE_FROM_RECYCLE = 'FromRecycle';
    /**
     * Constant for value 'Interim'
     * @return string 'Interim'
     */
    const VALUE_INTERIM = 'Interim';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_NORMAL_DEMO
     * @uses self::VALUE_VIRTUAL_DEMO
     * @uses self::VALUE_COMMITMENT
     * @uses self::VALUE_FROM_RECYCLE
     * @uses self::VALUE_INTERIM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_CUSTOMER,
            self::VALUE_NORMAL_DEMO,
            self::VALUE_VIRTUAL_DEMO,
            self::VALUE_COMMITMENT,
            self::VALUE_FROM_RECYCLE,
            self::VALUE_INTERIM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
