<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLoginPassword StructType
 * @subpackage Structs
 */
class UpdateLoginPassword extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The loginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginName;
    /**
     * The oldPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $oldPassword;
    /**
     * The newPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newPassword;
    /**
     * Constructor method for UpdateLoginPassword
     * @uses UpdateLoginPassword::setCustomerId()
     * @uses UpdateLoginPassword::setLoginName()
     * @uses UpdateLoginPassword::setOldPassword()
     * @uses UpdateLoginPassword::setNewPassword()
     * @param int $customerId
     * @param string $loginName
     * @param string $oldPassword
     * @param string $newPassword
     */
    public function __construct($customerId = null, $loginName = null, $oldPassword = null, $newPassword = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginName($loginName)
            ->setOldPassword($oldPassword)
            ->setNewPassword($newPassword);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateLoginPassword
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get loginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->loginName;
    }
    /**
     * Set loginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\UpdateLoginPassword
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->loginName = $loginName;
        return $this;
    }
    /**
     * Get oldPassword value
     * @return string|null
     */
    public function getOldPassword()
    {
        return $this->oldPassword;
    }
    /**
     * Set oldPassword value
     * @param string $oldPassword
     * @return \CustomerManagement\StructType\UpdateLoginPassword
     */
    public function setOldPassword($oldPassword = null)
    {
        // validation for constraint: string
        if (!is_null($oldPassword) && !is_string($oldPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldPassword, true), gettype($oldPassword)), __LINE__);
        }
        $this->oldPassword = $oldPassword;
        return $this;
    }
    /**
     * Get newPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }
    /**
     * Set newPassword value
     * @param string $newPassword
     * @return \CustomerManagement\StructType\UpdateLoginPassword
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        $this->newPassword = $newPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateLoginPassword
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
