<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceStatusEnum EnumType
 * @subpackage Enumerations
 */
class DeviceStatusEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Removed'
     * @return string 'Removed'
     */
    const VALUE_REMOVED = 'Removed';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'Disarmed'
     * @return string 'Disarmed'
     */
    const VALUE_DISARMED = 'Disarmed';
    /**
     * Constant for value 'ArmedStay'
     * @return string 'ArmedStay'
     */
    const VALUE_ARMED_STAY = 'ArmedStay';
    /**
     * Constant for value 'ArmedAway'
     * @return string 'ArmedAway'
     */
    const VALUE_ARMED_AWAY = 'ArmedAway';
    /**
     * Constant for value 'ThermostatOk'
     * @return string 'ThermostatOk'
     */
    const VALUE_THERMOSTAT_OK = 'ThermostatOk';
    /**
     * Constant for value 'ThermostatTooCold'
     * @return string 'ThermostatTooCold'
     */
    const VALUE_THERMOSTAT_TOO_COLD = 'ThermostatTooCold';
    /**
     * Constant for value 'ThermostatTooWarm'
     * @return string 'ThermostatTooWarm'
     */
    const VALUE_THERMOSTAT_TOO_WARM = 'ThermostatTooWarm';
    /**
     * Constant for value 'SensorAlarm'
     * @return string 'SensorAlarm'
     */
    const VALUE_SENSOR_ALARM = 'SensorAlarm';
    /**
     * Constant for value 'LowBattery'
     * @return string 'LowBattery'
     */
    const VALUE_LOW_BATTERY = 'LowBattery';
    /**
     * Constant for value 'AcFailure'
     * @return string 'AcFailure'
     */
    const VALUE_AC_FAILURE = 'AcFailure';
    /**
     * Constant for value 'Malfunction'
     * @return string 'Malfunction'
     */
    const VALUE_MALFUNCTION = 'Malfunction';
    /**
     * Constant for value 'Bypassed'
     * @return string 'Bypassed'
     */
    const VALUE_BYPASSED = 'Bypassed';
    /**
     * Constant for value 'Duress'
     * @return string 'Duress'
     */
    const VALUE_DURESS = 'Duress';
    /**
     * Constant for value 'PhoneLineCut'
     * @return string 'PhoneLineCut'
     */
    const VALUE_PHONE_LINE_CUT = 'PhoneLineCut';
    /**
     * Constant for value 'FirePanic'
     * @return string 'FirePanic'
     */
    const VALUE_FIRE_PANIC = 'FirePanic';
    /**
     * Constant for value 'AuxPanic'
     * @return string 'AuxPanic'
     */
    const VALUE_AUX_PANIC = 'AuxPanic';
    /**
     * Constant for value 'SystemInAlarm'
     * @return string 'SystemInAlarm'
     */
    const VALUE_SYSTEM_IN_ALARM = 'SystemInAlarm';
    /**
     * Constant for value 'RadioOff'
     * @return string 'RadioOff'
     */
    const VALUE_RADIO_OFF = 'RadioOff';
    /**
     * Constant for value 'PanelFreezeAlarm'
     * @return string 'PanelFreezeAlarm'
     */
    const VALUE_PANEL_FREEZE_ALARM = 'PanelFreezeAlarm';
    /**
     * Constant for value 'KeypadTamper'
     * @return string 'KeypadTamper'
     */
    const VALUE_KEYPAD_TAMPER = 'KeypadTamper';
    /**
     * Constant for value 'ModuleMalfunction'
     * @return string 'ModuleMalfunction'
     */
    const VALUE_MODULE_MALFUNCTION = 'ModuleMalfunction';
    /**
     * Constant for value 'PanelCommunicationError'
     * @return string 'PanelCommunicationError'
     */
    const VALUE_PANEL_COMMUNICATION_ERROR = 'PanelCommunicationError';
    /**
     * Constant for value 'NoActivityAlarmPanel'
     * @return string 'NoActivityAlarmPanel'
     */
    const VALUE_NO_ACTIVITY_ALARM_PANEL = 'NoActivityAlarmPanel';
    /**
     * Constant for value 'NoActivityAlarmSchedule'
     * @return string 'NoActivityAlarmSchedule'
     */
    const VALUE_NO_ACTIVITY_ALARM_SCHEDULE = 'NoActivityAlarmSchedule';
    /**
     * Constant for value 'Tamper'
     * @return string 'Tamper'
     */
    const VALUE_TAMPER = 'Tamper';
    /**
     * Constant for value 'ImageSensorEnrollmentConflict'
     * @return string 'ImageSensorEnrollmentConflict'
     */
    const VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT = 'ImageSensorEnrollmentConflict';
    /**
     * Constant for value 'ArmedNight'
     * @return string 'ArmedNight'
     */
    const VALUE_ARMED_NIGHT = 'ArmedNight';
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'CriticalBattery'
     * @return string 'CriticalBattery'
     */
    const VALUE_CRITICAL_BATTERY = 'CriticalBattery';
    /**
     * Constant for value 'AccessControlOk'
     * @return string 'AccessControlOk'
     */
    const VALUE_ACCESS_CONTROL_OK = 'AccessControlOk';
    /**
     * Constant for value 'LeakDetected'
     * @return string 'LeakDetected'
     */
    const VALUE_LEAK_DETECTED = 'LeakDetected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_REMOVED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_DISARMED
     * @uses self::VALUE_ARMED_STAY
     * @uses self::VALUE_ARMED_AWAY
     * @uses self::VALUE_THERMOSTAT_OK
     * @uses self::VALUE_THERMOSTAT_TOO_COLD
     * @uses self::VALUE_THERMOSTAT_TOO_WARM
     * @uses self::VALUE_SENSOR_ALARM
     * @uses self::VALUE_LOW_BATTERY
     * @uses self::VALUE_AC_FAILURE
     * @uses self::VALUE_MALFUNCTION
     * @uses self::VALUE_BYPASSED
     * @uses self::VALUE_DURESS
     * @uses self::VALUE_PHONE_LINE_CUT
     * @uses self::VALUE_FIRE_PANIC
     * @uses self::VALUE_AUX_PANIC
     * @uses self::VALUE_SYSTEM_IN_ALARM
     * @uses self::VALUE_RADIO_OFF
     * @uses self::VALUE_PANEL_FREEZE_ALARM
     * @uses self::VALUE_KEYPAD_TAMPER
     * @uses self::VALUE_MODULE_MALFUNCTION
     * @uses self::VALUE_PANEL_COMMUNICATION_ERROR
     * @uses self::VALUE_NO_ACTIVITY_ALARM_PANEL
     * @uses self::VALUE_NO_ACTIVITY_ALARM_SCHEDULE
     * @uses self::VALUE_TAMPER
     * @uses self::VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT
     * @uses self::VALUE_ARMED_NIGHT
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_CRITICAL_BATTERY
     * @uses self::VALUE_ACCESS_CONTROL_OK
     * @uses self::VALUE_LEAK_DETECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_REMOVED,
            self::VALUE_CLOSED,
            self::VALUE_OPEN,
            self::VALUE_DISARMED,
            self::VALUE_ARMED_STAY,
            self::VALUE_ARMED_AWAY,
            self::VALUE_THERMOSTAT_OK,
            self::VALUE_THERMOSTAT_TOO_COLD,
            self::VALUE_THERMOSTAT_TOO_WARM,
            self::VALUE_SENSOR_ALARM,
            self::VALUE_LOW_BATTERY,
            self::VALUE_AC_FAILURE,
            self::VALUE_MALFUNCTION,
            self::VALUE_BYPASSED,
            self::VALUE_DURESS,
            self::VALUE_PHONE_LINE_CUT,
            self::VALUE_FIRE_PANIC,
            self::VALUE_AUX_PANIC,
            self::VALUE_SYSTEM_IN_ALARM,
            self::VALUE_RADIO_OFF,
            self::VALUE_PANEL_FREEZE_ALARM,
            self::VALUE_KEYPAD_TAMPER,
            self::VALUE_MODULE_MALFUNCTION,
            self::VALUE_PANEL_COMMUNICATION_ERROR,
            self::VALUE_NO_ACTIVITY_ALARM_PANEL,
            self::VALUE_NO_ACTIVITY_ALARM_SCHEDULE,
            self::VALUE_TAMPER,
            self::VALUE_IMAGE_SENSOR_ENROLLMENT_CONFLICT,
            self::VALUE_ARMED_NIGHT,
            self::VALUE_DISABLED,
            self::VALUE_CRITICAL_BATTERY,
            self::VALUE_ACCESS_CONTROL_OK,
            self::VALUE_LEAK_DETECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
