<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSensorType ArrayType
 * @subpackage Arrays
 */
class ArrayOfSensorType extends AbstractStructArrayBase
{
    /**
     * The SensorType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\SensorType[]
     */
    public $SensorType;
    /**
     * Constructor method for ArrayOfSensorType
     * @uses ArrayOfSensorType::setSensorType()
     * @param \CustomerManagement\StructType\SensorType[] $sensorType
     */
    public function __construct(array $sensorType = array())
    {
        $this
            ->setSensorType($sensorType);
    }
    /**
     * Get SensorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\SensorType[]|null
     */
    public function getSensorType()
    {
        return isset($this->SensorType) ? $this->SensorType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSensorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSensorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSensorTypeForArrayConstraintsFromSetSensorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSensorTypeSensorTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSensorTypeSensorTypeItem instanceof \CustomerManagement\StructType\SensorType) {
                $invalidValues[] = is_object($arrayOfSensorTypeSensorTypeItem) ? get_class($arrayOfSensorTypeSensorTypeItem) : sprintf('%s(%s)', gettype($arrayOfSensorTypeSensorTypeItem), var_export($arrayOfSensorTypeSensorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SensorType property can only contain items of type \CustomerManagement\StructType\SensorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SensorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SensorType[] $sensorType
     * @return \CustomerManagement\ArrayType\ArrayOfSensorType
     */
    public function setSensorType(array $sensorType = array())
    {
        // validation for constraint: array
        if ('' !== ($sensorTypeArrayErrorMessage = self::validateSensorTypeForArrayConstraintsFromSetSensorType($sensorType))) {
            throw new \InvalidArgumentException($sensorTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($sensorType) || (is_array($sensorType) && empty($sensorType))) {
            unset($this->SensorType);
        } else {
            $this->SensorType = $sensorType;
        }
        return $this;
    }
    /**
     * Add item to SensorType value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SensorType $item
     * @return \CustomerManagement\ArrayType\ArrayOfSensorType
     */
    public function addToSensorType(\CustomerManagement\StructType\SensorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\SensorType) {
            throw new \InvalidArgumentException(sprintf('The SensorType property can only contain items of type \CustomerManagement\StructType\SensorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SensorType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\SensorType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\SensorType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\SensorType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\SensorType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\SensorType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SensorType
     */
    public function getAttributeName()
    {
        return 'SensorType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfSensorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
