<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCentralStationInfoInput StructType
 * @subpackage Structs
 */
class UpdateCentralStationInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ForwardingOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForwardingOption;
    /**
     * The PhoneLinePresent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PhoneLinePresent;
    /**
     * The InitiateTwoWayVoiceForFireAndCoAlarms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InitiateTwoWayVoiceForFireAndCoAlarms;
    /**
     * The EventGroupsToForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $EventGroupsToForward;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ReceiverNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverNumber;
    /**
     * Constructor method for UpdateCentralStationInfoInput
     * @uses UpdateCentralStationInfoInput::setCustomerId()
     * @uses UpdateCentralStationInfoInput::setForwardingOption()
     * @uses UpdateCentralStationInfoInput::setPhoneLinePresent()
     * @uses UpdateCentralStationInfoInput::setInitiateTwoWayVoiceForFireAndCoAlarms()
     * @uses UpdateCentralStationInfoInput::setEventGroupsToForward()
     * @uses UpdateCentralStationInfoInput::setAccountNumber()
     * @uses UpdateCentralStationInfoInput::setReceiverNumber()
     * @param int $customerId
     * @param string $forwardingOption
     * @param bool $phoneLinePresent
     * @param bool $initiateTwoWayVoiceForFireAndCoAlarms
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @param string $accountNumber
     * @param string $receiverNumber
     */
    public function __construct($customerId = null, $forwardingOption = null, $phoneLinePresent = null, $initiateTwoWayVoiceForFireAndCoAlarms = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null, $accountNumber = null, $receiverNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setForwardingOption($forwardingOption)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setInitiateTwoWayVoiceForFireAndCoAlarms($initiateTwoWayVoiceForFireAndCoAlarms)
            ->setEventGroupsToForward($eventGroupsToForward)
            ->setAccountNumber($accountNumber)
            ->setReceiverNumber($receiverNumber);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ForwardingOption value
     * @return string
     */
    public function getForwardingOption()
    {
        return $this->ForwardingOption;
    }
    /**
     * Set ForwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forwardingOption
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setForwardingOption($forwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($forwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CentralStationForwardingOptionEnum', is_array($forwardingOption) ? implode(', ', $forwardingOption) : var_export($forwardingOption, true), implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->ForwardingOption = $forwardingOption;
        return $this;
    }
    /**
     * Get PhoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->PhoneLinePresent;
    }
    /**
     * Set PhoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneLinePresent) && !is_bool($phoneLinePresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneLinePresent, true), gettype($phoneLinePresent)), __LINE__);
        }
        $this->PhoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get InitiateTwoWayVoiceForFireAndCoAlarms value
     * @return bool
     */
    public function getInitiateTwoWayVoiceForFireAndCoAlarms()
    {
        return $this->InitiateTwoWayVoiceForFireAndCoAlarms;
    }
    /**
     * Set InitiateTwoWayVoiceForFireAndCoAlarms value
     * @param bool $initiateTwoWayVoiceForFireAndCoAlarms
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setInitiateTwoWayVoiceForFireAndCoAlarms($initiateTwoWayVoiceForFireAndCoAlarms = null)
    {
        // validation for constraint: boolean
        if (!is_null($initiateTwoWayVoiceForFireAndCoAlarms) && !is_bool($initiateTwoWayVoiceForFireAndCoAlarms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($initiateTwoWayVoiceForFireAndCoAlarms, true), gettype($initiateTwoWayVoiceForFireAndCoAlarms)), __LINE__);
        }
        $this->InitiateTwoWayVoiceForFireAndCoAlarms = $initiateTwoWayVoiceForFireAndCoAlarms;
        return $this;
    }
    /**
     * Get EventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getEventGroupsToForward()
    {
        return $this->EventGroupsToForward;
    }
    /**
     * Set EventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this->EventGroupsToForward = $eventGroupsToForward;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ReceiverNumber value
     * @return string|null
     */
    public function getReceiverNumber()
    {
        return $this->ReceiverNumber;
    }
    /**
     * Set ReceiverNumber value
     * @param string $receiverNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setReceiverNumber($receiverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverNumber) && !is_string($receiverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverNumber, true), gettype($receiverNumber)), __LINE__);
        }
        $this->ReceiverNumber = $receiverNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
