<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModemInfo StructType
 * @subpackage Structs
 */
class ModemInfo extends AbstractStructBase
{
    /**
     * The FirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FirmwareVersion;
    /**
     * The Network
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Network;
    /**
     * The TwoWayVoiceCapable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TwoWayVoiceCapable;
    /**
     * The RadioNetworkType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RadioNetworkType;
    /**
     * The ExtendedFirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExtendedFirmwareVersion;
    /**
     * The PanelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelType;
    /**
     * The ModemSerial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerial;
    /**
     * The ModemPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemPhoneNumber;
    /**
     * The IMEI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IMEI;
    /**
     * Constructor method for ModemInfo
     * @uses ModemInfo::setFirmwareVersion()
     * @uses ModemInfo::setNetwork()
     * @uses ModemInfo::setTwoWayVoiceCapable()
     * @uses ModemInfo::setRadioNetworkType()
     * @uses ModemInfo::setExtendedFirmwareVersion()
     * @uses ModemInfo::setPanelType()
     * @uses ModemInfo::setModemSerial()
     * @uses ModemInfo::setModemPhoneNumber()
     * @uses ModemInfo::setIMEI()
     * @param int $firmwareVersion
     * @param string $network
     * @param bool $twoWayVoiceCapable
     * @param string $radioNetworkType
     * @param int $extendedFirmwareVersion
     * @param string $panelType
     * @param string $modemSerial
     * @param string $modemPhoneNumber
     * @param string $iMEI
     */
    public function __construct($firmwareVersion = null, $network = null, $twoWayVoiceCapable = null, $radioNetworkType = null, $extendedFirmwareVersion = null, $panelType = null, $modemSerial = null, $modemPhoneNumber = null, $iMEI = null)
    {
        $this
            ->setFirmwareVersion($firmwareVersion)
            ->setNetwork($network)
            ->setTwoWayVoiceCapable($twoWayVoiceCapable)
            ->setRadioNetworkType($radioNetworkType)
            ->setExtendedFirmwareVersion($extendedFirmwareVersion)
            ->setPanelType($panelType)
            ->setModemSerial($modemSerial)
            ->setModemPhoneNumber($modemPhoneNumber)
            ->setIMEI($iMEI);
    }
    /**
     * Get FirmwareVersion value
     * @return int
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param int $firmwareVersion
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: int
        if (!is_null($firmwareVersion) && !(is_int($firmwareVersion) || ctype_digit($firmwareVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get Network value
     * @return string
     */
    public function getNetwork()
    {
        return $this->Network;
    }
    /**
     * Set Network value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $network
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($network)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NetworkEnum', is_array($network) ? implode(', ', $network) : var_export($network, true), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->Network = $network;
        return $this;
    }
    /**
     * Get TwoWayVoiceCapable value
     * @return bool
     */
    public function getTwoWayVoiceCapable()
    {
        return $this->TwoWayVoiceCapable;
    }
    /**
     * Set TwoWayVoiceCapable value
     * @param bool $twoWayVoiceCapable
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setTwoWayVoiceCapable($twoWayVoiceCapable = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoWayVoiceCapable) && !is_bool($twoWayVoiceCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twoWayVoiceCapable, true), gettype($twoWayVoiceCapable)), __LINE__);
        }
        $this->TwoWayVoiceCapable = $twoWayVoiceCapable;
        return $this;
    }
    /**
     * Get RadioNetworkType value
     * @return string
     */
    public function getRadioNetworkType()
    {
        return $this->RadioNetworkType;
    }
    /**
     * Set RadioNetworkType value
     * @uses \CustomerManagement\EnumType\RadioNetworkTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RadioNetworkTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $radioNetworkType
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setRadioNetworkType($radioNetworkType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RadioNetworkTypeEnum::valueIsValid($radioNetworkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RadioNetworkTypeEnum', is_array($radioNetworkType) ? implode(', ', $radioNetworkType) : var_export($radioNetworkType, true), implode(', ', \CustomerManagement\EnumType\RadioNetworkTypeEnum::getValidValues())), __LINE__);
        }
        $this->RadioNetworkType = $radioNetworkType;
        return $this;
    }
    /**
     * Get ExtendedFirmwareVersion value
     * @return int
     */
    public function getExtendedFirmwareVersion()
    {
        return $this->ExtendedFirmwareVersion;
    }
    /**
     * Set ExtendedFirmwareVersion value
     * @param int $extendedFirmwareVersion
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setExtendedFirmwareVersion($extendedFirmwareVersion = null)
    {
        // validation for constraint: int
        if (!is_null($extendedFirmwareVersion) && !(is_int($extendedFirmwareVersion) || ctype_digit($extendedFirmwareVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extendedFirmwareVersion, true), gettype($extendedFirmwareVersion)), __LINE__);
        }
        $this->ExtendedFirmwareVersion = $extendedFirmwareVersion;
        return $this;
    }
    /**
     * Get PanelType value
     * @return string
     */
    public function getPanelType()
    {
        return $this->PanelType;
    }
    /**
     * Set PanelType value
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelType
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setPanelType($panelType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelTypeEnum::valueIsValid($panelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelTypeEnum', is_array($panelType) ? implode(', ', $panelType) : var_export($panelType, true), implode(', ', \CustomerManagement\EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->PanelType = $panelType;
        return $this;
    }
    /**
     * Get ModemSerial value
     * @return string|null
     */
    public function getModemSerial()
    {
        return $this->ModemSerial;
    }
    /**
     * Set ModemSerial value
     * @param string $modemSerial
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setModemSerial($modemSerial = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerial) && !is_string($modemSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemSerial, true), gettype($modemSerial)), __LINE__);
        }
        $this->ModemSerial = $modemSerial;
        return $this;
    }
    /**
     * Get ModemPhoneNumber value
     * @return string|null
     */
    public function getModemPhoneNumber()
    {
        return $this->ModemPhoneNumber;
    }
    /**
     * Set ModemPhoneNumber value
     * @param string $modemPhoneNumber
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setModemPhoneNumber($modemPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modemPhoneNumber) && !is_string($modemPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemPhoneNumber, true), gettype($modemPhoneNumber)), __LINE__);
        }
        $this->ModemPhoneNumber = $modemPhoneNumber;
        return $this;
    }
    /**
     * Get IMEI value
     * @return string|null
     */
    public function getIMEI()
    {
        return $this->IMEI;
    }
    /**
     * Set IMEI value
     * @param string $iMEI
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setIMEI($iMEI = null)
    {
        // validation for constraint: string
        if (!is_null($iMEI) && !is_string($iMEI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iMEI, true), gettype($iMEI)), __LINE__);
        }
        $this->IMEI = $iMEI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
