<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerInput StructType
 * @subpackage Structs
 */
class CreateCustomerInput extends AbstractStructBase
{
    /**
     * The InstallationTimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallationTimeZone;
    /**
     * The Culture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Culture;
    /**
     * The PanelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelType;
    /**
     * The PanelVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelVersion;
    /**
     * The panelSettingTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $panelSettingTemplateId;
    /**
     * The PhoneLinePresent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PhoneLinePresent;
    /**
     * The CentralStationForwardingOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CentralStationForwardingOption;
    /**
     * The PackageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageId;
    /**
     * The IgnoreLowCoverageErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreLowCoverageErrors;
    /**
     * The BranchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The LeadId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LeadId;
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PropertyType;
    /**
     * The ContractEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ContractEndDate;
    /**
     * The EnrolledInMaintenance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EnrolledInMaintenance;
    /**
     * The PackageTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageTemplateId;
    /**
     * The HasInsuranceFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasInsuranceFeatures;
    /**
     * The CommunicationPathway
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CommunicationPathway;
    /**
     * The InstallWizard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InstallWizard;
    /**
     * The InstallType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InstallType;
    /**
     * The DealerCustomerSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerCustomerSourceId;
    /**
     * The BuilderProgramId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BuilderProgramId;
    /**
     * The CustomerAccountAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\AddressWithName
     */
    public $CustomerAccountAddress;
    /**
     * The CustomerAccountEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAccountEmail;
    /**
     * The CustomerAccountPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAccountPhone;
    /**
     * The DealerCustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerCustomerId;
    /**
     * The DesiredLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesiredLoginName;
    /**
     * The DesiredPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesiredPassword;
    /**
     * The InstallationAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallationAddress;
    /**
     * The ModemSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerialNumber;
    /**
     * The UnitDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitDescription;
    /**
     * The InstallerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstallerCode;
    /**
     * The CsEventGroupsToForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $CsEventGroupsToForward;
    /**
     * The CentralStationAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CentralStationAccountNumber;
    /**
     * The CentralStationReceiverNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CentralStationReceiverNumber;
    /**
     * The AddOnFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $AddOnFeatures;
    /**
     * The CustomerNotifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public $CustomerNotifications;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * The SalesRepLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesRepLoginName;
    /**
     * The InstallerLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstallerLoginName;
    /**
     * The ContractLengthInMonths
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ContractLengthInMonths;
    /**
     * The DealerCustomerSourceOther
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerCustomerSourceOther;
    /**
     * Constructor method for CreateCustomerInput
     * @uses CreateCustomerInput::setInstallationTimeZone()
     * @uses CreateCustomerInput::setCulture()
     * @uses CreateCustomerInput::setPanelType()
     * @uses CreateCustomerInput::setPanelVersion()
     * @uses CreateCustomerInput::setPanelSettingTemplateId()
     * @uses CreateCustomerInput::setPhoneLinePresent()
     * @uses CreateCustomerInput::setCentralStationForwardingOption()
     * @uses CreateCustomerInput::setPackageId()
     * @uses CreateCustomerInput::setIgnoreLowCoverageErrors()
     * @uses CreateCustomerInput::setBranchId()
     * @uses CreateCustomerInput::setLeadId()
     * @uses CreateCustomerInput::setPropertyType()
     * @uses CreateCustomerInput::setContractEndDate()
     * @uses CreateCustomerInput::setEnrolledInMaintenance()
     * @uses CreateCustomerInput::setPackageTemplateId()
     * @uses CreateCustomerInput::setHasInsuranceFeatures()
     * @uses CreateCustomerInput::setCommunicationPathway()
     * @uses CreateCustomerInput::setInstallWizard()
     * @uses CreateCustomerInput::setInstallType()
     * @uses CreateCustomerInput::setDealerCustomerSourceId()
     * @uses CreateCustomerInput::setBuilderProgramId()
     * @uses CreateCustomerInput::setCustomerAccountAddress()
     * @uses CreateCustomerInput::setCustomerAccountEmail()
     * @uses CreateCustomerInput::setCustomerAccountPhone()
     * @uses CreateCustomerInput::setDealerCustomerId()
     * @uses CreateCustomerInput::setDesiredLoginName()
     * @uses CreateCustomerInput::setDesiredPassword()
     * @uses CreateCustomerInput::setInstallationAddress()
     * @uses CreateCustomerInput::setModemSerialNumber()
     * @uses CreateCustomerInput::setUnitDescription()
     * @uses CreateCustomerInput::setInstallerCode()
     * @uses CreateCustomerInput::setCsEventGroupsToForward()
     * @uses CreateCustomerInput::setCentralStationAccountNumber()
     * @uses CreateCustomerInput::setCentralStationReceiverNumber()
     * @uses CreateCustomerInput::setAddOnFeatures()
     * @uses CreateCustomerInput::setCustomerNotifications()
     * @uses CreateCustomerInput::setLoginNameAtAuthenticationProvider()
     * @uses CreateCustomerInput::setSalesRepLoginName()
     * @uses CreateCustomerInput::setInstallerLoginName()
     * @uses CreateCustomerInput::setContractLengthInMonths()
     * @uses CreateCustomerInput::setDealerCustomerSourceOther()
     * @param string $installationTimeZone
     * @param string $culture
     * @param string $panelType
     * @param string $panelVersion
     * @param int $panelSettingTemplateId
     * @param bool $phoneLinePresent
     * @param string $centralStationForwardingOption
     * @param int $packageId
     * @param bool $ignoreLowCoverageErrors
     * @param int $branchId
     * @param int $leadId
     * @param string $propertyType
     * @param string $contractEndDate
     * @param bool $enrolledInMaintenance
     * @param int $packageTemplateId
     * @param bool $hasInsuranceFeatures
     * @param string $communicationPathway
     * @param bool $installWizard
     * @param string $installType
     * @param int $dealerCustomerSourceId
     * @param int $builderProgramId
     * @param \CustomerManagement\StructType\AddressWithName $customerAccountAddress
     * @param string $customerAccountEmail
     * @param string $customerAccountPhone
     * @param string $dealerCustomerId
     * @param string $desiredLoginName
     * @param string $desiredPassword
     * @param \CustomerManagement\StructType\Address $installationAddress
     * @param string $modemSerialNumber
     * @param string $unitDescription
     * @param string $installerCode
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $csEventGroupsToForward
     * @param string $centralStationAccountNumber
     * @param string $centralStationReceiverNumber
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum $customerNotifications
     * @param string $loginNameAtAuthenticationProvider
     * @param string $salesRepLoginName
     * @param string $installerLoginName
     * @param int $contractLengthInMonths
     * @param string $dealerCustomerSourceOther
     */
    public function __construct($installationTimeZone = null, $culture = null, $panelType = null, $panelVersion = null, $panelSettingTemplateId = null, $phoneLinePresent = null, $centralStationForwardingOption = null, $packageId = null, $ignoreLowCoverageErrors = null, $branchId = null, $leadId = null, $propertyType = null, $contractEndDate = null, $enrolledInMaintenance = null, $packageTemplateId = null, $hasInsuranceFeatures = null, $communicationPathway = null, $installWizard = null, $installType = null, $dealerCustomerSourceId = null, $builderProgramId = null, \CustomerManagement\StructType\AddressWithName $customerAccountAddress = null, $customerAccountEmail = null, $customerAccountPhone = null, $dealerCustomerId = null, $desiredLoginName = null, $desiredPassword = null, \CustomerManagement\StructType\Address $installationAddress = null, $modemSerialNumber = null, $unitDescription = null, $installerCode = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $csEventGroupsToForward = null, $centralStationAccountNumber = null, $centralStationReceiverNumber = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null, \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum $customerNotifications = null, $loginNameAtAuthenticationProvider = null, $salesRepLoginName = null, $installerLoginName = null, $contractLengthInMonths = 0, $dealerCustomerSourceOther = null)
    {
        $this
            ->setInstallationTimeZone($installationTimeZone)
            ->setCulture($culture)
            ->setPanelType($panelType)
            ->setPanelVersion($panelVersion)
            ->setPanelSettingTemplateId($panelSettingTemplateId)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setCentralStationForwardingOption($centralStationForwardingOption)
            ->setPackageId($packageId)
            ->setIgnoreLowCoverageErrors($ignoreLowCoverageErrors)
            ->setBranchId($branchId)
            ->setLeadId($leadId)
            ->setPropertyType($propertyType)
            ->setContractEndDate($contractEndDate)
            ->setEnrolledInMaintenance($enrolledInMaintenance)
            ->setPackageTemplateId($packageTemplateId)
            ->setHasInsuranceFeatures($hasInsuranceFeatures)
            ->setCommunicationPathway($communicationPathway)
            ->setInstallWizard($installWizard)
            ->setInstallType($installType)
            ->setDealerCustomerSourceId($dealerCustomerSourceId)
            ->setBuilderProgramId($builderProgramId)
            ->setCustomerAccountAddress($customerAccountAddress)
            ->setCustomerAccountEmail($customerAccountEmail)
            ->setCustomerAccountPhone($customerAccountPhone)
            ->setDealerCustomerId($dealerCustomerId)
            ->setDesiredLoginName($desiredLoginName)
            ->setDesiredPassword($desiredPassword)
            ->setInstallationAddress($installationAddress)
            ->setModemSerialNumber($modemSerialNumber)
            ->setUnitDescription($unitDescription)
            ->setInstallerCode($installerCode)
            ->setCsEventGroupsToForward($csEventGroupsToForward)
            ->setCentralStationAccountNumber($centralStationAccountNumber)
            ->setCentralStationReceiverNumber($centralStationReceiverNumber)
            ->setAddOnFeatures($addOnFeatures)
            ->setCustomerNotifications($customerNotifications)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider)
            ->setSalesRepLoginName($salesRepLoginName)
            ->setInstallerLoginName($installerLoginName)
            ->setContractLengthInMonths($contractLengthInMonths)
            ->setDealerCustomerSourceOther($dealerCustomerSourceOther);
    }
    /**
     * Get InstallationTimeZone value
     * @return string
     */
    public function getInstallationTimeZone()
    {
        return $this->InstallationTimeZone;
    }
    /**
     * Set InstallationTimeZone value
     * @uses \CustomerManagement\EnumType\TimeZoneEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TimeZoneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installationTimeZone
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallationTimeZone($installationTimeZone = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TimeZoneEnum::valueIsValid($installationTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TimeZoneEnum', is_array($installationTimeZone) ? implode(', ', $installationTimeZone) : var_export($installationTimeZone, true), implode(', ', \CustomerManagement\EnumType\TimeZoneEnum::getValidValues())), __LINE__);
        }
        $this->InstallationTimeZone = $installationTimeZone;
        return $this;
    }
    /**
     * Get Culture value
     * @return string
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @uses \CustomerManagement\EnumType\CultureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CultureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $culture
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CultureEnum::valueIsValid($culture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CultureEnum', is_array($culture) ? implode(', ', $culture) : var_export($culture, true), implode(', ', \CustomerManagement\EnumType\CultureEnum::getValidValues())), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get PanelType value
     * @return string
     */
    public function getPanelType()
    {
        return $this->PanelType;
    }
    /**
     * Set PanelType value
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelType
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPanelType($panelType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelTypeEnum::valueIsValid($panelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelTypeEnum', is_array($panelType) ? implode(', ', $panelType) : var_export($panelType, true), implode(', ', \CustomerManagement\EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->PanelType = $panelType;
        return $this;
    }
    /**
     * Get PanelVersion value
     * @return string
     */
    public function getPanelVersion()
    {
        return $this->PanelVersion;
    }
    /**
     * Set PanelVersion value
     * @uses \CustomerManagement\EnumType\PanelVersionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelVersionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelVersion
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPanelVersion($panelVersion = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelVersionEnum::valueIsValid($panelVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelVersionEnum', is_array($panelVersion) ? implode(', ', $panelVersion) : var_export($panelVersion, true), implode(', ', \CustomerManagement\EnumType\PanelVersionEnum::getValidValues())), __LINE__);
        }
        $this->PanelVersion = $panelVersion;
        return $this;
    }
    /**
     * Get panelSettingTemplateId value
     * @return int
     */
    public function getPanelSettingTemplateId()
    {
        return $this->panelSettingTemplateId;
    }
    /**
     * Set panelSettingTemplateId value
     * @param int $panelSettingTemplateId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPanelSettingTemplateId($panelSettingTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($panelSettingTemplateId) && !(is_int($panelSettingTemplateId) || ctype_digit($panelSettingTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelSettingTemplateId, true), gettype($panelSettingTemplateId)), __LINE__);
        }
        $this->panelSettingTemplateId = $panelSettingTemplateId;
        return $this;
    }
    /**
     * Get PhoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->PhoneLinePresent;
    }
    /**
     * Set PhoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneLinePresent) && !is_bool($phoneLinePresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneLinePresent, true), gettype($phoneLinePresent)), __LINE__);
        }
        $this->PhoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get CentralStationForwardingOption value
     * @return string
     */
    public function getCentralStationForwardingOption()
    {
        return $this->CentralStationForwardingOption;
    }
    /**
     * Set CentralStationForwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $centralStationForwardingOption
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCentralStationForwardingOption($centralStationForwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($centralStationForwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CentralStationForwardingOptionEnum', is_array($centralStationForwardingOption) ? implode(', ', $centralStationForwardingOption) : var_export($centralStationForwardingOption, true), implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->CentralStationForwardingOption = $centralStationForwardingOption;
        return $this;
    }
    /**
     * Get PackageId value
     * @return int
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get IgnoreLowCoverageErrors value
     * @return bool
     */
    public function getIgnoreLowCoverageErrors()
    {
        return $this->IgnoreLowCoverageErrors;
    }
    /**
     * Set IgnoreLowCoverageErrors value
     * @param bool $ignoreLowCoverageErrors
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setIgnoreLowCoverageErrors($ignoreLowCoverageErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreLowCoverageErrors) && !is_bool($ignoreLowCoverageErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreLowCoverageErrors, true), gettype($ignoreLowCoverageErrors)), __LINE__);
        }
        $this->IgnoreLowCoverageErrors = $ignoreLowCoverageErrors;
        return $this;
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get LeadId value
     * @return int
     */
    public function getLeadId()
    {
        return $this->LeadId;
    }
    /**
     * Set LeadId value
     * @param int $leadId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setLeadId($leadId = null)
    {
        // validation for constraint: int
        if (!is_null($leadId) && !(is_int($leadId) || ctype_digit($leadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadId, true), gettype($leadId)), __LINE__);
        }
        $this->LeadId = $leadId;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PropertyTypeEnum', is_array($propertyType) ? implode(', ', $propertyType) : var_export($propertyType, true), implode(', ', \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues())), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get ContractEndDate value
     * @return string
     */
    public function getContractEndDate()
    {
        return $this->ContractEndDate;
    }
    /**
     * Set ContractEndDate value
     * @param string $contractEndDate
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setContractEndDate($contractEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractEndDate) && !is_string($contractEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractEndDate, true), gettype($contractEndDate)), __LINE__);
        }
        $this->ContractEndDate = $contractEndDate;
        return $this;
    }
    /**
     * Get EnrolledInMaintenance value
     * @return bool
     */
    public function getEnrolledInMaintenance()
    {
        return $this->EnrolledInMaintenance;
    }
    /**
     * Set EnrolledInMaintenance value
     * @param bool $enrolledInMaintenance
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setEnrolledInMaintenance($enrolledInMaintenance = null)
    {
        // validation for constraint: boolean
        if (!is_null($enrolledInMaintenance) && !is_bool($enrolledInMaintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enrolledInMaintenance, true), gettype($enrolledInMaintenance)), __LINE__);
        }
        $this->EnrolledInMaintenance = $enrolledInMaintenance;
        return $this;
    }
    /**
     * Get PackageTemplateId value
     * @return int
     */
    public function getPackageTemplateId()
    {
        return $this->PackageTemplateId;
    }
    /**
     * Set PackageTemplateId value
     * @param int $packageTemplateId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setPackageTemplateId($packageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTemplateId) && !(is_int($packageTemplateId) || ctype_digit($packageTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTemplateId, true), gettype($packageTemplateId)), __LINE__);
        }
        $this->PackageTemplateId = $packageTemplateId;
        return $this;
    }
    /**
     * Get HasInsuranceFeatures value
     * @return bool
     */
    public function getHasInsuranceFeatures()
    {
        return $this->HasInsuranceFeatures;
    }
    /**
     * Set HasInsuranceFeatures value
     * @param bool $hasInsuranceFeatures
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setHasInsuranceFeatures($hasInsuranceFeatures = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasInsuranceFeatures) && !is_bool($hasInsuranceFeatures)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasInsuranceFeatures, true), gettype($hasInsuranceFeatures)), __LINE__);
        }
        $this->HasInsuranceFeatures = $hasInsuranceFeatures;
        return $this;
    }
    /**
     * Get CommunicationPathway value
     * @return string
     */
    public function getCommunicationPathway()
    {
        return $this->CommunicationPathway;
    }
    /**
     * Set CommunicationPathway value
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communicationPathway
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCommunicationPathway($communicationPathway = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DualPathModeEnum::valueIsValid($communicationPathway)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DualPathModeEnum', is_array($communicationPathway) ? implode(', ', $communicationPathway) : var_export($communicationPathway, true), implode(', ', \CustomerManagement\EnumType\DualPathModeEnum::getValidValues())), __LINE__);
        }
        $this->CommunicationPathway = $communicationPathway;
        return $this;
    }
    /**
     * Get InstallWizard value
     * @return bool
     */
    public function getInstallWizard()
    {
        return $this->InstallWizard;
    }
    /**
     * Set InstallWizard value
     * @param bool $installWizard
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallWizard($installWizard = null)
    {
        // validation for constraint: boolean
        if (!is_null($installWizard) && !is_bool($installWizard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($installWizard, true), gettype($installWizard)), __LINE__);
        }
        $this->InstallWizard = $installWizard;
        return $this;
    }
    /**
     * Get InstallType value
     * @return string
     */
    public function getInstallType()
    {
        return $this->InstallType;
    }
    /**
     * Set InstallType value
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installType
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallType($installType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid($installType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerInstallTypeEnum', is_array($installType) ? implode(', ', $installType) : var_export($installType, true), implode(', ', \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues())), __LINE__);
        }
        $this->InstallType = $installType;
        return $this;
    }
    /**
     * Get DealerCustomerSourceId value
     * @return int
     */
    public function getDealerCustomerSourceId()
    {
        return $this->DealerCustomerSourceId;
    }
    /**
     * Set DealerCustomerSourceId value
     * @param int $dealerCustomerSourceId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setDealerCustomerSourceId($dealerCustomerSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerCustomerSourceId) && !(is_int($dealerCustomerSourceId) || ctype_digit($dealerCustomerSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerCustomerSourceId, true), gettype($dealerCustomerSourceId)), __LINE__);
        }
        $this->DealerCustomerSourceId = $dealerCustomerSourceId;
        return $this;
    }
    /**
     * Get BuilderProgramId value
     * @return int
     */
    public function getBuilderProgramId()
    {
        return $this->BuilderProgramId;
    }
    /**
     * Set BuilderProgramId value
     * @param int $builderProgramId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setBuilderProgramId($builderProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($builderProgramId) && !(is_int($builderProgramId) || ctype_digit($builderProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($builderProgramId, true), gettype($builderProgramId)), __LINE__);
        }
        $this->BuilderProgramId = $builderProgramId;
        return $this;
    }
    /**
     * Get CustomerAccountAddress value
     * @return \CustomerManagement\StructType\AddressWithName|null
     */
    public function getCustomerAccountAddress()
    {
        return $this->CustomerAccountAddress;
    }
    /**
     * Set CustomerAccountAddress value
     * @param \CustomerManagement\StructType\AddressWithName $customerAccountAddress
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCustomerAccountAddress(\CustomerManagement\StructType\AddressWithName $customerAccountAddress = null)
    {
        $this->CustomerAccountAddress = $customerAccountAddress;
        return $this;
    }
    /**
     * Get CustomerAccountEmail value
     * @return string|null
     */
    public function getCustomerAccountEmail()
    {
        return $this->CustomerAccountEmail;
    }
    /**
     * Set CustomerAccountEmail value
     * @param string $customerAccountEmail
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCustomerAccountEmail($customerAccountEmail = null)
    {
        // validation for constraint: string
        if (!is_null($customerAccountEmail) && !is_string($customerAccountEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAccountEmail, true), gettype($customerAccountEmail)), __LINE__);
        }
        $this->CustomerAccountEmail = $customerAccountEmail;
        return $this;
    }
    /**
     * Get CustomerAccountPhone value
     * @return string|null
     */
    public function getCustomerAccountPhone()
    {
        return $this->CustomerAccountPhone;
    }
    /**
     * Set CustomerAccountPhone value
     * @param string $customerAccountPhone
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCustomerAccountPhone($customerAccountPhone = null)
    {
        // validation for constraint: string
        if (!is_null($customerAccountPhone) && !is_string($customerAccountPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAccountPhone, true), gettype($customerAccountPhone)), __LINE__);
        }
        $this->CustomerAccountPhone = $customerAccountPhone;
        return $this;
    }
    /**
     * Get DealerCustomerId value
     * @return string|null
     */
    public function getDealerCustomerId()
    {
        return $this->DealerCustomerId;
    }
    /**
     * Set DealerCustomerId value
     * @param string $dealerCustomerId
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setDealerCustomerId($dealerCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerId) && !is_string($dealerCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerCustomerId, true), gettype($dealerCustomerId)), __LINE__);
        }
        $this->DealerCustomerId = $dealerCustomerId;
        return $this;
    }
    /**
     * Get DesiredLoginName value
     * @return string|null
     */
    public function getDesiredLoginName()
    {
        return $this->DesiredLoginName;
    }
    /**
     * Set DesiredLoginName value
     * @param string $desiredLoginName
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setDesiredLoginName($desiredLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($desiredLoginName) && !is_string($desiredLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiredLoginName, true), gettype($desiredLoginName)), __LINE__);
        }
        $this->DesiredLoginName = $desiredLoginName;
        return $this;
    }
    /**
     * Get DesiredPassword value
     * @return string|null
     */
    public function getDesiredPassword()
    {
        return $this->DesiredPassword;
    }
    /**
     * Set DesiredPassword value
     * @param string $desiredPassword
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setDesiredPassword($desiredPassword = null)
    {
        // validation for constraint: string
        if (!is_null($desiredPassword) && !is_string($desiredPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiredPassword, true), gettype($desiredPassword)), __LINE__);
        }
        $this->DesiredPassword = $desiredPassword;
        return $this;
    }
    /**
     * Get InstallationAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallationAddress()
    {
        return $this->InstallationAddress;
    }
    /**
     * Set InstallationAddress value
     * @param \CustomerManagement\StructType\Address $installationAddress
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallationAddress(\CustomerManagement\StructType\Address $installationAddress = null)
    {
        $this->InstallationAddress = $installationAddress;
        return $this;
    }
    /**
     * Get ModemSerialNumber value
     * @return string|null
     */
    public function getModemSerialNumber()
    {
        return $this->ModemSerialNumber;
    }
    /**
     * Set ModemSerialNumber value
     * @param string $modemSerialNumber
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setModemSerialNumber($modemSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerialNumber) && !is_string($modemSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemSerialNumber, true), gettype($modemSerialNumber)), __LINE__);
        }
        $this->ModemSerialNumber = $modemSerialNumber;
        return $this;
    }
    /**
     * Get UnitDescription value
     * @return string|null
     */
    public function getUnitDescription()
    {
        return $this->UnitDescription;
    }
    /**
     * Set UnitDescription value
     * @param string $unitDescription
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setUnitDescription($unitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescription) && !is_string($unitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDescription, true), gettype($unitDescription)), __LINE__);
        }
        $this->UnitDescription = $unitDescription;
        return $this;
    }
    /**
     * Get InstallerCode value
     * @return string|null
     */
    public function getInstallerCode()
    {
        return $this->InstallerCode;
    }
    /**
     * Set InstallerCode value
     * @param string $installerCode
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallerCode($installerCode = null)
    {
        // validation for constraint: string
        if (!is_null($installerCode) && !is_string($installerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installerCode, true), gettype($installerCode)), __LINE__);
        }
        $this->InstallerCode = $installerCode;
        return $this;
    }
    /**
     * Get CsEventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getCsEventGroupsToForward()
    {
        return $this->CsEventGroupsToForward;
    }
    /**
     * Set CsEventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $csEventGroupsToForward
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCsEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $csEventGroupsToForward = null)
    {
        $this->CsEventGroupsToForward = $csEventGroupsToForward;
        return $this;
    }
    /**
     * Get CentralStationAccountNumber value
     * @return string|null
     */
    public function getCentralStationAccountNumber()
    {
        return $this->CentralStationAccountNumber;
    }
    /**
     * Set CentralStationAccountNumber value
     * @param string $centralStationAccountNumber
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCentralStationAccountNumber($centralStationAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($centralStationAccountNumber) && !is_string($centralStationAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralStationAccountNumber, true), gettype($centralStationAccountNumber)), __LINE__);
        }
        $this->CentralStationAccountNumber = $centralStationAccountNumber;
        return $this;
    }
    /**
     * Get CentralStationReceiverNumber value
     * @return string|null
     */
    public function getCentralStationReceiverNumber()
    {
        return $this->CentralStationReceiverNumber;
    }
    /**
     * Set CentralStationReceiverNumber value
     * @param string $centralStationReceiverNumber
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCentralStationReceiverNumber($centralStationReceiverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($centralStationReceiverNumber) && !is_string($centralStationReceiverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralStationReceiverNumber, true), gettype($centralStationReceiverNumber)), __LINE__);
        }
        $this->CentralStationReceiverNumber = $centralStationReceiverNumber;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
    /**
     * Get CustomerNotifications value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum|null
     */
    public function getCustomerNotifications()
    {
        return $this->CustomerNotifications;
    }
    /**
     * Set CustomerNotifications value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum $customerNotifications
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setCustomerNotifications(\CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum $customerNotifications = null)
    {
        $this->CustomerNotifications = $customerNotifications;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginNameAtAuthenticationProvider, true), gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Get SalesRepLoginName value
     * @return string|null
     */
    public function getSalesRepLoginName()
    {
        return $this->SalesRepLoginName;
    }
    /**
     * Set SalesRepLoginName value
     * @param string $salesRepLoginName
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setSalesRepLoginName($salesRepLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepLoginName) && !is_string($salesRepLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepLoginName, true), gettype($salesRepLoginName)), __LINE__);
        }
        $this->SalesRepLoginName = $salesRepLoginName;
        return $this;
    }
    /**
     * Get InstallerLoginName value
     * @return string|null
     */
    public function getInstallerLoginName()
    {
        return $this->InstallerLoginName;
    }
    /**
     * Set InstallerLoginName value
     * @param string $installerLoginName
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setInstallerLoginName($installerLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($installerLoginName) && !is_string($installerLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installerLoginName, true), gettype($installerLoginName)), __LINE__);
        }
        $this->InstallerLoginName = $installerLoginName;
        return $this;
    }
    /**
     * Get ContractLengthInMonths value
     * @return int|null
     */
    public function getContractLengthInMonths()
    {
        return $this->ContractLengthInMonths;
    }
    /**
     * Set ContractLengthInMonths value
     * @param int $contractLengthInMonths
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setContractLengthInMonths($contractLengthInMonths = 0)
    {
        // validation for constraint: int
        if (!is_null($contractLengthInMonths) && !(is_int($contractLengthInMonths) || ctype_digit($contractLengthInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contractLengthInMonths, true), gettype($contractLengthInMonths)), __LINE__);
        }
        $this->ContractLengthInMonths = $contractLengthInMonths;
        return $this;
    }
    /**
     * Get DealerCustomerSourceOther value
     * @return string|null
     */
    public function getDealerCustomerSourceOther()
    {
        return $this->DealerCustomerSourceOther;
    }
    /**
     * Set DealerCustomerSourceOther value
     * @param string $dealerCustomerSourceOther
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public function setDealerCustomerSourceOther($dealerCustomerSourceOther = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerSourceOther) && !is_string($dealerCustomerSourceOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerCustomerSourceOther, true), gettype($dealerCustomerSourceOther)), __LINE__);
        }
        $this->DealerCustomerSourceOther = $dealerCustomerSourceOther;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CreateCustomerInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
