<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for GsmTowerFrequencyEnum EnumType
 * @subpackage Enumerations
 */
class GsmTowerFrequencyEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'f850900MHz'
     * @return string 'f850900MHz'
     */
    const VALUE_F_850900_MHZ = 'f850900MHz';
    /**
     * Constant for value 'f19001800MHz'
     * @return string 'f19001800MHz'
     */
    const VALUE_F_19001800_MHZ = 'f19001800MHz';
    /**
     * Constant for value 'f850_3G'
     * @return string 'f850_3G'
     */
    const VALUE_F_850_3_G = 'f850_3G';
    /**
     * Constant for value 'f1900_3G'
     * @return string 'f1900_3G'
     */
    const VALUE_F_1900_3_G = 'f1900_3G';
    /**
     * Constant for value 'fAws'
     * @return string 'fAws'
     */
    const VALUE_F_AWS = 'fAws';
    /**
     * Constant for value 'LteAws1'
     * @return string 'LteAws1'
     */
    const VALUE_LTE_AWS_1 = 'LteAws1';
    /**
     * Constant for value 'Lte700C'
     * @return string 'Lte700C'
     */
    const VALUE_LTE_700_C = 'Lte700C';
    /**
     * Constant for value 'Freguency_3GLow'
     * @return string 'Freguency_3GLow'
     */
    const VALUE_FREGUENCY_3_GLOW = 'Freguency_3GLow';
    /**
     * Constant for value 'Freguency_3GHigh'
     * @return string 'Freguency_3GHigh'
     */
    const VALUE_FREGUENCY_3_GHIGH = 'Freguency_3GHigh';
    /**
     * Constant for value 'Freguency_3GAws'
     * @return string 'Freguency_3GAws'
     */
    const VALUE_FREGUENCY_3_GAWS = 'Freguency_3GAws';
    /**
     * Constant for value 'Freguency2100'
     * @return string 'Freguency2100'
     */
    const VALUE_FREGUENCY_2100 = 'Freguency2100';
    /**
     * Constant for value 'Freguency1900Pcs'
     * @return string 'Freguency1900Pcs'
     */
    const VALUE_FREGUENCY_1900_PCS = 'Freguency1900Pcs';
    /**
     * Constant for value 'Freguency1800Plus'
     * @return string 'Freguency1800Plus'
     */
    const VALUE_FREGUENCY_1800_PLUS = 'Freguency1800Plus';
    /**
     * Constant for value 'Aws1'
     * @return string 'Aws1'
     */
    const VALUE_AWS_1 = 'Aws1';
    /**
     * Constant for value 'Freguency850'
     * @return string 'Freguency850'
     */
    const VALUE_FREGUENCY_850 = 'Freguency850';
    /**
     * Constant for value 'UmtsOnly'
     * @return string 'UmtsOnly'
     */
    const VALUE_UMTS_ONLY = 'UmtsOnly';
    /**
     * Constant for value 'Freguency2600'
     * @return string 'Freguency2600'
     */
    const VALUE_FREGUENCY_2600 = 'Freguency2600';
    /**
     * Constant for value 'Freguency900Gsm'
     * @return string 'Freguency900Gsm'
     */
    const VALUE_FREGUENCY_900_GSM = 'Freguency900Gsm';
    /**
     * Constant for value 'Freguency1800'
     * @return string 'Freguency1800'
     */
    const VALUE_FREGUENCY_1800 = 'Freguency1800';
    /**
     * Constant for value 'Aws1Plus'
     * @return string 'Aws1Plus'
     */
    const VALUE_AWS_1_PLUS = 'Aws1Plus';
    /**
     * Constant for value 'Freguency1500Lower'
     * @return string 'Freguency1500Lower'
     */
    const VALUE_FREGUENCY_1500_LOWER = 'Freguency1500Lower';
    /**
     * Constant for value 'Freguency700A'
     * @return string 'Freguency700A'
     */
    const VALUE_FREGUENCY_700_A = 'Freguency700A';
    /**
     * Constant for value 'Freguency700C'
     * @return string 'Freguency700C'
     */
    const VALUE_FREGUENCY_700_C = 'Freguency700C';
    /**
     * Constant for value 'Freguency700Ps'
     * @return string 'Freguency700Ps'
     */
    const VALUE_FREGUENCY_700_PS = 'Freguency700Ps';
    /**
     * Constant for value 'Freguency700B'
     * @return string 'Freguency700B'
     */
    const VALUE_FREGUENCY_700_B = 'Freguency700B';
    /**
     * Constant for value 'Freguency800Lower'
     * @return string 'Freguency800Lower'
     */
    const VALUE_FREGUENCY_800_LOWER = 'Freguency800Lower';
    /**
     * Constant for value 'Freguency800Upper'
     * @return string 'Freguency800Upper'
     */
    const VALUE_FREGUENCY_800_UPPER = 'Freguency800Upper';
    /**
     * Constant for value 'Freguency800Dd'
     * @return string 'Freguency800Dd'
     */
    const VALUE_FREGUENCY_800_DD = 'Freguency800Dd';
    /**
     * Constant for value 'Freguency1500Upper'
     * @return string 'Freguency1500Upper'
     */
    const VALUE_FREGUENCY_1500_UPPER = 'Freguency1500Upper';
    /**
     * Constant for value 'Freguency3500'
     * @return string 'Freguency3500'
     */
    const VALUE_FREGUENCY_3500 = 'Freguency3500';
    /**
     * Constant for value 'Freguency2000SBand'
     * @return string 'Freguency2000SBand'
     */
    const VALUE_FREGUENCY_2000_SBAND = 'Freguency2000SBand';
    /**
     * Constant for value 'Freguency1600LBand'
     * @return string 'Freguency1600LBand'
     */
    const VALUE_FREGUENCY_1600_LBAND = 'Freguency1600LBand';
    /**
     * Constant for value 'Freguency1900Plus'
     * @return string 'Freguency1900Plus'
     */
    const VALUE_FREGUENCY_1900_PLUS = 'Freguency1900Plus';
    /**
     * Constant for value 'Freguency850Plus'
     * @return string 'Freguency850Plus'
     */
    const VALUE_FREGUENCY_850_PLUS = 'Freguency850Plus';
    /**
     * Constant for value 'Freguency800Smr'
     * @return string 'Freguency800Smr'
     */
    const VALUE_FREGUENCY_800_SMR = 'Freguency800Smr';
    /**
     * Constant for value 'Freguency700Apt'
     * @return string 'Freguency700Apt'
     */
    const VALUE_FREGUENCY_700_APT = 'Freguency700Apt';
    /**
     * Constant for value 'Freguency700D'
     * @return string 'Freguency700D'
     */
    const VALUE_FREGUENCY_700_D = 'Freguency700D';
    /**
     * Constant for value 'Freguency2300Wcs'
     * @return string 'Freguency2300Wcs'
     */
    const VALUE_FREGUENCY_2300_WCS = 'Freguency2300Wcs';
    /**
     * Constant for value 'Freguency450'
     * @return string 'Freguency450'
     */
    const VALUE_FREGUENCY_450 = 'Freguency450';
    /**
     * Constant for value 'Freguency1500LBand'
     * @return string 'Freguency1500LBand'
     */
    const VALUE_FREGUENCY_1500_LBAND = 'Freguency1500LBand';
    /**
     * Constant for value 'Td1900'
     * @return string 'Td1900'
     */
    const VALUE_TD_1900 = 'Td1900';
    /**
     * Constant for value 'Td2000'
     * @return string 'Td2000'
     */
    const VALUE_TD_2000 = 'Td2000';
    /**
     * Constant for value 'TdPcsLower'
     * @return string 'TdPcsLower'
     */
    const VALUE_TD_PCS_LOWER = 'TdPcsLower';
    /**
     * Constant for value 'TdPcsUpper'
     * @return string 'TdPcsUpper'
     */
    const VALUE_TD_PCS_UPPER = 'TdPcsUpper';
    /**
     * Constant for value 'TdPcsCenterGap'
     * @return string 'TdPcsCenterGap'
     */
    const VALUE_TD_PCS_CENTER_GAP = 'TdPcsCenterGap';
    /**
     * Constant for value 'Td2600'
     * @return string 'Td2600'
     */
    const VALUE_TD_2600 = 'Td2600';
    /**
     * Constant for value 'Td1900Plus'
     * @return string 'Td1900Plus'
     */
    const VALUE_TD_1900_PLUS = 'Td1900Plus';
    /**
     * Constant for value 'Td2300'
     * @return string 'Td2300'
     */
    const VALUE_TD_2300 = 'Td2300';
    /**
     * Constant for value 'Td2500'
     * @return string 'Td2500'
     */
    const VALUE_TD_2500 = 'Td2500';
    /**
     * Constant for value 'Td3500'
     * @return string 'Td3500'
     */
    const VALUE_TD_3500 = 'Td3500';
    /**
     * Constant for value 'Td3700'
     * @return string 'Td3700'
     */
    const VALUE_TD_3700 = 'Td3700';
    /**
     * Constant for value 'Td700'
     * @return string 'Td700'
     */
    const VALUE_TD_700 = 'Td700';
    /**
     * Constant for value 'Td1500'
     * @return string 'Td1500'
     */
    const VALUE_TD_1500 = 'Td1500';
    /**
     * Constant for value 'TdUnlicensed'
     * @return string 'TdUnlicensed'
     */
    const VALUE_TD_UNLICENSED = 'TdUnlicensed';
    /**
     * Constant for value 'TdV2X'
     * @return string 'TdV2X'
     */
    const VALUE_TD_V_2_X = 'TdV2X';
    /**
     * Constant for value 'Td3600'
     * @return string 'Td3600'
     */
    const VALUE_TD_3600 = 'Td3600';
    /**
     * Constant for value 'Freguency2100Plus'
     * @return string 'Freguency2100Plus'
     */
    const VALUE_FREGUENCY_2100_PLUS = 'Freguency2100Plus';
    /**
     * Constant for value 'Aws3'
     * @return string 'Aws3'
     */
    const VALUE_AWS_3 = 'Aws3';
    /**
     * Constant for value 'Freguency700Eu'
     * @return string 'Freguency700Eu'
     */
    const VALUE_FREGUENCY_700_EU = 'Freguency700Eu';
    /**
     * Constant for value 'Freguency700Me'
     * @return string 'Freguency700Me'
     */
    const VALUE_FREGUENCY_700_ME = 'Freguency700Me';
    /**
     * Constant for value 'Freguency2500'
     * @return string 'Freguency2500'
     */
    const VALUE_FREGUENCY_2500 = 'Freguency2500';
    /**
     * Constant for value 'Aws4'
     * @return string 'Aws4'
     */
    const VALUE_AWS_4 = 'Aws4';
    /**
     * Constant for value 'UnlicensedNii1'
     * @return string 'UnlicensedNii1'
     */
    const VALUE_UNLICENSED_NII_1 = 'UnlicensedNii1';
    /**
     * Constant for value 'UnlicensedNii3'
     * @return string 'UnlicensedNii3'
     */
    const VALUE_UNLICENSED_NII_3 = 'UnlicensedNii3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_F_850900_MHZ
     * @uses self::VALUE_F_19001800_MHZ
     * @uses self::VALUE_F_850_3_G
     * @uses self::VALUE_F_1900_3_G
     * @uses self::VALUE_F_AWS
     * @uses self::VALUE_LTE_AWS_1
     * @uses self::VALUE_LTE_700_C
     * @uses self::VALUE_FREGUENCY_3_GLOW
     * @uses self::VALUE_FREGUENCY_3_GHIGH
     * @uses self::VALUE_FREGUENCY_3_GAWS
     * @uses self::VALUE_FREGUENCY_2100
     * @uses self::VALUE_FREGUENCY_1900_PCS
     * @uses self::VALUE_FREGUENCY_1800_PLUS
     * @uses self::VALUE_AWS_1
     * @uses self::VALUE_FREGUENCY_850
     * @uses self::VALUE_UMTS_ONLY
     * @uses self::VALUE_FREGUENCY_2600
     * @uses self::VALUE_FREGUENCY_900_GSM
     * @uses self::VALUE_FREGUENCY_1800
     * @uses self::VALUE_AWS_1_PLUS
     * @uses self::VALUE_FREGUENCY_1500_LOWER
     * @uses self::VALUE_FREGUENCY_700_A
     * @uses self::VALUE_FREGUENCY_700_C
     * @uses self::VALUE_FREGUENCY_700_PS
     * @uses self::VALUE_FREGUENCY_700_B
     * @uses self::VALUE_FREGUENCY_800_LOWER
     * @uses self::VALUE_FREGUENCY_800_UPPER
     * @uses self::VALUE_FREGUENCY_800_DD
     * @uses self::VALUE_FREGUENCY_1500_UPPER
     * @uses self::VALUE_FREGUENCY_3500
     * @uses self::VALUE_FREGUENCY_2000_SBAND
     * @uses self::VALUE_FREGUENCY_1600_LBAND
     * @uses self::VALUE_FREGUENCY_1900_PLUS
     * @uses self::VALUE_FREGUENCY_850_PLUS
     * @uses self::VALUE_FREGUENCY_800_SMR
     * @uses self::VALUE_FREGUENCY_700_APT
     * @uses self::VALUE_FREGUENCY_700_D
     * @uses self::VALUE_FREGUENCY_2300_WCS
     * @uses self::VALUE_FREGUENCY_450
     * @uses self::VALUE_FREGUENCY_1500_LBAND
     * @uses self::VALUE_TD_1900
     * @uses self::VALUE_TD_2000
     * @uses self::VALUE_TD_PCS_LOWER
     * @uses self::VALUE_TD_PCS_UPPER
     * @uses self::VALUE_TD_PCS_CENTER_GAP
     * @uses self::VALUE_TD_2600
     * @uses self::VALUE_TD_1900_PLUS
     * @uses self::VALUE_TD_2300
     * @uses self::VALUE_TD_2500
     * @uses self::VALUE_TD_3500
     * @uses self::VALUE_TD_3700
     * @uses self::VALUE_TD_700
     * @uses self::VALUE_TD_1500
     * @uses self::VALUE_TD_UNLICENSED
     * @uses self::VALUE_TD_V_2_X
     * @uses self::VALUE_TD_3600
     * @uses self::VALUE_FREGUENCY_2100_PLUS
     * @uses self::VALUE_AWS_3
     * @uses self::VALUE_FREGUENCY_700_EU
     * @uses self::VALUE_FREGUENCY_700_ME
     * @uses self::VALUE_FREGUENCY_2500
     * @uses self::VALUE_AWS_4
     * @uses self::VALUE_UNLICENSED_NII_1
     * @uses self::VALUE_UNLICENSED_NII_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_F_850900_MHZ,
            self::VALUE_F_19001800_MHZ,
            self::VALUE_F_850_3_G,
            self::VALUE_F_1900_3_G,
            self::VALUE_F_AWS,
            self::VALUE_LTE_AWS_1,
            self::VALUE_LTE_700_C,
            self::VALUE_FREGUENCY_3_GLOW,
            self::VALUE_FREGUENCY_3_GHIGH,
            self::VALUE_FREGUENCY_3_GAWS,
            self::VALUE_FREGUENCY_2100,
            self::VALUE_FREGUENCY_1900_PCS,
            self::VALUE_FREGUENCY_1800_PLUS,
            self::VALUE_AWS_1,
            self::VALUE_FREGUENCY_850,
            self::VALUE_UMTS_ONLY,
            self::VALUE_FREGUENCY_2600,
            self::VALUE_FREGUENCY_900_GSM,
            self::VALUE_FREGUENCY_1800,
            self::VALUE_AWS_1_PLUS,
            self::VALUE_FREGUENCY_1500_LOWER,
            self::VALUE_FREGUENCY_700_A,
            self::VALUE_FREGUENCY_700_C,
            self::VALUE_FREGUENCY_700_PS,
            self::VALUE_FREGUENCY_700_B,
            self::VALUE_FREGUENCY_800_LOWER,
            self::VALUE_FREGUENCY_800_UPPER,
            self::VALUE_FREGUENCY_800_DD,
            self::VALUE_FREGUENCY_1500_UPPER,
            self::VALUE_FREGUENCY_3500,
            self::VALUE_FREGUENCY_2000_SBAND,
            self::VALUE_FREGUENCY_1600_LBAND,
            self::VALUE_FREGUENCY_1900_PLUS,
            self::VALUE_FREGUENCY_850_PLUS,
            self::VALUE_FREGUENCY_800_SMR,
            self::VALUE_FREGUENCY_700_APT,
            self::VALUE_FREGUENCY_700_D,
            self::VALUE_FREGUENCY_2300_WCS,
            self::VALUE_FREGUENCY_450,
            self::VALUE_FREGUENCY_1500_LBAND,
            self::VALUE_TD_1900,
            self::VALUE_TD_2000,
            self::VALUE_TD_PCS_LOWER,
            self::VALUE_TD_PCS_UPPER,
            self::VALUE_TD_PCS_CENTER_GAP,
            self::VALUE_TD_2600,
            self::VALUE_TD_1900_PLUS,
            self::VALUE_TD_2300,
            self::VALUE_TD_2500,
            self::VALUE_TD_3500,
            self::VALUE_TD_3700,
            self::VALUE_TD_700,
            self::VALUE_TD_1500,
            self::VALUE_TD_UNLICENSED,
            self::VALUE_TD_V_2_X,
            self::VALUE_TD_3600,
            self::VALUE_FREGUENCY_2100_PLUS,
            self::VALUE_AWS_3,
            self::VALUE_FREGUENCY_700_EU,
            self::VALUE_FREGUENCY_700_ME,
            self::VALUE_FREGUENCY_2500,
            self::VALUE_AWS_4,
            self::VALUE_UNLICENSED_NII_1,
            self::VALUE_UNLICENSED_NII_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
