<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerSecurityQuestionInput StructType
 * @subpackage Structs
 */
class UpdateCustomerSecurityQuestionInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SecurityQuestionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityQuestionId;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer;
    /**
     * Constructor method for UpdateCustomerSecurityQuestionInput
     * @uses UpdateCustomerSecurityQuestionInput::setCustomerId()
     * @uses UpdateCustomerSecurityQuestionInput::setSecurityQuestionId()
     * @uses UpdateCustomerSecurityQuestionInput::setLoginName()
     * @uses UpdateCustomerSecurityQuestionInput::setAnswer()
     * @param int $customerId
     * @param int $securityQuestionId
     * @param string $loginName
     * @param string $answer
     */
    public function __construct($customerId = null, $securityQuestionId = null, $loginName = null, $answer = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSecurityQuestionId($securityQuestionId)
            ->setLoginName($loginName)
            ->setAnswer($answer);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SecurityQuestionId value
     * @return int
     */
    public function getSecurityQuestionId()
    {
        return $this->SecurityQuestionId;
    }
    /**
     * Set SecurityQuestionId value
     * @param int $securityQuestionId
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionInput
     */
    public function setSecurityQuestionId($securityQuestionId = null)
    {
        // validation for constraint: int
        if (!is_null($securityQuestionId) && !(is_int($securityQuestionId) || ctype_digit($securityQuestionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($securityQuestionId, true), gettype($securityQuestionId)), __LINE__);
        }
        $this->SecurityQuestionId = $securityQuestionId;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionInput
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionInput
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
