<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerLogin StructType
 * @subpackage Structs
 */
class UpdateCustomerLogin extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newLogin;
    /**
     * Constructor method for UpdateCustomerLogin
     * @uses UpdateCustomerLogin::setCustomerId()
     * @uses UpdateCustomerLogin::setNewLogin()
     * @param int $customerId
     * @param string $newLogin
     */
    public function __construct($customerId = null, $newLogin = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewLogin($newLogin);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerLogin
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newLogin value
     * @return string|null
     */
    public function getNewLogin()
    {
        return $this->newLogin;
    }
    /**
     * Set newLogin value
     * @param string $newLogin
     * @return \CustomerManagement\StructType\UpdateCustomerLogin
     */
    public function setNewLogin($newLogin = null)
    {
        // validation for constraint: string
        if (!is_null($newLogin) && !is_string($newLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLogin, true), gettype($newLogin)), __LINE__);
        }
        $this->newLogin = $newLogin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerLogin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
